/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl;

import io.agroal.api.AgroalDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.ProtocolConfiguration;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.JGroupsStackConfigurator;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.JGroupsUtil;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl.KEYCLOAK_JDBC_PING2;

public class JGroupsJdbcPingStackConfigurator
implements JGroupsStackConfigurator {
    public static final JGroupsStackConfigurator INSTANCE = new JGroupsJdbcPingStackConfigurator();

    private JGroupsJdbcPingStackConfigurator() {
    }

    @Override
    public boolean requiresKeycloakSession() {
        return true;
    }

    @Override
    public void configure(ConfigurationBuilderHolder holder, KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        String stackName = (String)JGroupsUtil.transportStackOf(holder).get();
        boolean isUdp = stackName.endsWith("udp");
        String tableName = JpaUtils.getTableNameForNativeQuery((String)"JGROUPS_PING", (EntityManager)em);
        List<ProtocolConfiguration> stack = JGroupsJdbcPingStackConfigurator.getProtocolConfigurations(tableName, isUdp ? "PING" : "MPING");
        holder.addJGroupsStack(new EmbeddedJGroupsChannelConfigurator(stackName, stack, null), isUdp ? "udp" : "tcp");
        Supplier<DataSource> dataSourceSupplier = () -> ((InjectableInstance)Arc.container().select(AgroalDataSource.class, new Annotation[0])).get();
        JGroupsUtil.transportOf(holder).addProperty("dataSource", dataSourceSupplier);
        JGroupsUtil.transportOf(holder).stack(stackName);
        CacheManagerFactory.logger.info((Object)"JGroups JDBC_PING discovery enabled.");
    }

    private static List<ProtocolConfiguration> getProtocolConfigurations(String tableName, String discoveryProtocol) {
        Map<String, String> attributes = Map.of("initialize_sql", "", "clear_sql", String.format("DELETE from %s WHERE cluster_name=?", tableName), "delete_single_sql", String.format("DELETE from %s WHERE address=?", tableName), "insert_single_sql", String.format("INSERT INTO %s values (?, ?, ?, ?, ?)", tableName), "select_all_pingdata_sql", String.format("SELECT address, name, ip, coord FROM %s WHERE cluster_name=?", tableName), "remove_all_data_on_view_change", "true", "register_shutdown_hook", "false", "stack.combine", "REPLACE", "stack.position", discoveryProtocol);
        ClassConfigurator.addProtocol((short)1025, KEYCLOAK_JDBC_PING2.class);
        return List.of(new ProtocolConfiguration(KEYCLOAK_JDBC_PING2.class.getName(), attributes));
    }
}

