/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan.jgroups;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.TCP_NIO2;
import org.jgroups.protocols.UDP;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;

public final class JGroupsUtil {
    private JGroupsUtil() {
    }

    public static TransportConfigurationBuilder transportOf(ConfigurationBuilderHolder holder) {
        return holder.getGlobalConfigurationBuilder().transport();
    }

    public static Attribute<String> transportStackOf(ConfigurationBuilderHolder holder) {
        TransportConfigurationBuilder transport = JGroupsUtil.transportOf(holder);
        assert (transport != null);
        return transport.attributes().attribute(TransportConfiguration.STACK);
    }

    public static void warnDeprecatedStack(ConfigurationBuilderHolder holder) {
        String stackName;
        switch (stackName = (String)JGroupsUtil.transportStackOf(holder).get()) {
            case "jdbc-ping-udp": 
            case "tcp": 
            case "udp": 
            case "azure": 
            case "ec2": 
            case "google": {
                CacheManagerFactory.logger.warnf("Stack '%s' is deprecated. We recommend to use 'jdbc-ping' instead", (Object)stackName);
            }
        }
    }

    public static void validateTlsAvailable(ConfigurationBuilderHolder holder) {
        String stackName = (String)JGroupsUtil.transportStackOf(holder).get();
        if (stackName == null) {
            return;
        }
        GlobalConfiguration config = JGroupsUtil.transportOf(holder).build();
        for (ProtocolConfiguration protocol : config.transport().jgroups().configurator(stackName).getProtocolStack()) {
            String name = protocol.getProtocolName();
            if (!name.equals(UDP.class.getSimpleName()) && !name.equals(UDP.class.getName()) && !name.equals(TCP_NIO2.class.getSimpleName()) && !name.equals(TCP_NIO2.class.getName())) continue;
            throw new RuntimeException("Cache TLS is not available with protocol " + name);
        }
    }
}

