/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.UriUtils;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionNoteDescriptor;
import org.keycloak.models.utils.DefaultClientScopes;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.protocol.mappers.oidc.OrganizationMembershipMapper;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.OIDCProviderConfig;
import org.keycloak.protocol.oidc.mappers.AcrProtocolMapper;
import org.keycloak.protocol.oidc.mappers.AddressMapper;
import org.keycloak.protocol.oidc.mappers.AllowedWebOriginsProtocolMapper;
import org.keycloak.protocol.oidc.mappers.AudienceResolveProtocolMapper;
import org.keycloak.protocol.oidc.mappers.FullNameMapper;
import org.keycloak.protocol.oidc.mappers.SubMapper;
import org.keycloak.protocol.oidc.mappers.UserAttributeMapper;
import org.keycloak.protocol.oidc.mappers.UserClientRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.UserPropertyMapper;
import org.keycloak.protocol.oidc.mappers.UserRealmRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.UserSessionNoteMapper;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ServicesLogger;

public class OIDCLoginProtocolFactory
extends AbstractLoginProtocolFactory {
    private static final Logger logger = Logger.getLogger(OIDCLoginProtocolFactory.class);
    public static final String USERNAME = "username";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email verified";
    public static final String GIVEN_NAME = "given name";
    public static final String FAMILY_NAME = "family name";
    public static final String MIDDLE_NAME = "middle name";
    public static final String NICKNAME = "nickname";
    public static final String PROFILE_CLAIM = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String UPDATED_AT = "updated at";
    public static final String FULL_NAME = "full name";
    public static final String LOCALE = "locale";
    public static final String ADDRESS = "address";
    public static final String PHONE_NUMBER = "phone number";
    public static final String PHONE_NUMBER_VERIFIED = "phone number verified";
    public static final String REALM_ROLES = "realm roles";
    public static final String CLIENT_ROLES = "client roles";
    public static final String AUDIENCE_RESOLVE = "audience resolve";
    public static final String ALLOWED_WEB_ORIGINS = "allowed web origins";
    public static final String ACR = "acr loa level";
    public static final String ORGANIZATION = "organization";
    public static final String UPN = "upn";
    public static final String GROUPS = "groups";
    public static final String ROLES_SCOPE = "roles";
    public static final String WEB_ORIGINS_SCOPE = "web-origins";
    public static final String MICROPROFILE_JWT_SCOPE = "microprofile-jwt";
    public static final String ACR_SCOPE = "acr";
    public static final String BASIC_SCOPE = "basic";
    public static final String PROFILE_SCOPE_CONSENT_TEXT = "${profileScopeConsentText}";
    public static final String EMAIL_SCOPE_CONSENT_TEXT = "${emailScopeConsentText}";
    public static final String ADDRESS_SCOPE_CONSENT_TEXT = "${addressScopeConsentText}";
    public static final String PHONE_SCOPE_CONSENT_TEXT = "${phoneScopeConsentText}";
    public static final String OFFLINE_ACCESS_SCOPE_CONSENT_TEXT = "${offlineAccessScopeConsentText}";
    public static final String ROLES_SCOPE_CONSENT_TEXT = "${rolesScopeConsentText}";
    public static final String ORGANIZATION_SCOPE_CONSENT_TEXT = "${organizationScopeConsentText}";
    public static final String CONFIG_OIDC_REQ_PARAMS_MAX_NUMBER = "add-req-params-max-number";
    public static final String CONFIG_OIDC_REQ_PARAMS_MAX_SIZE = "add-req-params-max-size";
    public static final String CONFIG_OIDC_REQ_PARAMS_MAX_OVERALL_SIZE = "add-req-params-max-overall-size";
    public static final String CONFIG_OIDC_REQ_PARAMS_FAIL_FAST = "add-req-params-fail-fast";
    public static final String CONFIG_OIDC_ALLOW_MULTIPLE_AUDIENCES_FOR_JWT_CLIENT_AUTHENTICATION = "allow-multiple-audiences-for-jwt-client-authentication";
    private OIDCProviderConfig providerConfig;
    private Map<String, ProtocolMapperModel> builtins = new HashMap<String, ProtocolMapperModel>();

    public void init(Config.Scope config) {
        this.providerConfig = new OIDCProviderConfig(config);
        if (this.providerConfig.isAllowMultipleAudiencesForJwtClientAuthentication()) {
            logger.warnf("It is allowed to have multiple audiences for the JWT client authentication. This option is not recommended and will be removed in one of the future releases. It is recommended to update your OAuth/OIDC clients to rather use single audience in the JWT token used for the client authentication.", new Object[0]);
        }
        this.initBuiltIns();
    }

    public LoginProtocol create(KeycloakSession session) {
        return new OIDCLoginProtocol(this.providerConfig).setSession(session);
    }

    public Map<String, ProtocolMapperModel> getBuiltinMappers() {
        return this.builtins;
    }

    void initBuiltIns() {
        ProtocolMapperModel model = UserAttributeMapper.createClaimMapper(USERNAME, USERNAME, "preferred_username", String.class.getSimpleName(), true, true, true);
        this.builtins.put(USERNAME, model);
        model = UserAttributeMapper.createClaimMapper(EMAIL, EMAIL, EMAIL, "String", true, true, true);
        this.builtins.put(EMAIL, model);
        model = UserAttributeMapper.createClaimMapper(GIVEN_NAME, "firstName", "given_name", "String", true, true, true);
        this.builtins.put(GIVEN_NAME, model);
        model = UserAttributeMapper.createClaimMapper(FAMILY_NAME, "lastName", "family_name", "String", true, true, true);
        this.builtins.put(FAMILY_NAME, model);
        this.createUserAttributeMapper(MIDDLE_NAME, "middleName", "middle_name", "String");
        this.createUserAttributeMapper(NICKNAME, NICKNAME, NICKNAME, "String");
        this.createUserAttributeMapper(PROFILE_CLAIM, PROFILE_CLAIM, PROFILE_CLAIM, "String");
        this.createUserAttributeMapper(PICTURE, PICTURE, PICTURE, "String");
        this.createUserAttributeMapper(WEBSITE, WEBSITE, WEBSITE, "String");
        this.createUserAttributeMapper(GENDER, GENDER, GENDER, "String");
        this.createUserAttributeMapper(BIRTHDATE, BIRTHDATE, BIRTHDATE, "String");
        this.createUserAttributeMapper(ZONEINFO, ZONEINFO, ZONEINFO, "String");
        this.createUserAttributeMapper(UPDATED_AT, "updatedAt", "updated_at", "long");
        this.createUserAttributeMapper(LOCALE, LOCALE, LOCALE, "String");
        this.createUserAttributeMapper(PHONE_NUMBER, "phoneNumber", "phone_number", "String");
        this.createUserAttributeMapper(PHONE_NUMBER_VERIFIED, "phoneNumberVerified", "phone_number_verified", "boolean");
        model = UserPropertyMapper.createClaimMapper(EMAIL_VERIFIED, "emailVerified", "email_verified", "boolean", true, true, true);
        this.builtins.put(EMAIL_VERIFIED, model);
        ProtocolMapperModel fullName = FullNameMapper.create(FULL_NAME, true, true, true, true);
        this.builtins.put(FULL_NAME, fullName);
        ProtocolMapperModel address = AddressMapper.createAddressMapper();
        this.builtins.put(ADDRESS, address);
        model = UserSessionNoteMapper.createClaimMapper("gss delegation credential", "gss_delegation_credential", "gss_delegation_credential", "String", true, false, true);
        this.builtins.put("gss_delegation_credential", model);
        model = UserRealmRoleMappingMapper.create(null, REALM_ROLES, "realm_access.roles", true, false, true, true);
        this.builtins.put(REALM_ROLES, model);
        model = UserClientRoleMappingMapper.create(null, null, CLIENT_ROLES, "resource_access.${client_id}.roles", true, false, true, true);
        this.builtins.put(CLIENT_ROLES, model);
        model = AudienceResolveProtocolMapper.createClaimMapper(AUDIENCE_RESOLVE, true, true);
        this.builtins.put(AUDIENCE_RESOLVE, model);
        model = AllowedWebOriginsProtocolMapper.createClaimMapper(ALLOWED_WEB_ORIGINS, true, true);
        this.builtins.put(ALLOWED_WEB_ORIGINS, model);
        this.builtins.put(ImpersonationSessionNote.IMPERSONATOR_ID.getDisplayName(), UserSessionNoteMapper.createUserSessionNoteMapper((UserSessionNoteDescriptor)ImpersonationSessionNote.IMPERSONATOR_ID));
        this.builtins.put(ImpersonationSessionNote.IMPERSONATOR_USERNAME.getDisplayName(), UserSessionNoteMapper.createUserSessionNoteMapper((UserSessionNoteDescriptor)ImpersonationSessionNote.IMPERSONATOR_USERNAME));
        model = UserAttributeMapper.createClaimMapper(UPN, USERNAME, UPN, "String", true, true, true);
        this.builtins.put(UPN, model);
        model = UserRealmRoleMappingMapper.create(null, GROUPS, GROUPS, true, true, true, true);
        this.builtins.put(GROUPS, model);
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.STEP_UP_AUTHENTICATION)) {
            model = AcrProtocolMapper.create(ACR, true, true, true);
            this.builtins.put(ACR, model);
        }
        model = UserSessionNoteMapper.createClaimMapper("auth_time", "AUTH_TIME", "auth_time", "long", true, true, false, true);
        this.builtins.put("auth_time", model);
        model = SubMapper.create("sub", true, true);
        this.builtins.put("sub", model);
    }

    private void createUserAttributeMapper(String name, String attrName, String claimName, String type) {
        ProtocolMapperModel model = UserAttributeMapper.createClaimMapper(name, attrName, claimName, type, true, true, true, false);
        this.builtins.put(name, model);
    }

    protected void createDefaultClientScopesImpl(RealmModel newRealm) {
        ClientScopeModel offlineAccessScope;
        ClientScopeModel profileScope = newRealm.addClientScope(PROFILE_CLAIM);
        profileScope.setDescription("OpenID Connect built-in scope: profile");
        profileScope.setDisplayOnConsentScreen(true);
        profileScope.setConsentScreenText(PROFILE_SCOPE_CONSENT_TEXT);
        profileScope.setIncludeInTokenScope(true);
        profileScope.setProtocol(this.getId());
        profileScope.addProtocolMapper(this.builtins.get(FULL_NAME));
        profileScope.addProtocolMapper(this.builtins.get(FAMILY_NAME));
        profileScope.addProtocolMapper(this.builtins.get(GIVEN_NAME));
        profileScope.addProtocolMapper(this.builtins.get(MIDDLE_NAME));
        profileScope.addProtocolMapper(this.builtins.get(NICKNAME));
        profileScope.addProtocolMapper(this.builtins.get(USERNAME));
        profileScope.addProtocolMapper(this.builtins.get(PROFILE_CLAIM));
        profileScope.addProtocolMapper(this.builtins.get(PICTURE));
        profileScope.addProtocolMapper(this.builtins.get(WEBSITE));
        profileScope.addProtocolMapper(this.builtins.get(GENDER));
        profileScope.addProtocolMapper(this.builtins.get(BIRTHDATE));
        profileScope.addProtocolMapper(this.builtins.get(ZONEINFO));
        profileScope.addProtocolMapper(this.builtins.get(LOCALE));
        profileScope.addProtocolMapper(this.builtins.get(UPDATED_AT));
        ClientScopeModel emailScope = newRealm.addClientScope(EMAIL);
        emailScope.setDescription("OpenID Connect built-in scope: email");
        emailScope.setDisplayOnConsentScreen(true);
        emailScope.setConsentScreenText(EMAIL_SCOPE_CONSENT_TEXT);
        emailScope.setIncludeInTokenScope(true);
        emailScope.setProtocol(this.getId());
        emailScope.addProtocolMapper(this.builtins.get(EMAIL));
        emailScope.addProtocolMapper(this.builtins.get(EMAIL_VERIFIED));
        ClientScopeModel addressScope = newRealm.addClientScope(ADDRESS);
        addressScope.setDescription("OpenID Connect built-in scope: address");
        addressScope.setDisplayOnConsentScreen(true);
        addressScope.setConsentScreenText(ADDRESS_SCOPE_CONSENT_TEXT);
        addressScope.setIncludeInTokenScope(true);
        addressScope.setProtocol(this.getId());
        addressScope.addProtocolMapper(this.builtins.get(ADDRESS));
        ClientScopeModel phoneScope = newRealm.addClientScope("phone");
        phoneScope.setDescription("OpenID Connect built-in scope: phone");
        phoneScope.setDisplayOnConsentScreen(true);
        phoneScope.setConsentScreenText(PHONE_SCOPE_CONSENT_TEXT);
        phoneScope.setIncludeInTokenScope(true);
        phoneScope.setProtocol(this.getId());
        phoneScope.addProtocolMapper(this.builtins.get(PHONE_NUMBER));
        phoneScope.addProtocolMapper(this.builtins.get(PHONE_NUMBER_VERIFIED));
        newRealm.addDefaultClientScope(profileScope, true);
        newRealm.addDefaultClientScope(emailScope, true);
        newRealm.addDefaultClientScope(addressScope, false);
        newRealm.addDefaultClientScope(phoneScope, false);
        RoleModel offlineRole = newRealm.getRole("offline_access");
        if (offlineRole != null && (offlineAccessScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)"offline_access")) == null) {
            DefaultClientScopes.createOfflineAccessClientScope((RealmModel)newRealm, (RoleModel)offlineRole);
        }
        this.addRolesClientScope(newRealm);
        this.addWebOriginsClientScope(newRealm);
        this.addMicroprofileJWTClientScope(newRealm);
        this.addAcrClientScope(newRealm);
        this.addBasicClientScope(newRealm);
        this.addServiceAccountClientScope(newRealm);
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            ClientScopeModel organizationScope = newRealm.addClientScope(ORGANIZATION);
            organizationScope.setDescription("Additional claims about the organization a subject belongs to");
            organizationScope.setDisplayOnConsentScreen(true);
            organizationScope.setConsentScreenText(ORGANIZATION_SCOPE_CONSENT_TEXT);
            organizationScope.setIncludeInTokenScope(true);
            organizationScope.setProtocol(this.getId());
            organizationScope.addProtocolMapper(OrganizationMembershipMapper.create(ORGANIZATION, true, true, true));
            newRealm.addDefaultClientScope(organizationScope, false);
        }
    }

    public ClientScopeModel addRolesClientScope(RealmModel newRealm) {
        ClientScopeModel rolesScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)ROLES_SCOPE);
        if (rolesScope == null) {
            rolesScope = newRealm.addClientScope(ROLES_SCOPE);
            rolesScope.setDescription("OpenID Connect scope for add user roles to the access token");
            rolesScope.setDisplayOnConsentScreen(true);
            rolesScope.setConsentScreenText(ROLES_SCOPE_CONSENT_TEXT);
            rolesScope.setIncludeInTokenScope(false);
            rolesScope.setProtocol("openid-connect");
            rolesScope.addProtocolMapper(this.builtins.get(REALM_ROLES));
            rolesScope.addProtocolMapper(this.builtins.get(CLIENT_ROLES));
            rolesScope.addProtocolMapper(this.builtins.get(AUDIENCE_RESOLVE));
            newRealm.addDefaultClientScope(rolesScope, true);
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)ROLES_SCOPE, (Object)newRealm.getName());
        }
        return rolesScope;
    }

    public ClientScopeModel addWebOriginsClientScope(RealmModel newRealm) {
        ClientScopeModel originsScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)WEB_ORIGINS_SCOPE);
        if (originsScope == null) {
            originsScope = newRealm.addClientScope(WEB_ORIGINS_SCOPE);
            originsScope.setDescription("OpenID Connect scope for add allowed web origins to the access token");
            originsScope.setDisplayOnConsentScreen(false);
            originsScope.setConsentScreenText("");
            originsScope.setIncludeInTokenScope(false);
            originsScope.setProtocol("openid-connect");
            originsScope.addProtocolMapper(this.builtins.get(ALLOWED_WEB_ORIGINS));
            newRealm.addDefaultClientScope(originsScope, true);
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)WEB_ORIGINS_SCOPE, (Object)newRealm.getName());
        }
        return originsScope;
    }

    public ClientScopeModel addMicroprofileJWTClientScope(RealmModel newRealm) {
        ClientScopeModel microprofileScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)MICROPROFILE_JWT_SCOPE);
        if (microprofileScope == null) {
            microprofileScope = newRealm.addClientScope(MICROPROFILE_JWT_SCOPE);
            microprofileScope.setDescription("Microprofile - JWT built-in scope");
            microprofileScope.setDisplayOnConsentScreen(false);
            microprofileScope.setIncludeInTokenScope(true);
            microprofileScope.setProtocol("openid-connect");
            microprofileScope.addProtocolMapper(this.builtins.get(UPN));
            microprofileScope.addProtocolMapper(this.builtins.get(GROUPS));
            newRealm.addDefaultClientScope(microprofileScope, false);
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)MICROPROFILE_JWT_SCOPE, (Object)newRealm.getName());
        }
        return microprofileScope;
    }

    public ClientScopeModel addAcrClientScope(RealmModel newRealm) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.STEP_UP_AUTHENTICATION)) {
            ClientScopeModel acrScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)ACR_SCOPE);
            if (acrScope == null) {
                acrScope = newRealm.addClientScope(ACR_SCOPE);
                acrScope.setDescription("OpenID Connect scope for add acr (authentication context class reference) to the token");
                acrScope.setDisplayOnConsentScreen(false);
                acrScope.setIncludeInTokenScope(false);
                acrScope.setProtocol("openid-connect");
                acrScope.addProtocolMapper(this.builtins.get(ACR));
                newRealm.addDefaultClientScope(acrScope, true);
                logger.debugf("Client scope '%s' created in the realm '%s'.", (Object)ACR_SCOPE, (Object)newRealm.getName());
            } else {
                logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)ACR_SCOPE, (Object)newRealm.getName());
            }
            return acrScope;
        }
        logger.debugf("Skip creating client scope '%s' in the realm '%s' due the step-up authentication feature is disabled.", (Object)ACR_SCOPE, (Object)newRealm.getName());
        return null;
    }

    public ClientScopeModel addBasicClientScope(RealmModel newRealm) {
        ClientScopeModel basicScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)BASIC_SCOPE);
        if (basicScope == null) {
            basicScope = newRealm.addClientScope(BASIC_SCOPE);
            basicScope.setDescription("OpenID Connect scope for add all basic claims to the token");
            basicScope.setDisplayOnConsentScreen(false);
            basicScope.setIncludeInTokenScope(false);
            basicScope.setProtocol("openid-connect");
            basicScope.addProtocolMapper(this.builtins.get("auth_time"));
            basicScope.addProtocolMapper(this.builtins.get("sub"));
            newRealm.addDefaultClientScope(basicScope, true);
            logger.debugf("Client scope '%s' created in the realm '%s'.", (Object)BASIC_SCOPE, (Object)newRealm.getName());
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)BASIC_SCOPE, (Object)newRealm.getName());
        }
        return basicScope;
    }

    public ClientScopeModel addServiceAccountClientScope(RealmModel newRealm) {
        ClientScopeModel serviceAccountScope = KeycloakModelUtils.getClientScopeByName((RealmModel)newRealm, (String)"service_account");
        if (serviceAccountScope == null) {
            serviceAccountScope = newRealm.addClientScope("service_account");
            serviceAccountScope.setDescription("Specific scope for a client enabled for service accounts");
            serviceAccountScope.setDisplayOnConsentScreen(false);
            serviceAccountScope.setIncludeInTokenScope(false);
            serviceAccountScope.setProtocol(this.getId());
            serviceAccountScope.addProtocolMapper(UserSessionNoteMapper.createClaimMapper("Client ID", "client_id", "client_id", "String", true, true, true));
            serviceAccountScope.addProtocolMapper(UserSessionNoteMapper.createClaimMapper("Client Host", "clientHost", "clientHost", "String", true, true, true));
            serviceAccountScope.addProtocolMapper(UserSessionNoteMapper.createClaimMapper("Client IP Address", "clientAddress", "clientAddress", "String", true, true, true));
            logger.debugf("Client scope '%s' created in the realm '%s'.", (Object)"service_account", (Object)newRealm.getName());
        } else {
            logger.debugf("Client scope '%s' already exists in realm '%s'. Skip creating it.", (Object)"service_account", (Object)newRealm.getName());
        }
        return serviceAccountScope;
    }

    protected void addDefaults(ClientModel client) {
    }

    public Object createProtocolEndpoint(KeycloakSession session, EventBuilder event) {
        return new OIDCLoginProtocolService(session, event);
    }

    public String getId() {
        return "openid-connect";
    }

    public void setupClientDefaults(ClientRepresentation rep, ClientModel newClient) {
        if (rep.getRootUrl() != null && (rep.getRedirectUris() == null || rep.getRedirectUris().isEmpty())) {
            Object root = rep.getRootUrl();
            root = ((String)root).endsWith("/") ? (String)root + "*" : (String)root + "/*";
            newClient.addRedirectUri((String)root);
            HashSet<String> origins = new HashSet<String>();
            String origin = UriUtils.getOrigin((String)root);
            logger.debugv("adding default client origin: {0}", (Object)origin);
            origins.add(origin);
            newClient.setWebOrigins(origins);
        }
        if (rep.isBearerOnly() == null && rep.isPublicClient() == null) {
            newClient.setPublicClient(true);
            newClient.setSecret(null);
        } else if (!Boolean.TRUE.equals(rep.isBearerOnly()) && !Boolean.TRUE.equals(rep.isPublicClient()) && newClient.getSecret() == null) {
            KeycloakModelUtils.generateSecret((ClientModel)newClient);
        }
        if (rep.isBearerOnly() == null) {
            newClient.setBearerOnly(false);
        }
        if (rep.getAdminUrl() == null && rep.getRootUrl() != null) {
            newClient.setManagementUrl(rep.getRootUrl());
        }
        if (rep.isDirectGrantsOnly() != null) {
            ServicesLogger.LOGGER.usingDeprecatedDirectGrantsOnly();
            newClient.setStandardFlowEnabled(rep.isDirectGrantsOnly() == false);
            newClient.setDirectAccessGrantsEnabled(rep.isDirectGrantsOnly().booleanValue());
        } else {
            if (rep.isStandardFlowEnabled() == null) {
                newClient.setStandardFlowEnabled(true);
            }
            if (rep.isDirectAccessGrantsEnabled() == null) {
                newClient.setDirectAccessGrantsEnabled(true);
            }
        }
        if (rep.isImplicitFlowEnabled() == null) {
            newClient.setImplicitFlowEnabled(false);
        }
        if (rep.isPublicClient() == null) {
            newClient.setPublicClient(true);
        }
        if (rep.isFrontchannelLogout() == null) {
            newClient.setFrontchannelLogout(false);
        }
        if (OIDCAdvancedConfigWrapper.fromClientRepresentation(rep).getBackchannelLogoutUrl() == null) {
            OIDCAdvancedConfigWrapper oidcAdvancedConfigWrapper = OIDCAdvancedConfigWrapper.fromClientModel(newClient);
            oidcAdvancedConfigWrapper.setBackchannelLogoutSessionRequired(true);
            oidcAdvancedConfigWrapper.setBackchannelLogoutRevokeOfflineTokens(false);
        }
    }
}

