/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.Map;
import org.keycloak.broker.provider.mappersync.ConfigSynchronizer;
import org.keycloak.models.ClientModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleConfigPropertyByClientIdSynchronizer
implements ConfigSynchronizer<ClientModel.ClientIdChangeEvent> {
    public static final RoleConfigPropertyByClientIdSynchronizer INSTANCE = new RoleConfigPropertyByClientIdSynchronizer();

    private RoleConfigPropertyByClientIdSynchronizer() {
    }

    @Override
    public Class<ClientModel.ClientIdChangeEvent> getEventClass() {
        return ClientModel.ClientIdChangeEvent.class;
    }

    @Override
    public void handleEvent(ClientModel.ClientIdChangeEvent event) {
        event.getKeycloakSession().identityProviders().getMappersStream(Map.of("role", event.getPreviousClientId() + ".*"), null, null).forEach(idpMapper -> {
            String currentRoleValue = (String)idpMapper.getConfig().get("role");
            String configuredRoleName = KeycloakModelUtils.parseRole(currentRoleValue)[1];
            String newRoleValue = KeycloakModelUtils.buildRoleQualifier(event.getNewClientId(), configuredRoleName);
            idpMapper.getConfig().put("role", newRoleValue);
            this.logEventProcessed("role", currentRoleValue, newRoleValue, event.getUpdatedClient().getRealm().getName(), idpMapper.getName(), idpMapper.getIdentityProviderAlias());
            event.getKeycloakSession().identityProviders().updateMapper(idpMapper);
        });
    }
}

