/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.webauthn4j.data.extension.HMACGetSecretOutput;
import com.webauthn4j.data.extension.SingleValueExtensionOutputBase;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HMACSecretAuthenticationExtensionClientOutput
extends SingleValueExtensionOutputBase<HMACGetSecretOutput>
implements AuthenticationExtensionClientOutput {
    public static final String ID = "hmac-secret";
    public static final String KEY_HMAC_GET_SECRET = "hmacGetSecret";

    public HMACSecretAuthenticationExtensionClientOutput(@NonNull HMACGetSecretOutput value) {
        super(value);
    }

    @Override
    public @NonNull String getIdentifier() {
        return ID;
    }

    @Override
    public @NonNull HMACGetSecretOutput getValue(@NonNull String key) {
        if (!key.equals(KEY_HMAC_GET_SECRET)) {
            throw new IllegalArgumentException(String.format("%s is the only valid key.", KEY_HMAC_GET_SECRET));
        }
        return (HMACGetSecretOutput)this.getValue();
    }

    @Override
    public void validate() {
        if (this.getValue() == null) {
            throw new ConstraintViolationException("value must not be null");
        }
        if (((HMACGetSecretOutput)this.getValue()).getOutput1() == null) {
            throw new ConstraintViolationException("output1 must not be null");
        }
        if (((HMACGetSecretOutput)this.getValue()).getOutput1().length != 32) {
            throw new ConstraintViolationException("output1 must be 32 bytes length");
        }
        if (((HMACGetSecretOutput)this.getValue()).getOutput2() != null && ((HMACGetSecretOutput)this.getValue()).getOutput2().length != 32) {
            throw new ConstraintViolationException("output2 must be 32 bytes length");
        }
    }
}

