/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.metamodel.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.Version;
import org.hibernate.bytecode.enhance.VersionMismatchException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImplConstants;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ModelTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.PersistentAttributeTransformer;
import org.hibernate.bytecode.enhance.internal.tracker.CompositeOwnerTracker;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.enhance.spi.UnsupportedEnhancementStrategy;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.ManagedMappedSuperclass;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class EnhancerImpl
implements Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final ByteBuddyEnhancementContext enhancementContext;
    private final ByteBuddyState byteBuddyState;
    private final EnhancerClassLocator typePool;
    private final EnhancerImplConstants constants;
    private static final Set<String> IGNORED_PERSISTENCE_ANNOTATIONS = Set.of("jakarta.persistence.PostLoad", "jakarta.persistence.PostPersist", "jakarta.persistence.PostRemove", "jakarta.persistence.PostUpdate", "jakarta.persistence.PrePersist", "jakarta.persistence.PreRemove", "jakarta.persistence.PreUpdate");

    public EnhancerImpl(EnhancementContext enhancementContext, ByteBuddyState byteBuddyState) {
        this(enhancementContext, byteBuddyState, ModelTypePool.buildModelTypePool(enhancementContext.getLoadingClassLoader()));
    }

    public EnhancerImpl(EnhancementContext enhancementContext, ByteBuddyState byteBuddyState, EnhancerClassLocator classLocator) {
        this.enhancementContext = new ByteBuddyEnhancementContext(enhancementContext);
        this.byteBuddyState = Objects.requireNonNull(byteBuddyState);
        this.typePool = Objects.requireNonNull(classLocator);
        this.constants = byteBuddyState.getEnhancerConstants();
    }

    @Override
    public byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        String safeClassName = className.replace('/', '.');
        this.typePool.registerClassNameAndBytes(safeClassName, originalBytes);
        try {
            TypeDescription typeDescription = this.typePool.describe(safeClassName).resolve();
            byte[] byArray = this.byteBuddyState.rewrite(this.typePool, safeClassName, byteBuddy -> this.doEnhance(() -> byteBuddy.ignore((ElementMatcher)ElementMatchers.isDefaultFinalizer()).redefine(typeDescription, this.typePool.asClassFileLocator()).annotateType(this.constants.HIBERNATE_VERSION_ANNOTATION), typeDescription));
            return byArray;
        }
        catch (EnhancementException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new EnhancementException("Failed to enhance class " + className, e);
        }
        finally {
            this.typePool.deregisterClassNameAndBytes(safeClassName);
        }
    }

    @Override
    public void discoverTypes(String className, byte[] originalBytes) {
        if (originalBytes != null) {
            this.typePool.registerClassNameAndBytes(className, originalBytes);
        }
        try {
            TypeDescription typeDescription = this.typePool.describe(className).resolve();
            this.enhancementContext.registerDiscoveredType(typeDescription, Type.PersistenceType.ENTITY);
            this.enhancementContext.discoverCompositeTypes(typeDescription, this.typePool);
        }
        catch (RuntimeException e) {
            throw new EnhancementException("Failed to discover types for class " + className, e);
        }
        finally {
            this.typePool.deregisterClassNameAndBytes(className);
        }
    }

    private DynamicType.Builder<?> doEnhance(Supplier<DynamicType.Builder<?>> builderSupplier, TypeDescription managedCtClass) {
        if (managedCtClass.getDeclaredAnnotations().isAnnotationPresent(EnhancementInfo.class)) {
            EnhancerImpl.verifyVersions(managedCtClass, this.enhancementContext);
            log.debugf("Skipping enhancement of [%s]: it's already annotated with @EnhancementInfo", managedCtClass.getName());
            return null;
        }
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface", managedCtClass.getName());
            return null;
        }
        if (managedCtClass.isRecord()) {
            log.debugf("Skipping enhancement of [%s]: it's a record", managedCtClass.getName());
            return null;
        }
        if (this.alreadyEnhanced(managedCtClass)) {
            EnhancerImpl.verifyVersions(managedCtClass, this.enhancementContext);
            log.debugf("Skipping enhancement of [%s]: it's already implementing 'Managed'", managedCtClass.getName());
            return null;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            if (EnhancerImpl.checkUnsupportedAttributeNaming(managedCtClass, this.enhancementContext)) {
                return null;
            }
            log.debugf("Enhancing [%s] as Entity", managedCtClass.getName());
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedEntity.class}).defineMethod("$$_hibernate_getEntityInstance", this.constants.TypeObject, this.constants.methodModifierPUBLIC).intercept((Implementation)FixedValue.self());
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeEntityEntry, "$$_hibernate_entityEntryHolder", "$$_hibernate_getEntityEntry", "$$_hibernate_setEntityEntry");
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeManagedEntity, "$$_hibernate_previousManagedEntity", "$$_hibernate_getPreviousManagedEntity", "$$_hibernate_setPreviousManagedEntity");
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeManagedEntity, "$$_hibernate_nextManagedEntity", "$$_hibernate_getNextManagedEntity", "$$_hibernate_setNextManagedEntity");
            builder = this.addFieldWithGetterAndSetter((DynamicType.Builder<?>)builder, this.constants.TypeBooleanPrimitive, "$$_hibernate_useTracker", "$$_hibernate_useTracker", "$$_hibernate_setUseTracker");
            builder = this.addInterceptorHandling((DynamicType.Builder<?>)builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                List<AnnotatedFieldDescription> collectionFields = this.collectCollectionFields(managedCtClass);
                if (collectionFields.isEmpty()) {
                    builder = builder.implement(new Type[]{SelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", DirtyTracker.class, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_trackChange", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationTrackChange).defineMethod("$$_hibernate_getDirtyAttributes", this.constants.Type_Array_String, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetDirtyAttributesWithoutCollections).defineMethod("$$_hibernate_hasDirtyAttributes", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationAreFieldsDirtyWithoutCollections).defineMethod("$$_hibernate_clearDirtyAttributes", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationClearDirtyAttributesWithoutCollections).defineMethod("$$_hibernate_suspendDirtyTracking", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new TypeDefinition[]{this.constants.TypeBooleanPrimitive}).intercept(this.constants.implementationSuspendDirtyTracking).defineMethod("$$_hibernate_getCollectionTracker", this.constants.TypeCollectionTracker, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetCollectionTrackerWithoutCollections);
                } else {
                    builder = builder.implement(new Type[]{ExtendedSelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", DirtyTracker.class, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineField("$$_hibernate_collectionTracker", this.constants.TypeCollectionTracker, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_trackChange", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationTrackChange).defineMethod("$$_hibernate_getDirtyAttributes", this.constants.Type_Array_String, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationGetDirtyAttributes).defineMethod("$$_hibernate_hasDirtyAttributes", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationAreFieldsDirty).defineMethod("$$_hibernate_clearDirtyAttributes", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(this.constants.implementationClearDirtyAttributes).defineMethod("$$_hibernate_suspendDirtyTracking", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new TypeDefinition[]{this.constants.TypeBooleanPrimitive}).intercept(this.constants.implementationSuspendDirtyTracking).defineMethod("$$_hibernate_getCollectionTracker", this.constants.TypeCollectionTracker, this.constants.methodModifierPUBLIC).intercept((Implementation)FieldAccessor.ofField((String)"$$_hibernate_collectionTracker"));
                    StubMethod isDirty = StubMethod.INSTANCE;
                    StubMethod getDirtyNames = StubMethod.INSTANCE;
                    StubMethod clearDirtyNames = StubMethod.INSTANCE;
                    for (AnnotatedFieldDescription collectionField : collectionFields) {
                        Class adviceClearDirtyNames;
                        Class adviceGetDirtyNames;
                        Class adviceIsDirty;
                        String collectionFieldName = collectionField.getName();
                        if (collectionField.getType().asErasure().isAssignableTo(Map.class)) {
                            adviceIsDirty = CodeTemplates.MapAreCollectionFieldsDirty.class;
                            adviceGetDirtyNames = CodeTemplates.MapGetCollectionFieldDirtyNames.class;
                            adviceClearDirtyNames = CodeTemplates.MapGetCollectionClearDirtyNames.class;
                        } else {
                            adviceIsDirty = CodeTemplates.CollectionAreCollectionFieldsDirty.class;
                            adviceGetDirtyNames = CodeTemplates.CollectionGetCollectionFieldDirtyNames.class;
                            adviceClearDirtyNames = CodeTemplates.CollectionGetCollectionClearDirtyNames.class;
                        }
                        if (collectionField.isVisibleTo(managedCtClass)) {
                            FieldDescription fieldDescription = collectionField.getFieldDescription();
                            isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceIsDirty, this.constants.adviceLocator).wrap((Implementation)isDirty);
                            getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceGetDirtyNames, this.constants.adviceLocator).wrap((Implementation)getDirtyNames);
                            clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, fieldDescription).to(adviceClearDirtyNames, this.constants.adviceLocator).wrap((Implementation)clearDirtyNames);
                            continue;
                        }
                        CodeTemplates.GetterMapping getterMapping = new CodeTemplates.GetterMapping(collectionField.getFieldDescription());
                        isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, (Advice.OffsetMapping)getterMapping).to(adviceIsDirty, this.constants.adviceLocator).wrap((Implementation)isDirty);
                        getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, (Advice.OffsetMapping)getterMapping).to(adviceGetDirtyNames, this.constants.adviceLocator).wrap((Implementation)getDirtyNames);
                        clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Object)collectionFieldName).bind(CodeTemplates.FieldValue.class, (Advice.OffsetMapping)getterMapping).to(adviceClearDirtyNames, this.constants.adviceLocator).wrap((Implementation)clearDirtyNames);
                    }
                    if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
                        clearDirtyNames = this.constants.adviceInitializeLazyAttributeLoadingInterceptor.wrap((Implementation)clearDirtyNames);
                    }
                    builder = builder.defineMethod("$$_hibernate_areCollectionFieldsDirty", this.constants.TypeBooleanPrimitive, this.constants.methodModifierPUBLIC).intercept((Implementation)isDirty).defineMethod("$$_hibernate_getCollectionFieldDirtyNames", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{DirtyTracker.class}).intercept((Implementation)getDirtyNames).defineMethod("$$_hibernate_clearDirtyCollectionNames", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).intercept(Advice.withCustomMapping().to(CodeTemplates.ClearDirtyCollectionNames.class, this.constants.adviceLocator).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_removeDirtyFields", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{LazyAttributeLoadingInterceptor.class}).intercept((Implementation)clearDirtyNames);
                }
            }
            return this.createTransformer(managedCtClass).applyTo((DynamicType.Builder<?>)builder);
        }
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            if (EnhancerImpl.checkUnsupportedAttributeNaming(managedCtClass, this.enhancementContext)) {
                return null;
            }
            log.debugf("Enhancing [%s] as Composite", managedCtClass.getName());
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedComposite.class});
            builder = this.addInterceptorHandling((DynamicType.Builder<?>)builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                builder = builder.implement(new Type[]{CompositeTracker.class}).defineField("$$_hibernate_compositeOwners", CompositeOwnerTracker.class, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod("$$_hibernate_setOwner", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class, CompositeOwner.class}).intercept(this.constants.implementationSetOwner).defineMethod("$$_hibernate_clearOwner", this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new Type[]{String.class}).intercept(this.constants.implementationClearOwner);
            }
            return this.createTransformer(managedCtClass).applyTo((DynamicType.Builder<?>)builder);
        }
        if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            if (EnhancerImpl.checkUnsupportedAttributeNaming(managedCtClass, this.enhancementContext)) {
                return null;
            }
            log.debugf("Enhancing [%s] as MappedSuperclass", managedCtClass.getName());
            DynamicType.Builder.MethodDefinition.ImplementationDefinition.Optional builder = builderSupplier.get();
            builder = builder.implement(new Type[]{ManagedMappedSuperclass.class});
            return this.createTransformer(managedCtClass).applyTo((DynamicType.Builder<?>)builder);
        }
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            log.debugf("Extended enhancement of [%s]", managedCtClass.getName());
            return this.createTransformer(managedCtClass).applyExtended(builderSupplier.get());
        }
        log.debugf("Skipping enhancement of [%s]: not entity or composite", managedCtClass.getName());
        return null;
    }

    private static AccessType determineDefaultAccessType(TypeDefinition typeDefinition) {
        AnnotationList annotations;
        TypeDefinition candidate;
        for (candidate = typeDefinition; candidate != null && !candidate.represents(Object.class); candidate = candidate.getSuperClass()) {
            AnnotationDescription.Loadable access;
            annotations = candidate.asErasure().getDeclaredAnnotations();
            if (!EnhancerImpl.hasMappingAnnotation(annotations) || (access = annotations.ofType(Access.class)) == null) continue;
            return ((Access)access.load()).value();
        }
        for (candidate = typeDefinition; candidate != null && !candidate.represents(Object.class); candidate = candidate.getSuperClass()) {
            annotations = candidate.asErasure().getDeclaredAnnotations();
            if (!EnhancerImpl.hasMappingAnnotation(annotations)) continue;
            for (FieldDescription ctField : candidate.getDeclaredFields()) {
                AnnotationList annotationList;
                if (Modifier.isStatic(ctField.getModifiers()) || !(annotationList = ctField.getDeclaredAnnotations()).isAnnotationPresent(Id.class) && !annotationList.isAnnotationPresent(EmbeddedId.class)) continue;
                return AccessType.FIELD;
            }
        }
        return AccessType.PROPERTY;
    }

    private static AccessType determineAccessType(AnnotationSource annotationSource, AccessType defaultAccessType) {
        AnnotationDescription.Loadable access = annotationSource.getDeclaredAnnotations().ofType(Access.class);
        return access != null ? ((Access)access.load()).value() : defaultAccessType;
    }

    private static boolean hasMappingAnnotation(AnnotationList annotations) {
        return annotations.isAnnotationPresent(Entity.class) || annotations.isAnnotationPresent(MappedSuperclass.class) || annotations.isAnnotationPresent(Embeddable.class);
    }

    private static boolean hasPersistenceAnnotation(AnnotationList annotations) {
        boolean found = false;
        for (AnnotationDescription annotation : annotations) {
            String annotationName = annotation.getAnnotationType().getName();
            if (!annotationName.startsWith("jakarta.persistence")) continue;
            if (annotationName.equals("jakarta.persistence.Transient")) {
                return false;
            }
            if (found || IGNORED_PERSISTENCE_ANNOTATIONS.contains(annotationName)) continue;
            found = true;
        }
        return found;
    }

    private static boolean checkUnsupportedAttributeNaming(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext) {
        UnsupportedEnhancementStrategy strategy = enhancementContext.getUnsupportedEnhancementStrategy();
        if (UnsupportedEnhancementStrategy.LEGACY.equals((Object)strategy)) {
            return false;
        }
        AccessType defaultAccessType = EnhancerImpl.determineDefaultAccessType((TypeDefinition)managedCtClass);
        MethodList methods = (MethodList)MethodGraph.Compiler.DEFAULT.compile((TypeDefinition)managedCtClass).listNodes().asMethodList().filter((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isSetter()));
        for (MethodDescription methodDescription : methods) {
            String methodFieldName;
            if (EnhancerImpl.determineAccessType((AnnotationSource)methodDescription, defaultAccessType) != AccessType.PROPERTY) continue;
            String methodName = methodDescription.getActualName();
            if (methodName.startsWith("get") || methodName.startsWith("set")) {
                methodFieldName = methodName.substring(3);
            } else {
                assert (methodName.startsWith("is"));
                methodFieldName = methodName.substring(2);
            }
            if ((methodFieldName = EnhancerImpl.getJavaBeansFieldName(methodFieldName)) == null || !EnhancerImpl.hasPersistenceAnnotation(methodDescription.getDeclaredAnnotations())) continue;
            boolean propertyNameMatchesFieldName = false;
            for (FieldDescription field : methodDescription.getDeclaringType().getDeclaredFields()) {
                AnnotatedFieldDescription annotatedField;
                if (Modifier.isStatic(field.getModifiers()) || !enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(enhancementContext, field)) || !methodFieldName.equals(field.getActualName())) continue;
                propertyNameMatchesFieldName = true;
                break;
            }
            if (propertyNameMatchesFieldName) continue;
            switch (strategy) {
                case SKIP: {
                    log.debugf("Skipping enhancement of [%s] because no field named [%s] could be found for property accessor method [%s]. To fix this, make sure all property accessor methods have a matching field.", managedCtClass.getName(), methodFieldName, methodDescription.getName());
                    return true;
                }
                case FAIL: {
                    throw new EnhancementException(String.format("Enhancement of [%s] failed because no field named [%s] could be found for property accessor method [%s]. To fix this, make sure all property accessor methods have a matching field.", managedCtClass.getName(), methodFieldName, methodDescription.getName()));
                }
            }
            throw new AssertionFailure("Unexpected strategy at this point: " + strategy);
        }
        return false;
    }

    private static @Nullable String getJavaBeansFieldName(String name) {
        if (name.isEmpty()) {
            return null;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static void verifyVersions(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext) {
        AnnotationDescription.Loadable existingInfo = managedCtClass.getDeclaredAnnotations().ofType(EnhancementInfo.class);
        if (existingInfo == null) {
            return;
        }
        String enhancementVersion = EnhancerImpl.extractVersion((AnnotationDescription.Loadable<EnhancementInfo>)existingInfo);
        if (!Version.getVersionString().equals(enhancementVersion)) {
            throw new VersionMismatchException(managedCtClass, enhancementVersion, Version.getVersionString());
        }
    }

    private static String extractVersion(AnnotationDescription.Loadable<EnhancementInfo> annotation) {
        return ((EnhancementInfo)annotation.load()).version();
    }

    private PersistentAttributeTransformer createTransformer(TypeDescription typeDescription) {
        return PersistentAttributeTransformer.collectPersistentFields(typeDescription, this.enhancementContext, this.typePool);
    }

    private boolean alreadyEnhanced(TypeDescription managedCtClass) {
        for (TypeDescription.Generic declaredInterface : managedCtClass.getInterfaces()) {
            if (!declaredInterface.asErasure().isAssignableTo(Managed.class)) continue;
            return true;
        }
        return false;
    }

    private DynamicType.Builder<?> addInterceptorHandling(DynamicType.Builder<?> builder, TypeDescription managedCtClass) {
        if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", managedCtClass.getName());
            builder = builder.implement(new Type[]{PersistentAttributeInterceptable.class});
            builder = this.addFieldWithGetterAndSetter(builder, this.constants.TypePersistentAttributeInterceptor, "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
        }
        return builder;
    }

    private DynamicType.Builder<?> addFieldWithGetterAndSetter(DynamicType.Builder<?> builder, TypeDefinition type, String fieldName, String getterName, String setterName) {
        return builder.defineField(fieldName, type, this.constants.fieldModifierPRIVATE_TRANSIENT).annotateField(this.constants.TRANSIENT_ANNOTATION).defineMethod(getterName, type, this.constants.methodModifierPUBLIC).intercept((Implementation)FieldAccessor.ofField((String)fieldName)).defineMethod(setterName, this.constants.TypeVoid, this.constants.methodModifierPUBLIC).withParameters(new TypeDefinition[]{type}).intercept((Implementation)FieldAccessor.ofField((String)fieldName));
    }

    private List<AnnotatedFieldDescription> collectCollectionFields(TypeDescription managedCtClass) {
        ArrayList<AnnotatedFieldDescription> collectionList = new ArrayList<AnnotatedFieldDescription>();
        for (FieldDescription ctField : managedCtClass.getDeclaredFields()) {
            AnnotatedFieldDescription annotatedField;
            if (Modifier.isStatic(ctField.getModifiers()) || ctField.getName().startsWith("$$_hibernate_") || !this.enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(this.enhancementContext, ctField)) || !this.enhancementContext.isMappedCollection(annotatedField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(annotatedField);
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            collectionList.addAll(this.collectInheritCollectionFields((TypeDefinition)managedCtClass));
        }
        return collectionList;
    }

    private Collection<AnnotatedFieldDescription> collectInheritCollectionFields(TypeDefinition managedCtClass) {
        TypeDescription.Generic managedCtSuperclass = managedCtClass.getSuperClass();
        if (managedCtSuperclass == null || managedCtSuperclass.represents(Object.class)) {
            return Collections.emptyList();
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtSuperclass.asErasure())) {
            return this.collectInheritCollectionFields((TypeDefinition)managedCtSuperclass.asErasure());
        }
        ArrayList<AnnotatedFieldDescription> collectionList = new ArrayList<AnnotatedFieldDescription>();
        for (FieldDescription ctField : managedCtSuperclass.getDeclaredFields()) {
            AnnotatedFieldDescription annotatedField;
            if (Modifier.isStatic(ctField.getModifiers()) || !this.enhancementContext.isPersistentField(annotatedField = new AnnotatedFieldDescription(this.enhancementContext, ctField)) || !this.enhancementContext.isMappedCollection(annotatedField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(annotatedField);
        }
        collectionList.addAll(this.collectInheritCollectionFields((TypeDefinition)managedCtSuperclass));
        return collectionList;
    }

    static String capitalize(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    static class AnnotatedFieldDescription
    implements UnloadedField {
        private final ByteBuddyEnhancementContext context;
        private final FieldDescription fieldDescription;
        private AnnotationList annotations;
        private Optional<MethodDescription> getter;

        AnnotatedFieldDescription(ByteBuddyEnhancementContext context, FieldDescription fieldDescription) {
            this.context = context;
            this.fieldDescription = fieldDescription;
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.getAnnotations().isAnnotationPresent(annotationType);
        }

        public String toString() {
            return this.fieldDescription.toString();
        }

        <T extends Annotation> AnnotationDescription.Loadable<T> getAnnotation(Class<T> annotationType) {
            return this.getAnnotations().ofType(annotationType);
        }

        String getName() {
            return this.fieldDescription.getName();
        }

        TypeDefinition getDeclaringType() {
            return this.fieldDescription.getDeclaringType();
        }

        TypeDescription.Generic getType() {
            return this.fieldDescription.getType();
        }

        FieldDescription.InDefinedShape asDefined() {
            return (FieldDescription.InDefinedShape)this.fieldDescription.asDefined();
        }

        String getDescriptor() {
            return this.fieldDescription.getDescriptor();
        }

        boolean isVisibleTo(TypeDescription typeDescription) {
            return this.fieldDescription.isVisibleTo(typeDescription);
        }

        FieldDescription getFieldDescription() {
            return this.fieldDescription;
        }

        Optional<MethodDescription> getGetter() {
            if (this.getter == null) {
                this.getter = this.context.resolveGetter(this.fieldDescription);
            }
            return this.getter;
        }

        private AnnotationList getAnnotations() {
            if (this.annotations == null) {
                this.annotations = this.doGetAnnotations();
            }
            return this.annotations;
        }

        private AnnotationList doGetAnnotations() {
            AnnotationDescription.Loadable access = this.fieldDescription.getDeclaringType().asErasure().getDeclaredAnnotations().ofType(Access.class);
            if (access != null && ((Access)access.load()).value() == AccessType.PROPERTY) {
                Optional<MethodDescription> getter = this.getGetter();
                if (getter.isPresent()) {
                    return getter.get().getDeclaredAnnotations();
                }
                return this.fieldDescription.getDeclaredAnnotations();
            }
            if (access != null && ((Access)access.load()).value() == AccessType.FIELD) {
                return this.fieldDescription.getDeclaredAnnotations();
            }
            Optional<MethodDescription> getter = this.getGetter();
            ArrayList annotationDescriptions = new ArrayList();
            if (getter.isPresent()) {
                annotationDescriptions.addAll(getter.get().getDeclaredAnnotations());
            }
            annotationDescriptions.addAll(this.fieldDescription.getDeclaredAnnotations());
            return new AnnotationList.Explicit(annotationDescriptions);
        }
    }
}

