/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.node.ConfigurationImageNode;
import org.apache.kafka.image.node.MetadataNode;

public class ConfigurationsImageNode
implements MetadataNode {
    public static final String NAME = "configs";
    private final ConfigurationsImage image;

    public ConfigurationsImageNode(ConfigurationsImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (ConfigResource configResource : this.image.resourceData().keySet()) {
            if (configResource.isDefault()) {
                childNames.add(configResource.type().name());
                continue;
            }
            childNames.add(configResource.type().name() + ":" + configResource.name());
        }
        return childNames;
    }

    static ConfigResource resourceFromName(String name) {
        for (ConfigResource.Type type : ConfigResource.Type.values()) {
            if (!name.startsWith(type.name())) continue;
            String key = name.substring(type.name().length());
            if (key.isEmpty()) {
                return new ConfigResource(type, "");
            }
            if (key.startsWith(":")) {
                return new ConfigResource(type, key.substring(1));
            }
            return null;
        }
        return null;
    }

    @Override
    public MetadataNode child(String name) {
        ConfigResource resource = ConfigurationsImageNode.resourceFromName(name);
        if (resource == null) {
            return null;
        }
        ConfigurationImage configurationImage = this.image.resourceData().get(resource);
        if (configurationImage == null) {
            return null;
        }
        return new ConfigurationImageNode(configurationImage);
    }
}

