/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Sensor;

public class MetricConfigs {
    public static final String METRIC_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final int METRIC_SAMPLE_WINDOW_MS_DEFAULT = 30000;
    public static final String METRIC_SAMPLE_WINDOW_MS_DOC = "The window of time a metrics sample is computed over.";
    public static final String METRIC_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final int METRIC_NUM_SAMPLES_DEFAULT = 2;
    public static final String METRIC_NUM_SAMPLES_DOC = "The number of samples maintained to compute metrics.";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String METRIC_REPORTER_CLASSES_DEFAULT = JmxReporter.class.getName();
    public static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. When custom reporters are set and <code>org.apache.kafka.common.metrics.JmxReporter</code> is needed, it has to be explicitly added to the list.";
    public static final String METRIC_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String METRIC_RECORDING_LEVEL_DEFAULT = Sensor.RecordingLevel.INFO.toString();
    public static final String METRIC_RECORDING_LEVEL_DOC = "The highest recording level for metrics. It has three levels for recording metrics - info, debug, and trace.\n \nINFO level records only essential metrics necessary for monitoring system performance and health. It collects vital data without gathering too much detail, making it suitable for production environments where minimal overhead is desired.\n\nDEBUG level records most metrics, providing more detailed information about the system's operation. It's useful for development and testing environments where you need deeper insights to debug and fine-tune the application.\n\nTRACE level records all possible metrics, capturing every detail about the system's performance and operation. It's best for controlled environments where in-depth analysis is required, though it can introduce significant overhead.";
    public static final String KAFKA_METRICS_REPORTER_CLASSES_CONFIG = "kafka.metrics.reporters";
    public static final String KAFKA_METRIC_REPORTER_CLASSES_DEFAULT = "";
    public static final String KAFKA_METRICS_REPORTER_CLASSES_DOC = "A list of classes to use as Yammer metrics custom reporters. The reporters should implement <code>kafka.metrics.KafkaMetricsReporter</code> trait. If a client wants to expose JMX operations on a custom reporter, the custom reporter needs to additionally implement an MBean trait that extends <code>kafka.metrics.KafkaMetricsReporterMBean</code> trait so that the registered MBean is compliant with the standard MBean convention.";
    public static final String KAFKA_METRICS_POLLING_INTERVAL_SECONDS_CONFIG = "kafka.metrics.polling.interval.secs";
    public static final int KAFKA_METRICS_POLLING_INTERVAL_SECONDS_DEFAULT = 10;
    public static final String KAFKA_METRICS_POLLING_INTERVAL_SECONDS_DOC = "The metrics polling interval (in seconds) which can be used in kafka.metrics.reporters implementations.";
    public static final String CLIENT_TELEMETRY_MAX_BYTES_CONFIG = "telemetry.max.bytes";
    public static final int CLIENT_TELEMETRY_MAX_BYTES_DEFAULT = 0x100000;
    public static final String CLIENT_TELEMETRY_MAX_BYTES_DOC = "The maximum size (after compression if compression is used) of telemetry metrics pushed from a client to the broker. The default value is 1048576 (1 MB).";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("metrics.num.samples", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define("metrics.sample.window.ms", ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define("metric.reporters", ConfigDef.Type.LIST, (Object)METRIC_REPORTER_CLASSES_DEFAULT, ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. When custom reporters are set and <code>org.apache.kafka.common.metrics.JmxReporter</code> is needed, it has to be explicitly added to the list.").define("metrics.recording.level", ConfigDef.Type.STRING, (Object)METRIC_RECORDING_LEVEL_DEFAULT, ConfigDef.Importance.LOW, "The highest recording level for metrics. It has three levels for recording metrics - info, debug, and trace.\n \nINFO level records only essential metrics necessary for monitoring system performance and health. It collects vital data without gathering too much detail, making it suitable for production environments where minimal overhead is desired.\n\nDEBUG level records most metrics, providing more detailed information about the system's operation. It's useful for development and testing environments where you need deeper insights to debug and fine-tune the application.\n\nTRACE level records all possible metrics, capturing every detail about the system's performance and operation. It's best for controlled environments where in-depth analysis is required, though it can introduce significant overhead.").define("kafka.metrics.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as Yammer metrics custom reporters. The reporters should implement <code>kafka.metrics.KafkaMetricsReporter</code> trait. If a client wants to expose JMX operations on a custom reporter, the custom reporter needs to additionally implement an MBean trait that extends <code>kafka.metrics.KafkaMetricsReporterMBean</code> trait so that the registered MBean is compliant with the standard MBean convention.").define("kafka.metrics.polling.interval.secs", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The metrics polling interval (in seconds) which can be used in kafka.metrics.reporters implementations.").define("telemetry.max.bytes", ConfigDef.Type.INT, (Object)0x100000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The maximum size (after compression if compression is used) of telemetry metrics pushed from a client to the broker. The default value is 1048576 (1 MB).");
}

