/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftResponse;

public abstract class RaftRequest
implements RaftMessage {
    private final int correlationId;
    private final ApiMessage data;
    private final long createdTimeMs;

    public RaftRequest(int correlationId, ApiMessage data, long createdTimeMs) {
        this.correlationId = correlationId;
        this.data = data;
        this.createdTimeMs = createdTimeMs;
    }

    @Override
    public int correlationId() {
        return this.correlationId;
    }

    @Override
    public ApiMessage data() {
        return this.data;
    }

    public long createdTimeMs() {
        return this.createdTimeMs;
    }

    public static final class Outbound
    extends RaftRequest {
        private final Node destination;
        public final CompletableFuture<RaftResponse.Inbound> completion = new CompletableFuture();

        public Outbound(int correlationId, ApiMessage data, Node destination, long createdTimeMs) {
            super(correlationId, data, createdTimeMs);
            this.destination = destination;
        }

        public Node destination() {
            return this.destination;
        }

        public String toString() {
            return String.format("OutboundRequest(correlationId=%d, data=%s, createdTimeMs=%d, destination=%s)", this.correlationId(), this.data(), this.createdTimeMs(), this.destination);
        }
    }

    public static final class Inbound
    extends RaftRequest {
        private final short apiVersion;
        private final ListenerName listenerName;
        public final CompletableFuture<RaftResponse.Outbound> completion = new CompletableFuture();

        public Inbound(ListenerName listenerName, int correlationId, short apiVersion, ApiMessage data, long createdTimeMs) {
            super(correlationId, data, createdTimeMs);
            this.listenerName = listenerName;
            this.apiVersion = apiVersion;
        }

        public short apiVersion() {
            return this.apiVersion;
        }

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public String toString() {
            return String.format("InboundRequest(listenerName=%s, correlationId=%d, apiVersion=%d, data=%s, createdTimeMs=%d)", this.listenerName, this.correlationId(), this.apiVersion, this.data(), this.createdTimeMs());
        }
    }
}

