/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rMh\u0001B7o\u0001MD\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\r\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0011Q\u0003\u0005\u000b\u0003/\u0001!\u0011!Q\u0001\n\u0005e\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0019\u0005=\u0002A!A!\u0002\u0013\t\t$a\u0014\t\u0015\u0005E\u0003A!A!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002\\\u0001\u0011\t\u0011)A\u0005\u0003;Bq!a\u001b\u0001\t\u0003\ti\u0007\u0003\u0006\u0002\u0002\u0002\u0011\r\u0011\"\u0001o\u0003\u0007C\u0001ba\r\u0001A\u0003%\u0011Q\u0011\u0005\b\u0007k\u0001A\u0011KB\u001c\u0011\u001d\u0019y\u0004\u0001C)\u0007\u0003Bqaa\u0013\u0001\t#\u001ai\u0005C\u0004\u0004R\u0001!\tfa\u0015\t\u000f\r\r\u0004\u0001\"\u0011\u0004f!91\u0011\u0012\u0001\u0005B\r-\u0005bBAm\u0001\u0011%11\u0015\u0005\t\u0007S\u0003A\u0011\u00018\u0004,\"911\u0017\u0001\u0005\n\rU\u0006bBBe\u0001\u0011\u000531\u001a\u0005\b\u00073\u0004A\u0011IBn\u0011\u001d\u0019I\u000f\u0001C)\u0007W<q!a,o\u0011\u0003\t\tL\u0002\u0004n]\"\u0005\u00111\u0017\u0005\b\u0003WJB\u0011AA^\r\u0019\ti,\u0007!\u0002@\"Q\u0011\u0011\\\u000e\u0003\u0016\u0004%\t!a7\t\u0015\t-5D!E!\u0002\u0013\ti\u000e\u0003\u0006\u0003\u000en\u0011)\u001a!C\u0001\u0005\u001fC!B!(\u001c\u0005#\u0005\u000b\u0011\u0002BI\u0011)\u0011yj\u0007BK\u0002\u0013\u0005!q\u0012\u0005\u000b\u0005C[\"\u0011#Q\u0001\n\tE\u0005bBA67\u0011\u0005!1\u0015\u0005\b\u0005[[B\u0011\u0001BX\u0011%\u0011)lGA\u0001\n\u0003\u00119\fC\u0005\u0003@n\t\n\u0011\"\u0001\u0003B\"I!q[\u000e\u0012\u0002\u0013\u0005!\u0011\u001c\u0005\n\u0005;\\\u0012\u0013!C\u0001\u00053D\u0011Ba\u0004\u001c\u0003\u0003%\tE!\u0005\t\u0013\tu1$!A\u0005\u0002\t}\u0001\"\u0003B\u00117\u0005\u0005I\u0011\u0001Bp\u0011%\u0011ycGA\u0001\n\u0003\u0012\t\u0004C\u0005\u0003@m\t\t\u0011\"\u0001\u0003d\"I!q]\u000e\u0002\u0002\u0013\u0005#\u0011\u001e\u0005\n\u0005\u000bZ\u0012\u0011!C!\u0005\u000fB\u0011B!\u0013\u001c\u0003\u0003%\tEa\u0013\t\u0013\t58$!A\u0005B\t=x!\u0003Bz3\u0005\u0005\t\u0012\u0001B{\r%\ti,GA\u0001\u0012\u0003\u00119\u0010C\u0004\u0002lI\"\taa\u0004\t\u0013\t%#'!A\u0005F\t-\u0003\"CB\te\u0005\u0005I\u0011QB\n\u0011%\u0019YBMA\u0001\n\u0003\u001bi\u0002C\u0005\u0003NI\n\t\u0011\"\u0003\u0003P\u0019I\u0011\u0011]\r\u0011\u0002\u0007\u0005\u00121\u001d\u0005\b\u0003KDD\u0011AAt\u0011\u001d\ty\u000f\u000fC\u0001\u0003c<qaa\u000b\u001a\u0011\u0003\u0011\tAB\u0004\u0002bfA\t!!@\t\u000f\u0005-D\b\"\u0001\u0002\u0000\u001e9!1\u0001\u001f\t\u0002\n\u0015aa\u0002B\u0005y!\u0005%1\u0002\u0005\b\u0003WzD\u0011\u0001B\u0007\u0011%\u0011yaPA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\u001e}\n\t\u0011\"\u0001\u0003 !I!\u0011E \u0002\u0002\u0013\u0005!1\u0005\u0005\n\u0005_y\u0014\u0011!C!\u0005cA\u0011Ba\u0010@\u0003\u0003%\tA!\u0011\t\u0013\t\u0015s(!A\u0005B\t\u001d\u0003\"\u0003B%\u007f\u0005\u0005I\u0011\tB&\u0011%\u0011iePA\u0001\n\u0013\u0011yeB\u0004\u0003XqB\tI!\u0017\u0007\u000f\tmC\b#!\u0003^!9\u00111\u000e&\u0005\u0002\t}\u0003bBAx\u0015\u0012\u0005\u0013\u0011\u001f\u0005\n\u0005\u001fQ\u0015\u0011!C!\u0005#A\u0011B!\bK\u0003\u0003%\tAa\b\t\u0013\t\u0005\"*!A\u0005\u0002\t\u0005\u0004\"\u0003B\u0018\u0015\u0006\u0005I\u0011\tB\u0019\u0011%\u0011yDSA\u0001\n\u0003\u0011)\u0007C\u0005\u0003F)\u000b\t\u0011\"\u0011\u0003H!I!\u0011\n&\u0002\u0002\u0013\u0005#1\n\u0005\n\u0005\u001bR\u0015\u0011!C\u0005\u0005\u001f:qA!\u001b=\u0011\u0003\u0013YGB\u0004\u0002|rB\tIa \t\u000f\u0005-d\u000b\"\u0001\u0003\u0002\"9\u0011q\u001e,\u0005B\u0005E\b\"\u0003B\b-\u0006\u0005I\u0011\tB\t\u0011%\u0011iBVA\u0001\n\u0003\u0011y\u0002C\u0005\u0003\"Y\u000b\t\u0011\"\u0001\u0003\u0004\"I!q\u0006,\u0002\u0002\u0013\u0005#\u0011\u0007\u0005\n\u0005\u007f1\u0016\u0011!C\u0001\u0005\u000fC\u0011B!\u0012W\u0003\u0003%\tEa\u0012\t\u0013\t%c+!A\u0005B\t-\u0003\"\u0003B'-\u0006\u0005I\u0011\u0002B(\u000f\u001d\u0011i\u0007\u0010EA\u0005_2qA!\u001d=\u0011\u0003\u0013\u0019\bC\u0004\u0002l\t$\tA!\u001e\t\u0013\t=!-!A\u0005B\tE\u0001\"\u0003B\u000fE\u0006\u0005I\u0011\u0001B\u0010\u0011%\u0011\tCYA\u0001\n\u0003\u00119\bC\u0005\u00030\t\f\t\u0011\"\u0011\u00032!I!q\b2\u0002\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u000b\u0012\u0017\u0011!C!\u0005\u000fB\u0011B!\u0013c\u0003\u0003%\tEa\u0013\t\u0013\t5#-!A\u0005\n\t=\u0003\"CB\u00173E\u0005I\u0011AB\u0018\u0005e\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014X-\u00193\u000b\u0005=\u0004\u0018AB:feZ,'OC\u0001r\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001;\u0011\u0005U4X\"\u00018\n\u0005]t'!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\rE\u0002{\u0003\u000fq1a_A\u0002!\tax0D\u0001~\u0015\tq(/\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003\u0003\tQa]2bY\u0006L1!!\u0002\u0000\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA@\u0002\r1,\u0017\rZ3s!\r)\u0018\u0011C\u0005\u0004\u0003'q'A\u0004'fC\u0012,'/\u00128e!>Lg\u000e^\u0005\u0004\u0003\u001b1\u0018\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\r)\u00181D\u0005\u0004\u0003;q'\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0004k\u0006\r\u0012bAA\u0013]\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007cA;\u0002,%\u0019\u0011Q\u00068\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\u0011\t\u0019$a\u0013\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tq!\\3ue&\u001c7O\u0003\u0003\u0002<\u0005u\u0012a\u00017pO*!\u0011qHA!\u0003\u001d\u0019Ho\u001c:bO\u0016T1!]A\"\u0015\u0011\t)%a\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI%A\u0002pe\u001eLA!!\u0014\u00026\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0005\u0004\u0003_1\u0018A\u00044fi\u000eD')Y2l\u001f\u001a4Wj\u001d\t\u0005\u0003+\n9&D\u0001\u0000\u0013\r\tIf \u0002\u0004\u0013:$\u0018!\u00063je\u0016\u001cGo\u001c:z\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\t\u0005\u0003?\n9'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0019\u0019w.\\7p]*\u0019q.!\u0011\n\t\u0005%\u0014\u0011\r\u0002\u0016\t&\u0014Xm\u0019;pef,e/\u001a8u\u0011\u0006tG\r\\3s\u0003\u0019a\u0014N\\5u}Q\u0011\u0012qNA9\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@!\t)\b\u0001C\u0003y\u0013\u0001\u0007\u0011\u0010C\u0004\u0002\u000e%\u0001\r!a\u0004\t\u000f\u0005]\u0011\u00021\u0001\u0002\u001a!9\u0011qD\u0005A\u0002\u0005\u0005\u0002bBA\u0014\u0013\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003_I\u0001\u0019AA\u0019\u0011\u001d\t\t&\u0003a\u0001\u0003'B\u0011\"a\u0017\n!\u0003\u0005\r!!\u0018\u0002\u001fA\u0014x.\\8uS>t7\u000b^1uKN,\"!!\"\u0011\u0011\u0005\u001d\u0015QSAM\u0003Gk!!!#\u000b\t\u0005-\u0015QR\u0001\u000bG>t7-\u001e:sK:$(\u0002BAH\u0003#\u000bA!\u001e;jY*\u0011\u00111S\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u0006%%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u00111TAP\u001b\t\tiJ\u0003\u0003\u0002d\u0005\u0005\u0013\u0002BAQ\u0003;\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002\u0002&nq1!a*\u0019\u001d\u0011\tI+!,\u000f\u0007q\fY+C\u0001r\u0013\ty\u0007/A\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$\u0007CA;\u001a'\rI\u0012Q\u0017\t\u0005\u0003+\n9,C\u0002\u0002:~\u0014a!\u00118z%\u00164GCAAY\u00059\u0001&o\\7pi&|gn\u0015;bi\u0016\u001craGA[\u0003\u0003\f9\r\u0005\u0003\u0002V\u0005\r\u0017bAAc\u007f\n9\u0001K]8ek\u000e$\b\u0003BAe\u0003'tA!a3\u0002P:\u0019A0!4\n\u0005\u0005\u0005\u0011bAAi\u007f\u00069\u0001/Y2lC\u001e,\u0017\u0002BAk\u0003/\u0014AbU3sS\u0006d\u0017N_1cY\u0016T1!!5\u0000\u0003E\u0011X-Y:tS\u001etW.\u001a8u'R\fG/Z\u000b\u0003\u0003;\u00042!a89\u001b\u0005I\"!\u0005*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uKN\u0019\u0001(!.\u0002\r\u0011Jg.\u001b;%)\t\tI\u000f\u0005\u0003\u0002V\u0005-\u0018bAAw\u007f\n!QK\\5u\u0003ei\u0017-\u001f2f\u0013:\u001cwN\\:jgR,g\u000e^'fi\u0006$\u0017\r^1\u0016\u0005\u0005M\b\u0003BA+\u0003kL1!a>\u0000\u0005\u001d\u0011un\u001c7fC:LS\u0001\u000f,c\u007f)\u0013\u0001\"Q2dKB$X\rZ\n\u0004y\u0005UFC\u0001B\u0001!\r\ty\u000eP\u0001\u0005\u001d>tW\rE\u0002\u0003\b}j\u0011\u0001\u0010\u0002\u0005\u001d>tWmE\u0005@\u0003k\u000bi.!1\u0002HR\u0011!QA\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u00057i!Aa\u0006\u000b\t\te\u0011\u0011S\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\n\t]\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA*\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\n\u0003,A!\u0011Q\u000bB\u0014\u0013\r\u0011Ic \u0002\u0004\u0003:L\b\"\u0003B\u0017\u0007\u0006\u0005\t\u0019AA*\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0007\t\u0007\u0005k\u0011YD!\n\u000e\u0005\t]\"b\u0001B\u001d\u007f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tu\"q\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002t\n\r\u0003\"\u0003B\u0017\u000b\u0006\u0005\t\u0019\u0001B\u0013\u0003!A\u0017m\u001d5D_\u0012,GCAA*\u0003!!xn\u0015;sS:<GC\u0001B\n\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0006\u0005\u0003\u0003\u0016\tM\u0013\u0002\u0002B+\u0005/\u0011aa\u00142kK\u000e$\u0018AB)vKV,G\rE\u0002\u0003\b)\u0013a!U;fk\u0016$7#\u0003&\u00026\u0006u\u0017\u0011YAd)\t\u0011I\u0006\u0006\u0003\u0003&\t\r\u0004\"\u0003B\u0017\u001f\u0006\u0005\t\u0019AA*)\u0011\t\u0019Pa\u001a\t\u0013\t5\u0012+!AA\u0002\t\u0015\u0012\u0001C!dG\u0016\u0004H/\u001a3\u0011\u0007\t\u001da+A\u0005FM\u001a,7\r^5wKB\u0019!q\u00012\u0003\u0013\u00153g-Z2uSZ,7#\u00032\u00026\u0006u\u0017\u0011YAd)\t\u0011y\u0007\u0006\u0003\u0003&\te\u0004\"\u0003B\u0017M\u0006\u0005\t\u0019AA*)\u0011\t\u0019P! \t\u0013\t5\u0002.!AA\u0002\t\u00152#\u0003,\u00026\u0006u\u0017\u0011YAd)\t\u0011Y\u0007\u0006\u0003\u0003&\t\u0015\u0005\"\u0003B\u00177\u0006\u0005\t\u0019AA*)\u0011\t\u0019P!#\t\u0013\t5R,!AA\u0002\t\u0015\u0012A\u0005:fCN\u001c\u0018n\u001a8nK:$8\u000b^1uK\u0002\nq\u0001^8qS\u000eLE-\u0006\u0002\u0003\u0012B1\u0011Q\u000bBJ\u0005/K1A!&\u0000\u0005\u0019y\u0005\u000f^5p]B!\u00111\u0014BM\u0013\u0011\u0011Y*!(\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005Q1-\u001e:sK:$H)\u001b:\u0002\u0017\r,(O]3oi\u0012K'\u000f\t\u000b\t\u0005K\u00139K!+\u0003,B\u0019\u0011q\\\u000e\t\u000f\u0005e'\u00051\u0001\u0002^\"9!Q\u0012\u0012A\u0002\tE\u0005b\u0002BPE\u0001\u0007!\u0011S\u0001\u000fo&$\b.Q:tS\u001etW.\u001a8u)\u0011\u0011)K!-\t\u000f\tM6\u00051\u0001\u0002^\u00069b.Z<ESJ\u0014V-Y:tS\u001etW.\u001a8u'R\fG/Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0003&\ne&1\u0018B_\u0011%\tI\u000e\nI\u0001\u0002\u0004\ti\u000eC\u0005\u0003\u000e\u0012\u0002\n\u00111\u0001\u0003\u0012\"I!q\u0014\u0013\u0011\u0002\u0003\u0007!\u0011S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019M\u000b\u0003\u0002^\n\u00157F\u0001Bd!\u0011\u0011IMa5\u000e\u0005\t-'\u0002\u0002Bg\u0005\u001f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tEw0\u0001\u0006b]:|G/\u0019;j_:LAA!6\u0003L\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u001c\u0016\u0005\u0005#\u0013)-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0015\t\t\u0015\"\u0011\u001d\u0005\n\u0005[Q\u0013\u0011!a\u0001\u0003'\"B!a=\u0003f\"I!Q\u0006\u0017\u0002\u0002\u0003\u0007!QE\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0014\t-\b\"\u0003B\u0017[\u0005\u0005\t\u0019AA*\u0003\u0019)\u0017/^1mgR!\u00111\u001fBy\u0011%\u0011i\u0003MA\u0001\u0002\u0004\u0011)#\u0001\bQe>lw\u000e^5p]N#\u0018\r^3\u0011\u0007\u0005}'gE\u00033\u0005s\u001c)\u0001\u0005\u0007\u0003|\u000e\u0005\u0011Q\u001cBI\u0005#\u0013)+\u0004\u0002\u0003~*\u0019!q`@\u0002\u000fI,h\u000e^5nK&!11\u0001B\u007f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0007\u000f\u0019i!\u0004\u0002\u0004\n)!11BAI\u0003\tIw.\u0003\u0003\u0002V\u000e%AC\u0001B{\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011)k!\u0006\u0004\u0018\re\u0001bBAmk\u0001\u0007\u0011Q\u001c\u0005\b\u0005\u001b+\u0004\u0019\u0001BI\u0011\u001d\u0011y*\u000ea\u0001\u0005#\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004 \r\u001d\u0002CBA+\u0005'\u001b\t\u0003\u0005\u0006\u0002V\r\r\u0012Q\u001cBI\u0005#K1a!\n\u0000\u0005\u0019!V\u000f\u001d7fg!I1\u0011\u0006\u001c\u0002\u0002\u0003\u0007!QU\u0001\u0004q\u0012\u0002\u0014!\u0005*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"a!\r+\t\u0005u#QY\u0001\u0011aJ|Wn\u001c;j_:\u001cF/\u0019;fg\u0002\n1\u0002\\1uKN$X\t]8dQR!1\u0011HB\u001e!\u0019\t)Fa%\u0002T!91Q\b\u0007A\u0002\u0005e\u0015A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000fY><7\u000b^1si>3gm]3u)\u0011\u0019\u0019e!\u0013\u0011\t\u0005U3QI\u0005\u0004\u0007\u000fz(\u0001\u0002'p]\u001eDqa!\u0010\u000e\u0001\u0004\tI*\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0004D\r=\u0003bBB\u001f\u001d\u0001\u0007\u0011\u0011T\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBB+\u0007;\u001ay\u0006\u0005\u0004\u0002V\tM5q\u000b\t\u0005\u0003?\u001aI&\u0003\u0003\u0004\\\u0005\u0005$AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0007{y\u0001\u0019AAM\u0011\u001d\u0019\tg\u0004a\u0001\u0003'\nQ!\u001a9pG\"\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CB4\u0007o\u001aIh! \u0011\r\u0005U#1SB5!\u0011\u0019Yga\u001d\u000e\u0005\r5$\u0002BA\u001e\u0007_RAa!\u001d\u0002>\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0007k\u001aiGA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007{\u0001\u0002\u0019AAM\u0011\u001d\u0019Y\b\u0005a\u0001\u0007\u0007\n1BZ3uG\"|eMZ:fi\"91q\u0010\tA\u0002\r\u0005\u0015!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0004\u0004\u000e\u0015U\"\u0001\u0001\n\u0007\r\u001deOA\u0005GKR\u001c\u0007\u000eR1uC\u0006\u0001\"/Z7pm\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0007\u001b\u001bI\n\u0005\u0005\u00036\r=\u0015\u0011TBJ\u0013\u0011\u0019\tJa\u000e\u0003\u00075\u000b\u0007\u000fE\u0002v\u0007+K1aa&o\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0011\u001d\u0019Y*\u0005a\u0001\u0007;\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005k\u0019y*!'\n\t\r\u0005&q\u0007\u0002\u0004'\u0016$H\u0003BBS\u0007O\u00032!!*9\u0011\u001d\u0019iD\u0005a\u0001\u00033\u000bq#\u001e9eCR,'+Z1tg&<g.\\3oiN#\u0018\r^3\u0015\r\u0005%8QVBX\u0011\u001d\u0019id\u0005a\u0001\u00033Cqa!-\u0014\u0001\u0004\u0019)+A\u0003ti\u0006$X-A\rnCf\u0014W\r\u0015:p[>$XMR;ukJ,'+\u001a9mS\u000e\fGC\u0002B\u0013\u0007o\u001bI\fC\u0004\u0004>Q\u0001\r!!'\t\u000f\rmF\u00031\u0001\u0004>\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0007\u007f\u001b)-\u0004\u0002\u0004B*\u001911\u00199\u0002\u000f\rdWo\u001d;fe&!1qYBa\u0005%\u0001\u0016M\u001d;ji&|g.A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0007;\u001bi\rC\u0004\u0004PV\u0001\ra!5\u0002%%t\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$Xm\u001d\t\t\u0005k\u0019y)!'\u0004TB\u0019Qo!6\n\u0007\r]gNA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0007\u0003S\u001cina8\t\u000f\rub\u00031\u0001\u0002\u001a\"91\u0011\u001d\fA\u0002\r\r\u0018a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007U\u001c)/C\u0002\u0004h:\u0014Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR1\u0011\u0011^Bw\u0007_Dqa!\u0010\u0018\u0001\u0004\tI\nC\u0004\u0004r^\u0001\raa\u0011\u0002\r=4gm]3u\u0001")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;

    public static DirectoryEventHandler $lessinit$greater$default$8() {
        return DirectoryEventHandler.NOOP;
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler) : directoryEventHandler != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                void var3_3;
                void var4_4;
                void var5_5;
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(null);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                if (var5_5.isDefined() && var4_4.isDefined() && var3_3.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition((Uuid)var4_4.get(), topicPartition.partition()), (Uuid)var5_5.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.log.debug("Updating future replica " + topicPartition + " reassignment state to " + state);
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException("Topic " + topicPartition.topic() + " does not have an ID.");
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1<UnifiedLog, BoxedUnit>)(Function1 & Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.log.trace("Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError((Object)reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    Option<Uuid> topicId = ((InitialFetchState)x0$2._2()).topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(null);
            });
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$1, UnifiedLog x$2) {
        Uuid targetDir = (Uuid)partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$1.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, int fetchBackOffMs, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        super(name, name, leader, failedPartitions, new TierStateMachine(leader, replicaMgr, true), fetchBackOffMs, false, brokerTopicStats);
        this.promotionStates = new ConcurrentHashMap();
    }

    public static class PromotionState
    implements Product,
    Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        public String productPrefix() {
            return "PromotionState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "reassignmentState";
                }
                case 1: {
                    return "topicId";
                }
                case 2: {
                    return "currentDir";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PromotionState)) break block3;
                    PromotionState promotionState = (PromotionState)x$1;
                    ReassignmentState reassignmentState = this.reassignmentState();
                    ReassignmentState reassignmentState2 = promotionState.reassignmentState();
                    if (reassignmentState != null ? !reassignmentState.equals(reassignmentState2) : reassignmentState2 != null) break block3;
                    Option<Uuid> option = this.topicId();
                    Option<Uuid> option2 = promotionState.topicId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<Uuid> option3 = this.currentDir();
                    Option<Uuid> option4 = promotionState.currentDir();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !promotionState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$((Product)this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

