/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.ShareGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;

public class SimpleAssignor
implements ShareGroupPartitionAssignor {
    private static final String SIMPLE_ASSIGNOR_NAME = "simple";

    public String name() {
        return SIMPLE_ASSIGNOR_NAME;
    }

    public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        if (groupSpec.memberIds().isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        if (groupSpec.subscriptionType().equals((Object)SubscriptionType.HOMOGENEOUS)) {
            return this.assignHomogenous(groupSpec, subscribedTopicDescriber);
        }
        return this.assignHeterogeneous(groupSpec, subscribedTopicDescriber);
    }

    private GroupAssignment assignHomogenous(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        Set subscribeTopicIds = groupSpec.memberSubscription((String)groupSpec.memberIds().iterator().next()).subscribedTopicIds();
        if (subscribeTopicIds.isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        Map<Uuid, Set<Integer>> targetPartitions = this.computeTargetPartitions(subscribeTopicIds, subscribedTopicDescriber);
        return new GroupAssignment(groupSpec.memberIds().stream().collect(Collectors.toMap(Function.identity(), memberId -> new MemberAssignmentImpl(targetPartitions))));
    }

    private GroupAssignment assignHeterogeneous(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        HashMap<String, MemberAssignmentImpl> members = new HashMap<String, MemberAssignmentImpl>();
        for (String memberId : groupSpec.memberIds()) {
            MemberSubscription spec = groupSpec.memberSubscription(memberId);
            if (spec.subscribedTopicIds().isEmpty()) continue;
            Map<Uuid, Set<Integer>> targetPartitions = this.computeTargetPartitions(spec.subscribedTopicIds(), subscribedTopicDescriber);
            members.put(memberId, new MemberAssignmentImpl(targetPartitions));
        }
        return new GroupAssignment(members);
    }

    private Map<Uuid, Set<Integer>> computeTargetPartitions(Set<Uuid> subscribeTopicIds, SubscribedTopicDescriber subscribedTopicDescriber) {
        HashMap<Uuid, Set<Integer>> targetPartitions = new HashMap<Uuid, Set<Integer>>();
        subscribeTopicIds.forEach(topicId -> {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            if (numPartitions == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + String.valueOf(topicId) + " which doesn't exist in the topic metadata.");
            }
            HashSet<Integer> partitions = new HashSet<Integer>();
            for (int i = 0; i < numPartitions; ++i) {
                partitions.add(i);
            }
            targetPartitions.put((Uuid)topicId, (Set<Integer>)partitions);
        });
        return targetPartitions;
    }
}

