/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.AbortTransactionRecord;
import org.apache.kafka.common.metadata.BeginTransactionRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.EndTransactionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class ActivationRecordsGenerator {
    static ControllerResult<Void> recordsForEmptyLog(Consumer<String> activationMessageConsumer, long transactionStartOffset, BootstrapMetadata bootstrapMetadata, MetadataVersion metadataVersion, int defaultMinInSyncReplicas) {
        StringBuilder logMessageBuilder = new StringBuilder("Performing controller activation. ");
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        if (transactionStartOffset != -1L) {
            if (!metadataVersion.isMetadataTransactionSupported()) {
                throw new RuntimeException("Detected partial bootstrap records transaction at " + transactionStartOffset + ", but the metadata.version " + String.valueOf(metadataVersion) + " does not support transactions. Cannot continue.");
            }
            logMessageBuilder.append("Aborting partial bootstrap records transaction at offset ").append(transactionStartOffset).append(". Re-appending ").append(bootstrapMetadata.records().size()).append(" bootstrap record(s) in new metadata transaction at metadata.version ").append(metadataVersion).append(" from bootstrap source '").append(bootstrapMetadata.source()).append("'. ");
            records.add(new ApiMessageAndVersion((ApiMessage)new AbortTransactionRecord().setReason("Controller failover"), 0));
            records.add(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("Bootstrap records"), 0));
        } else {
            logMessageBuilder.append("The metadata log appears to be empty. ").append("Appending ").append(bootstrapMetadata.records().size()).append(" bootstrap record(s) ");
            if (metadataVersion.isMetadataTransactionSupported()) {
                records.add(new ApiMessageAndVersion((ApiMessage)new BeginTransactionRecord().setName("Bootstrap records"), 0));
                logMessageBuilder.append("in metadata transaction ");
            }
            logMessageBuilder.append("at metadata.version ").append(metadataVersion).append(" from bootstrap source '").append(bootstrapMetadata.source()).append("'. ");
        }
        records.addAll(bootstrapMetadata.records());
        if (bootstrapMetadata.featureLevel("eligible.leader.replicas.version") > 0) {
            records.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("min.insync.replicas").setValue(Integer.toString(defaultMinInSyncReplicas)), 0));
        }
        activationMessageConsumer.accept(logMessageBuilder.toString().trim());
        if (metadataVersion.isMetadataTransactionSupported()) {
            records.add(new ApiMessageAndVersion((ApiMessage)new EndTransactionRecord(), 0));
            return ControllerResult.of(records, null);
        }
        return ControllerResult.atomicOf(records, null);
    }

    static ControllerResult<Void> recordsForNonEmptyLog(Consumer<String> activationMessageConsumer, long transactionStartOffset, MetadataVersion curMetadataVersion) {
        StringBuilder logMessageBuilder = new StringBuilder("Performing controller activation. ");
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        if (transactionStartOffset != -1L) {
            if (!curMetadataVersion.isMetadataTransactionSupported()) {
                throw new RuntimeException("Detected in-progress transaction at offset " + transactionStartOffset + ", but the metadata.version " + String.valueOf(curMetadataVersion) + " does not support transactions. Cannot continue.");
            }
            logMessageBuilder.append("Aborting in-progress metadata transaction at offset ").append(transactionStartOffset).append(". ");
            records.add(new ApiMessageAndVersion((ApiMessage)new AbortTransactionRecord().setReason("Controller failover"), 0));
        }
        activationMessageConsumer.accept(logMessageBuilder.toString().trim());
        return ControllerResult.atomicOf(records, null);
    }

    static ControllerResult<Void> generate(Consumer<String> activationMessageConsumer, boolean isEmpty, long transactionStartOffset, BootstrapMetadata bootstrapMetadata, MetadataVersion curMetadataVersion, int defaultMinInSyncReplicas) {
        if (isEmpty) {
            return ActivationRecordsGenerator.recordsForEmptyLog(activationMessageConsumer, transactionStartOffset, bootstrapMetadata, bootstrapMetadata.metadataVersion(), defaultMinInSyncReplicas);
        }
        return ActivationRecordsGenerator.recordsForNonEmptyLog(activationMessageConsumer, transactionStartOffset, curMetadataVersion);
    }
}

