/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.message.ShareFetchResponseData;

public class ShareAcquiredRecords {
    private static final ShareAcquiredRecords EMPTY_SHARE_ACQUIRED_RECORDS = new ShareAcquiredRecords();
    private final List<ShareFetchResponseData.AcquiredRecords> acquiredRecords;
    private final int count;

    public ShareAcquiredRecords(List<ShareFetchResponseData.AcquiredRecords> acquiredRecords, int count) {
        this.acquiredRecords = acquiredRecords;
        this.count = count;
    }

    private ShareAcquiredRecords() {
        this.acquiredRecords = Collections.emptyList();
        this.count = 0;
    }

    public List<ShareFetchResponseData.AcquiredRecords> acquiredRecords() {
        return this.acquiredRecords;
    }

    public int count() {
        return this.count;
    }

    public static ShareAcquiredRecords empty() {
        return EMPTY_SHARE_ACQUIRED_RECORDS;
    }

    public static ShareAcquiredRecords fromAcquiredRecords(ShareFetchResponseData.AcquiredRecords acquiredRecords) {
        return new ShareAcquiredRecords(List.of(acquiredRecords), (int)(acquiredRecords.lastOffset() - acquiredRecords.firstOffset() + 1L));
    }
}

