/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKeyJsonConverter;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValueJsonConverter;
import org.apache.kafka.tools.consumer.ApiMessageFormatter;

public class TransactionLogMessageFormatter
extends ApiMessageFormatter {
    @Override
    protected JsonNode readToKeyJson(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 0) {
            return TransactionLogKeyJsonConverter.write((TransactionLogKey)new TransactionLogKey((Readable)new ByteBufferAccessor(byteBuffer), version), (short)version);
        }
        return NullNode.getInstance();
    }

    @Override
    protected JsonNode readToValueJson(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 1) {
            return TransactionLogValueJsonConverter.write((TransactionLogValue)new TransactionLogValue((Readable)new ByteBufferAccessor(byteBuffer), version), (short)version);
        }
        return new TextNode("unknown");
    }
}

