/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.ConnectionThrottledException;
import org.apache.kafka.network.TooManyConnectionsException;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011ucA\u00022d\u0003\u0003)w\r\u0003\u0005z\u0001\t\u0015\r\u0011\"\u0001|\u0011%\t\t\u0001\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0004\u0001\u0011)\u0019!C\u0001\u0003\u000bA!\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\t)\u0002\u0001BA\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003K\u0001!\u00111A\u0005\u0002\u0005\u001d\u0002BCA\u001d\u0001\t\u0005\t\u0015)\u0003\u0002\u001a!Q\u00111\b\u0001\u0003\u0002\u0003\u0006I!!\u0010\t\u0015\u0005\r\u0003A!b\u0001\n\u0003\t)\u0005\u0003\u0006\u0002N\u0001\u0011\t\u0011)A\u0005\u0003\u000fB!\"a\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA)\u0011)\tI\u0007\u0001B\u0001B\u0003%\u00111\u000e\u0005\u000b\u0003c\u0002!\u0011!Q\u0001\n\u0005M\u0004BCA=\u0001\t\u0005\t\u0015!\u0003\u0002|!Q\u0011Q\u0011\u0001\u0003\u0002\u0003\u0006I!a\"\t\u0015\u0005M\u0005A!A!\u0002\u0013\t)\n\u0003\u0006\u0002\u001c\u0002\u0011\t\u0011)A\u0005\u0003;C!\"!+\u0001\u0005\u0003\u0005\u000b\u0011BAV\u0011\u001d\t\t\f\u0001C\u0001\u0003gC\u0011\"!5\u0001\u0005\u0004%I!a5\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003+D\u0011\"a9\u0001\u0005\u0004%\t!!:\t\u0011\u0005m\b\u0001)A\u0005\u0003ODq!!@\u0001\r\u0003\ty\u0010C\u0004\u0003\u0018\u00011\t!a@\t\u0013\te\u0001A1A\u0005\n\tm\u0001\u0002\u0003B\u0012\u0001\u0001\u0006IA!\b\t\u0013\t\u0015\u0002A1A\u0005\n\tm\u0001\u0002\u0003B\u0014\u0001\u0001\u0006IA!\b\t\u0013\t%\u0002A1A\u0005\n\tm\u0001\u0002\u0003B\u0016\u0001\u0001\u0006IA!\b\t\u0013\t5\u0002A1A\u0005\n\t=\u0002\u0002\u0003B!\u0001\u0001\u0006IA!\r\t\u0019\t\r\u0003\u00011AA\u0002\u0013\u00051M!\u0012\t\u0019\t5\u0003\u00011AA\u0002\u0013\u00051Ma\u0014\t\u0017\tM\u0003\u00011A\u0001B\u0003&!q\t\u0005\u000b\u0005+\u0002!\u0019!C\u0001G\n]\u0003\u0002\u0003B-\u0001\u0001\u0006I!!\u0010\t\u0015\tm\u0003A1A\u0005\u0002\r\u0014i\u0006\u0003\u0005\u0003v\u0001\u0001\u000b\u0011\u0002B0\u0011%\u00119\b\u0001b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0003z\u0001\u0001\u000b\u0011BAk\u0011%\u0011Y\b\u0001b\u0001\n\u0013\u0011i\b\u0003\u0005\u0003\u0016\u0002\u0001\u000b\u0011\u0002B@\u0011%\u00119\n\u0001b\u0001\n\u0013\u0011I\n\u0003\u0005\u0003\"\u0002\u0001\u000b\u0011\u0002BN\u0011%\u0011\u0019\u000b\u0001a\u0001\n\u0013\u00119\u0006C\u0005\u0003&\u0002\u0001\r\u0011\"\u0003\u0003(\"A!1\u0016\u0001!B\u0013\ti\u0004\u0003\u0006\u0003.\u0002\u0011\r\u0011\"\u0001d\u0005_C\u0001ba\u001b\u0001A\u0003%!\u0011\u0017\u0005\n\u0007[\u0002!\u0019!C\u0005\u0003KD\u0001ba\u001c\u0001A\u0003%\u0011q\u001d\u0005\u000b\u0007c\u0002!\u0019!C\u0001G\u000eM\u0004\u0002CBB\u0001\u0001\u0006Ia!\u001e\t\u0013\r\u0015\u0005A1A\u0005\u0002\r\u001d\u0005\u0002CBH\u0001\u0001\u0006Ia!#\t\u000f\rE\u0005\u0001\"\u0001\u0004\u0014\u001a9!1\u0018\u0001AG\nu\u0006B\u0003Brw\tU\r\u0011\"\u0001\u0003f\"Q!Q^\u001e\u0003\u0012\u0003\u0006IAa:\t\u0015\t=8H!f\u0001\n\u0003\u0011\t\u0010\u0003\u0006\u0003zn\u0012\t\u0012)A\u0005\u0005gDq!!-<\t\u0003\u0011Y\u0010C\u0004\u0004\u0002m\"\tea\u0001\t\u0013\r%1(!A\u0005\u0002\r-\u0001\"CB\twE\u0005I\u0011AB\n\u0011%\u0019IcOI\u0001\n\u0003\u0019Y\u0003C\u0005\u00040m\n\t\u0011\"\u0011\u00042!I1qG\u001e\u0002\u0002\u0013\u0005!q\u000b\u0005\n\u0007sY\u0014\u0011!C\u0001\u0007wA\u0011b!\u0012<\u0003\u0003%\tea\u0012\t\u0013\rE3(!A\u0005\u0002\rM\u0003\"CB,w\u0005\u0005I\u0011IB-\u0011%\u0019ifOA\u0001\n\u0003\u001ay\u0006C\u0005\u0004bm\n\t\u0011\"\u0011\u0004d!I1QM\u001e\u0002\u0002\u0013\u00053qM\u0004\u000b\u0007+\u0003\u0011\u0011!E\u0001G\u000e]eA\u0003B^\u0001\u0005\u0005\t\u0012A2\u0004\u001a\"9\u0011\u0011W(\u0005\u0002\rE\u0006\"CB1\u001f\u0006\u0005IQIB2\u0011%\u0019\u0019lTA\u0001\n\u0003\u001b)\fC\u0005\u0004<>\u000b\t\u0011\"!\u0004>\"A1q\u001a\u0001\u0005\u0002\r\u001c\t\u000eC\u0004\u0004X\u0002!\taa%\t\u000f\re\u0007\u0001\"\u0001\u0004\u0014\"911\u001c\u0001\u0005B\rM\u0005bBBo\u0001\u0011%11\u0013\u0005\b\u0007?\u0004A\u0011BBq\u0011\u001d\u0019i\u000f\u0001C\u0005\u0007'Cqaa<\u0001\t\u0013\u0019\t\u0010C\u0004\u0004\u0000\u0002!\t\u0002\"\u0001\t\u000f\u0011\u001d\u0001\u0001\"\u0003\u0004\u0014\"9A\u0011\u0002\u0001\u0005\n\u0011-\u0001b\u0002C\f\u0001\u0011\u000511\u0013\u0005\b\t3\u0001A\u0011\u0001C\u000e\u0011\u001d!\t\u0003\u0001C\u0001\tG\u0011\u0001\"Q2dKB$xN\u001d\u0006\u0003I\u0016\fqA\\3uo>\u00148NC\u0001g\u0003\u0015Y\u0017MZ6b'\u0011\u0001\u0001\u000e]:\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001\u00027b]\u001eT\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\n1qJ\u00196fGR\u0004\"![9\n\u0005IT'\u0001\u0003*v]:\f'\r\\3\u0011\u0005Q<X\"A;\u000b\u0005Y,\u0017!B;uS2\u001c\u0018B\u0001=v\u0005\u001daunZ4j]\u001e\fAb]8dW\u0016$8+\u001a:wKJ\u001c\u0001!F\u0001}!\tih0D\u0001d\u0013\ty8M\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0007t_\u000e\\W\r^*feZ,'\u000fI\u0001\tK:$\u0007k\\5oiV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB3\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011CA\u0006\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD3\u0002\rM,'O^3s\u0013\u0011\t\u0019#!\b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u0015\u0003k\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0003\u0003_\tQa]2bY\u0006LA!a\r\u0002.\t!QK\\5u\u0011%\t9DBA\u0001\u0002\u0004\tI\"A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0005\u0003W\ty$\u0003\u0003\u0002B\u00055\"aA%oi\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0003\u0003\u000f\u00022!`A%\u0013\r\tYe\u0019\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\f\u0011cY8o]\u0016\u001cG/[8o#V|G/Y:!\u0003\u0011!\u0018.\\3\u0011\t\u0005M\u0013QM\u0007\u0003\u0003+R1A^A,\u0015\u0011\tI&a\u0017\u0002\r\r|W.\\8o\u0015\r1\u0017Q\f\u0006\u0005\u0003?\n\t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003G\n1a\u001c:h\u0013\u0011\t9'!\u0016\u0003\tQKW.Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\t\u0005-\u0012QN\u0005\u0005\u0003_\niCA\u0004C_>dW-\u00198\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0019Q0!\u001e\n\u0007\u0005]4M\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\u000f5,GO]5dgB!\u0011QPAA\u001b\t\tyH\u0003\u0003\u0002z\u0005]\u0013\u0002BAB\u0003\u007f\u0012q!T3ue&\u001c7/\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\u0003BAE\u0003\u001fk!!a#\u000b\t\u00055\u00151L\u0001\tg\u0016\u001cWO]5us&!\u0011\u0011SAF\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002T\u0005]\u0015\u0002BAM\u0003+\u0012!\u0002T8h\u0007>tG/\u001a=u\u0003)iW-\\8ssB{w\u000e\u001c\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*!\u00111UA,\u0003\u0019iW-\\8ss&!\u0011qUAQ\u0005)iU-\\8ssB{w\u000e\\\u0001\u0012CBLg+\u001a:tS>tW*\u00198bO\u0016\u0014\b\u0003BA\u000e\u0003[KA!a,\u0002\u001e\t\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)q\t),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\u0002H\u0006%\u00171ZAg\u0003\u001f\u0004\"! \u0001\t\u000be\u001c\u0002\u0019\u0001?\t\u000f\u0005\r1\u00031\u0001\u0002\b!9\u0011QC\nA\u0002\u0005e\u0001bBA\u001e'\u0001\u0007\u0011Q\b\u0005\b\u0003\u0007\u001a\u0002\u0019AA$\u0011\u001d\tye\u0005a\u0001\u0003#Bq!!\u001b\u0014\u0001\u0004\tY\u0007C\u0004\u0002rM\u0001\r!a\u001d\t\u000f\u0005e4\u00031\u0001\u0002|!9\u0011QQ\nA\u0002\u0005\u001d\u0005bBAJ'\u0001\u0007\u0011Q\u0013\u0005\b\u00037\u001b\u0002\u0019AAO\u0011\u001d\tIk\u0005a\u0001\u0003W\u000bA\"\\3ue&\u001c7o\u0012:pkB,\"!!6\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!!\u001f\u0002\\*!\u0011qDA.\u0013\u0011\ty.!7\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\ng\"|W\u000f\u001c3Sk:,\"!a:\u0011\t\u0005%\u0018q_\u0007\u0003\u0003WTA!!<\u0002p\u00061\u0011\r^8nS\u000eTA!!=\u0002t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005UH.\u0001\u0003vi&d\u0017\u0002BA}\u0003W\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017AC:i_VdGMU;oA\u0005aQ.\u001a;sS\u000e\u0004&/\u001a4jqR\u0011!\u0011\u0001\t\u0005\u0005\u0007\u0011\tB\u0004\u0003\u0003\u0006\t5\u0001\u0003\u0002B\u0004\u0003[i!A!\u0003\u000b\u0007\t-!0\u0001\u0004=e>|GOP\u0005\u0005\u0005\u001f\ti#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005'\u0011)B\u0001\u0004TiJLgn\u001a\u0006\u0005\u0005\u001f\ti#\u0001\u0007uQJ,\u0017\r\u001a)sK\u001aL\u00070\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0005\tu\u0001cA5\u0003 %\u0019!\u0011\u00056\u0003\u000f%sG/Z4fe\u0006y1/\u001a8e\u0005V4g-\u001a:TSj,\u0007%\u0001\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3\u0002\u001fI,7M\u001e\"vM\u001a,'oU5{K\u0002\n\u0011\u0003\\5ti\u0016t')Y2lY><7+\u001b>f\u0003Ia\u0017n\u001d;f]\n\u000b7m\u001b7pONK'0\u001a\u0011\u0002\u00179LwnU3mK\u000e$xN]\u000b\u0003\u0005c\u0001BAa\r\u0003>5\u0011!Q\u0007\u0006\u0005\u0005o\u0011I$\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011Y\u0004\\\u0001\u0004]&|\u0017\u0002\u0002B \u0005k\u0011\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\t\u001d\u0003\u0003\u0002B\u001a\u0005\u0013JAAa\u0013\u00036\t\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006\t2/\u001a:wKJ\u001c\u0005.\u00198oK2|F%Z9\u0015\t\u0005%\"\u0011\u000b\u0005\n\u0003o\u0019\u0013\u0011!a\u0001\u0005\u000f\nab]3sm\u0016\u00148\t[1o]\u0016d\u0007%A\u0005m_\u000e\fG\u000eU8siV\u0011\u0011QH\u0001\u000bY>\u001c\u0017\r\u001c)peR\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011!q\f\t\u0007\u0005C\u0012YGa\u001c\u000e\u0005\t\r$\u0002\u0002B3\u0005O\nq!\\;uC\ndWM\u0003\u0003\u0003j\u00055\u0012AC2pY2,7\r^5p]&!!Q\u000eB2\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007u\u0014\t(C\u0002\u0003t\r\u0014\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u0002\u0017A\u0014xnY3tg>\u00148\u000fI\u0001!E\u0006\u001c7n^1sI\u000e{W\u000e]1uS\nLG.\u001b;z\u001b\u0016$(/[2He>,\b/A\u0011cC\u000e\\w/\u0019:e\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=NKR\u0014\u0018nY$s_V\u0004\b%A\u000fcY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'/T3ue&\u001cg*Y7f+\t\u0011y\b\u0005\u0003\u0003\u0002\nEUB\u0001BB\u0015\u0011\u0011)Ia\"\u0002\t\r|'/\u001a\u0006\u0005\u0003s\u0012II\u0003\u0003\u0003\f\n5\u0015AB=b[6,'O\u0003\u0002\u0003\u0010\u0006\u00191m\\7\n\t\tM%1\u0011\u0002\u000b\u001b\u0016$(/[2OC6,\u0017A\b2m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014X*\u001a;sS\u000et\u0015-\\3!\u0003M\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3s+\t\u0011Y\n\u0005\u0003\u0003\u0002\nu\u0015\u0002\u0002BP\u0005\u0007\u0013Q!T3uKJ\fAC\u00197pG.,G\rU3sG\u0016tG/T3uKJ\u0004\u0013!F2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r_\u0001\u001aGV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0003\u0002*\t%\u0006\"CA\u001ca\u0005\u0005\t\u0019AA\u001f\u0003Y\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb\u0004\u0013\u0001\u0005;ie>$H\u000f\\3e'>\u001c7.\u001a;t+\t\u0011\t\f\u0005\u0004\u0003b\tM&qW\u0005\u0005\u0005k\u0013\u0019GA\u0007Qe&|'/\u001b;z#V,W/\u001a\t\u0004\u0005s[T\"\u0001\u0001\u0003%\u0011+G.Y=fI\u000ecwn]3T_\u000e\\W\r^\n\nw\t}&Q\u0019Bl\u0005;\u0004B!a\u000b\u0003B&!!1YA\u0017\u0005\u0019\te.\u001f*fMB1!q\u0019Bi\u0005osAA!3\u0003N:!!q\u0001Bf\u0013\t\ty#\u0003\u0003\u0003P\u00065\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005'\u0014)NA\u0004Pe\u0012,'/\u001a3\u000b\t\t=\u0017Q\u0006\t\u0005\u0003W\u0011I.\u0003\u0003\u0003\\\u00065\"a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005\u000f\u0014y.\u0003\u0003\u0003b\nU'\u0001D*fe&\fG.\u001b>bE2,\u0017AB:pG.,G/\u0006\u0002\u0003hB!!1\u0007Bu\u0013\u0011\u0011YO!\u000e\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003\u001d\u0019xnY6fi\u0002\n\u0011#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\u0011\u0019\u0010\u0005\u0003\u0002,\tU\u0018\u0002\u0002B|\u0003[\u0011A\u0001T8oO\u0006\u0011RM\u001c3UQJ|G\u000f\u001e7f)&lW-T:!)\u0019\u00119L!@\u0003\u0000\"9!1\u001d!A\u0002\t\u001d\bb\u0002Bx\u0001\u0002\u0007!1_\u0001\bG>l\u0007/\u0019:f)\u0011\tid!\u0002\t\u000f\r\u001d\u0011\t1\u0001\u00038\u0006!A\u000f[1u\u0003\u0011\u0019w\u000e]=\u0015\r\t]6QBB\b\u0011%\u0011\u0019O\u0011I\u0001\u0002\u0004\u00119\u000fC\u0005\u0003p\n\u0003\n\u00111\u0001\u0003t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u000bU\u0011\u00119oa\u0006,\u0005\re\u0001\u0003BB\u000e\u0007Ki!a!\b\u000b\t\r}1\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012TAaa\t\u0002.\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001d2Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0007[QCAa=\u0004\u0018\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"aa\r\u0011\u0007%\u001c)$C\u0002\u0003\u0014)\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004>\r\r\u0003\u0003BA\u0016\u0007\u007fIAa!\u0011\u0002.\t\u0019\u0011I\\=\t\u0013\u0005]r)!AA\u0002\u0005u\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r%\u0003CBB&\u0007\u001b\u001ai$\u0004\u0002\u0003h%!1q\nB4\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-4Q\u000b\u0005\n\u0003oI\u0015\u0011!a\u0001\u0007{\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!11GB.\u0011%\t9DSA\u0001\u0002\u0004\ti$\u0001\u0005iCND7i\u001c3f)\t\ti$\u0001\u0005u_N#(/\u001b8h)\t\u0019\u0019$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\u001aI\u0007C\u0005\u000285\u000b\t\u00111\u0001\u0004>\u0005\tB\u000f\u001b:piRdW\rZ*pG.,Go\u001d\u0011\u0002\u000fM$\u0018M\u001d;fI\u0006A1\u000f^1si\u0016$\u0007%A\u0007ti\u0006\u0014H/\u001a3GkR,(/Z\u000b\u0003\u0007k\u0002baa\u001e\u0004z\ruTBAAx\u0013\u0011\u0019Y(a<\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002j\u0007\u007fJ1a!!k\u0005\u00111v.\u001b3\u0002\u001dM$\u0018M\u001d;fI\u001a+H/\u001e:fA\u00051A\u000f\u001b:fC\u0012,\"a!#\u0011\t\u0005M31R\u0005\u0005\u0007\u001b\u000b)FA\u0006LC\u001a\\\u0017\r\u00165sK\u0006$\u0017a\u0002;ie\u0016\fG\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003S\t!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiB\u0019!\u0011X(\u0014\u000b=\u001bYja*\u0011\u0015\ru51\u0015Bt\u0005g\u00149,\u0004\u0002\u0004 *!1\u0011UA\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LAa!*\u0004 \n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\r%6qV\u0007\u0003\u0007WS1a!,m\u0003\tIw.\u0003\u0003\u0003b\u000e-FCABL\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u00119la.\u0004:\"9!1\u001d*A\u0002\t\u001d\bb\u0002Bx%\u0002\u0007!1_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yla3\u0011\r\u0005-2\u0011YBc\u0013\u0011\u0019\u0019-!\f\u0003\r=\u0003H/[8o!!\tYca2\u0003h\nM\u0018\u0002BBe\u0003[\u0011a\u0001V;qY\u0016\u0014\u0004\"CBg'\u0006\u0005\t\u0019\u0001B\\\u0003\rAH\u0005M\u0001\u0011e\u0016lwN^3Qe>\u001cWm]:peN$B!!\u000b\u0004T\"91Q\u001b+A\u0002\u0005u\u0012a\u0003:f[>4XmQ8v]R\fQBY3hS:\u001c\u0006.\u001e;e_^t\u0017!B2m_N,\u0017a\u0001:v]\u0006A1\r\\8tK\u0006cG.\u0001\tpa\u0016t7+\u001a:wKJ\u001cvnY6fiRA!qIBr\u0007O\u001cY\u000fC\u0004\u0004ff\u0003\rA!\u0001\u0002\t!|7\u000f\u001e\u0005\b\u0007SL\u0006\u0019AA\u001f\u0003\u0011\u0001xN\u001d;\t\u000f\t%\u0012\f1\u0001\u0002>\u0005!\u0012mY2faRtUm^\"p]:,7\r^5p]N\fa!Y2dKB$H\u0003BBz\u0007k\u0004b!a\u000b\u0004B\n\u001d\bbBB|7\u0002\u00071\u0011`\u0001\u0004W\u0016L\b\u0003\u0002B\u001a\u0007wLAa!@\u00036\ta1+\u001a7fGRLwN\\&fs\u0006q2m\u001c8gS\u001e,(/Z!dG\u0016\u0004H/\u001a3T_\u000e\\W\r^\"iC:tW\r\u001c\u000b\u0005\u0003S!\u0019\u0001C\u0004\u0005\u0006q\u0003\rAa:\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0003e\u0019Gn\\:f)\"\u0014x\u000e\u001e;mK\u0012\u001cuN\u001c8fGRLwN\\:\u0002'\u0005\u001c8/[4o\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0011\u0005-DQ\u0002C\b\t'Aq\u0001\"\u0002_\u0001\u0004\u00119\u000fC\u0004\u0005\u0012y\u0003\rAa\u001c\u0002\u0013A\u0014xnY3tg>\u0014\bb\u0002C\u000b=\u0002\u0007\u00111N\u0001\t[\u0006L(\t\\8dW\u00061q/Y6fkB\fQ\"\u00193e!J|7-Z:t_J\u001cH\u0003BA\u0015\t;Aq\u0001b\ba\u0001\u0004\ti$\u0001\u0005u_\u000e\u0013X-\u0019;f\u00031qWm\u001e)s_\u000e,7o]8s))\u0011y\u0007\"\n\u0005*\u0011]B\u0011\n\u0005\b\tO\t\u0007\u0019AA\u001f\u0003\tIG\rC\u0004\u0005,\u0005\u0004\r\u0001\"\f\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0011=B1G\u0007\u0003\tcQ1\u0001ZA,\u0013\u0011!)\u0004\"\r\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u0011e\u0012\r1\u0001\u0005<\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\t{!)%\u0004\u0002\u0005@)!A\u0011\tC\"\u0003\u0011\tW\u000f\u001e5\u000b\t\u00055\u0015qK\u0005\u0005\t\u000f\"yD\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"9A1J1A\u0002\u00115\u0013!H2p]:,7\r^5p]\u0012K7oY8o]\u0016\u001cG\u000fT5ti\u0016tWM]:\u0011\r\r-Cq\nC*\u0013\u0011!\tFa\u001a\u0003\u0007M+\u0017\u000f\u0005\u0003\u0005V\u0011eSB\u0001C,\u0015\r!\u00171\\\u0005\u0005\t7\"9F\u0001\u000fD_:tWm\u0019;j_:$\u0015n]2p]:,7\r\u001e'jgR,g.\u001a:")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final KafkaMetricsGroup backwardCompatibilityMetricGroup;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private final AtomicBoolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private KafkaMetricsGroup backwardCompatibilityMetricGroup() {
        return this.backwardCompatibilityMetricGroup;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable)x$10 -> {
                    x$10.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        if (!this.started().get()) {
            this.closeAll();
        }
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$11 -> {
                x$11.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.closeAll();
        }
    }

    private void closeAll() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
        Utils.closeQuietly((AutoCloseable)this.serverChannel(), (String)"Acceptor serverChannel");
        Utils.closeQuietly((AutoCloseable)this.nioSelector(), (String)"Acceptor nioSelector");
        this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
            SocketServer$.MODULE$.closeSocket(throttledSocket.socket());
            return BoxedUnit.UNIT;
        });
        this.throttledSockets().clear();
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = this.socketServer().socketFactory().openServerSocket(this.endPoint().listenerName().value(), socketAddress, listenBacklogSize, Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        this.info((Function0<String>)(Function0 & Serializable)() -> "Awaiting socket connections on " + socketAddress.getHostString() + ":" + serverChannel.socket().getLocalPort() + ".");
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Rejected connection from " + e$3.ip + ", address already has the configured maximum of " + e$3.count + " connections.");
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Delaying closing of connection from " + ip + " for " + e$4.throttleTimeMs + " ms");
            long endThrottleTimeMs = e.startThrottleTimeMs + e.throttleTimeMs;
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$12)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing socket from ip " + closingSocket.socket().getRemoteAddress());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket());
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Accepted connection from " + socketChannel.socket().getRemoteSocketAddress() + " on " + socketChannel.socket().getLocalSocketAddress() + " and assigned it to processor " + processor.id() + ", sendBufferSize [actual|requested]: [" + socketChannel.socket().getSendBufferSize() + "|" + this.sendBufferSize() + "] recvBufferSize [actual|requested]: [" + socketChannel.socket().getReceiveBufferSize() + "|" + this.recvBufferSize() + "]");
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol, this.socketServer().connectionDisconnectListeners());
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started().get()) {
                    processor.start();
                    return;
                }
            });
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        String name = this.threadPrefix() + "-kafka-network-thread-" + this.nodeId + "-" + this.endPoint().listenerName() + "-" + this.endPoint().securityProtocol() + "-" + id;
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name, connectionDisconnectListeners);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Opened endpoint " + this.endPoint().host() + ":" + this.endPoint().port());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting processors for listener " + this.endPoint().listenerName());
            this.processors().foreach((Function1 & Serializable)x$8 -> {
                x$8.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting acceptor thread for listener " + this.endPoint().listenerName());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started().set(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Refusing to start acceptor for " + this.endPoint().listenerName() + " since the acceptor has already been shut down.");
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to start acceptor for " + this.endPoint().listenerName(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException("Unable to start acceptor for " + this.endPoint().listenerName(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$12) {
        return x$12.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Opened wildcard endpoint " + this.endPoint().host() + ":" + newPort);
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.backwardCompatibilityMetricGroup = new KafkaMetricsGroup("kafka.network", "Acceptor");
        this.blockedPercentMeterMetricName = this.backwardCompatibilityMetricGroup().metricName(this.metricPrefix() + "AcceptorBlockedPercent", CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))).asJava());
        this.blockedPercentMeter = this.metricsGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.started = new AtomicBoolean();
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = this.threadPrefix() + "-kafka-socket-acceptor-" + endPoint.listenerName() + "-" + endPoint.securityProtocol() + "-" + endPoint.port();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

