/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.kafka.trogdor.workload.PayloadGenerator;
import org.apache.kafka.trogdor.workload.RandomComponent;

public class RandomComponentPayloadGenerator
implements PayloadGenerator {
    private final long seed;
    private final List<RandomComponent> components;
    private final Random random = new Random();

    @JsonCreator
    public RandomComponentPayloadGenerator(@JsonProperty(value="seed") long seed, @JsonProperty(value="components") List<RandomComponent> components) {
        this.seed = seed;
        if (components == null || components.isEmpty()) {
            throw new IllegalArgumentException("Components must be a specified, non-empty list of RandomComponents.");
        }
        int sum = 0;
        for (RandomComponent component : components) {
            if (component.percent() < 1) {
                throw new IllegalArgumentException("Percent value must be greater than zero.");
            }
            sum += component.percent();
        }
        if (sum != 100) {
            throw new IllegalArgumentException("Components must be a list of RandomComponents such that the percent fields sum to 100");
        }
        this.components = new ArrayList<RandomComponent>(components);
    }

    @JsonProperty
    public long seed() {
        return this.seed;
    }

    @JsonProperty
    public List<RandomComponent> components() {
        return this.components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generate(long position) {
        int randPercent;
        Random random = this.random;
        synchronized (random) {
            this.random.setSeed(this.seed + position);
            randPercent = this.random.nextInt(100);
        }
        int curPercent = 0;
        RandomComponent com = this.components.get(0);
        for (RandomComponent component : this.components) {
            if ((curPercent += component.percent()) <= randPercent) continue;
            com = component;
            break;
        }
        return com.component().generate(position);
    }
}

