/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class TestRecord<K, V> {
    private final Headers headers;
    private final K key;
    private final V value;
    private final Instant recordTime;

    public TestRecord(K key, V value, Headers headers, Instant recordTime) {
        this.key = key;
        this.value = value;
        this.recordTime = recordTime;
        this.headers = new RecordHeaders((Iterable)headers);
    }

    public TestRecord(K key, V value, Headers headers, Long timestampMs) {
        if (timestampMs != null) {
            if (timestampMs < 0L) {
                throw new IllegalArgumentException(String.format("Invalid timestamp: %d. Timestamp should always be non-negative or null.", timestampMs));
            }
            this.recordTime = Instant.ofEpochMilli(timestampMs);
        } else {
            this.recordTime = null;
        }
        this.key = key;
        this.value = value;
        this.headers = new RecordHeaders((Iterable)headers);
    }

    public TestRecord(K key, V value, Instant recordTime) {
        this(key, value, null, recordTime);
    }

    public TestRecord(K key, V value, Headers headers) {
        this.key = key;
        this.value = value;
        this.headers = new RecordHeaders((Iterable)headers);
        this.recordTime = null;
    }

    public TestRecord(K key, V value) {
        this.key = key;
        this.value = value;
        this.headers = new RecordHeaders();
        this.recordTime = null;
    }

    public TestRecord(V value) {
        this(null, value);
    }

    public TestRecord(ConsumerRecord<K, V> record) {
        Objects.requireNonNull(record);
        this.key = record.key();
        this.value = record.value();
        this.headers = record.headers();
        this.recordTime = Instant.ofEpochMilli(record.timestamp());
    }

    public TestRecord(ProducerRecord<K, V> record) {
        Objects.requireNonNull(record);
        this.key = record.key();
        this.value = record.value();
        this.headers = record.headers();
        this.recordTime = Instant.ofEpochMilli(record.timestamp());
    }

    public Headers headers() {
        return this.headers;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public Long timestamp() {
        return this.recordTime == null ? null : Long.valueOf(this.recordTime.toEpochMilli());
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public Instant getRecordTime() {
        return this.recordTime;
    }

    public String toString() {
        return new StringJoiner(", ", TestRecord.class.getSimpleName() + "[", "]").add("key=" + this.key).add("value=" + this.value).add("headers=" + this.headers).add("recordTime=" + this.recordTime).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRecord that = (TestRecord)o;
        return Objects.equals(this.headers, that.headers) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.recordTime, that.recordTime);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.key, this.value, this.recordTime);
    }
}

