/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMessageFormatter
implements MessageFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMessageFormatter.class);
    private boolean printTimestamp = false;
    private boolean printKey = false;
    private boolean printValue = true;
    private boolean printPartition = false;
    private boolean printOffset = false;
    private boolean printHeaders = false;
    private byte[] keySeparator = this.utfBytes("\t");
    private byte[] lineSeparator = this.utfBytes("\n");
    private byte[] headersSeparator = this.utfBytes(",");
    private byte[] nullLiteral = this.utfBytes("null");
    private Optional<Deserializer<?>> keyDeserializer = Optional.empty();
    private Optional<Deserializer<?>> valueDeserializer = Optional.empty();
    private Optional<Deserializer<?>> headersDeserializer = Optional.empty();

    DefaultMessageFormatter() {
    }

    public void configure(Map<String, ?> configs) {
        if (configs.containsKey("print.timestamp")) {
            this.printTimestamp = this.getBoolProperty(configs, "print.timestamp");
        }
        if (configs.containsKey("print.key")) {
            this.printKey = this.getBoolProperty(configs, "print.key");
        }
        if (configs.containsKey("print.offset")) {
            this.printOffset = this.getBoolProperty(configs, "print.offset");
        }
        if (configs.containsKey("print.partition")) {
            this.printPartition = this.getBoolProperty(configs, "print.partition");
        }
        if (configs.containsKey("print.headers")) {
            this.printHeaders = this.getBoolProperty(configs, "print.headers");
        }
        if (configs.containsKey("print.value")) {
            this.printValue = this.getBoolProperty(configs, "print.value");
        }
        if (configs.containsKey("key.separator")) {
            this.keySeparator = this.getByteProperty(configs, "key.separator");
        }
        if (configs.containsKey("line.separator")) {
            this.lineSeparator = this.getByteProperty(configs, "line.separator");
        }
        if (configs.containsKey("headers.separator")) {
            this.headersSeparator = this.getByteProperty(configs, "headers.separator");
        }
        if (configs.containsKey("null.literal")) {
            this.nullLiteral = this.getByteProperty(configs, "null.literal");
        }
        this.keyDeserializer = this.getDeserializerProperty(configs, true, "key.deserializer");
        this.valueDeserializer = this.getDeserializerProperty(configs, false, "value.deserializer");
        this.headersDeserializer = this.getDeserializerProperty(configs, false, "headers.deserializer");
    }

    public boolean printValue() {
        return this.printValue;
    }

    public Optional<Deserializer<?>> keyDeserializer() {
        return this.keyDeserializer;
    }

    private void writeSeparator(PrintStream output, boolean columnSeparator) {
        try {
            if (columnSeparator) {
                output.write(this.keySeparator);
            } else {
                output.write(this.lineSeparator);
            }
        }
        catch (IOException ioe) {
            LOG.error("Unable to write the separator to the output", (Throwable)ioe);
        }
    }

    private byte[] deserialize(ConsumerRecord<byte[], byte[]> consumerRecord, Optional<Deserializer<?>> deserializer, byte[] sourceBytes, String topic) {
        byte[] nonNullBytes = sourceBytes != null ? sourceBytes : this.nullLiteral;
        return deserializer.map(value -> this.utfBytes(value.deserialize(topic, consumerRecord.headers(), nonNullBytes).toString())).orElse(nonNullBytes);
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        try {
            if (this.printTimestamp) {
                if (consumerRecord.timestampType() != TimestampType.NO_TIMESTAMP_TYPE) {
                    output.print(consumerRecord.timestampType() + ":" + consumerRecord.timestamp());
                } else {
                    output.print("NO_TIMESTAMP");
                }
                this.writeSeparator(output, this.printOffset || this.printPartition || this.printHeaders || this.printKey || this.printValue);
            }
            if (this.printPartition) {
                output.print("Partition:");
                output.print(consumerRecord.partition());
                this.writeSeparator(output, this.printOffset || this.printHeaders || this.printKey || this.printValue);
            }
            if (this.printOffset) {
                output.print("Offset:");
                output.print(consumerRecord.offset());
                this.writeSeparator(output, this.printHeaders || this.printKey || this.printValue);
            }
            if (this.printHeaders) {
                Iterator headersIt = consumerRecord.headers().iterator();
                if (!headersIt.hasNext()) {
                    output.print("NO_HEADERS");
                } else {
                    while (headersIt.hasNext()) {
                        Header header = (Header)headersIt.next();
                        output.print(header.key() + ":");
                        output.write(this.deserialize(consumerRecord, this.headersDeserializer, header.value(), consumerRecord.topic()));
                        if (!headersIt.hasNext()) continue;
                        output.write(this.headersSeparator);
                    }
                }
                this.writeSeparator(output, this.printKey || this.printValue);
            }
            if (this.printKey) {
                output.write(this.deserialize(consumerRecord, this.keyDeserializer, (byte[])consumerRecord.key(), consumerRecord.topic()));
                this.writeSeparator(output, this.printValue);
            }
            if (this.printValue) {
                output.write(this.deserialize(consumerRecord, this.valueDeserializer, (byte[])consumerRecord.value(), consumerRecord.topic()));
                output.write(this.lineSeparator);
            }
        }
        catch (IOException ioe) {
            LOG.error("Unable to write the consumer record to the output", (Throwable)ioe);
        }
    }

    private Map<String, ?> propertiesWithKeyPrefixStripped(String prefix, Map<String, ?> configs) {
        HashMap newConfigs = new HashMap();
        for (Map.Entry<String, ?> entry : configs.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            newConfigs.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return newConfigs;
    }

    private byte[] utfBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getByteProperty(Map<String, ?> configs, String key) {
        return this.utfBytes((String)configs.get(key));
    }

    private boolean getBoolProperty(Map<String, ?> configs, String key) {
        return ((String)configs.get(key)).trim().equalsIgnoreCase("true");
    }

    private Optional<Deserializer<?>> getDeserializerProperty(Map<String, ?> configs, boolean isKey, String key) {
        if (configs.containsKey(key)) {
            String name = (String)configs.get(key);
            try {
                Deserializer deserializer = (Deserializer)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Map<String, ?> deserializerConfig = this.propertiesWithKeyPrefixStripped(key + ".", configs);
                deserializer.configure(deserializerConfig, isKey);
                return Optional.of(deserializer);
            }
            catch (Exception e) {
                LOG.error("Unable to instantiate a deserializer from " + name, (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

