/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.file;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.file.FileStreamSourceTask;
import org.apache.kafka.connect.source.ExactlyOnceSupport;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(FileStreamSourceConnector.class);
    public static final String TOPIC_CONFIG = "topic";
    public static final String FILE_CONFIG = "file";
    public static final String TASK_BATCH_SIZE_CONFIG = "batch.size";
    public static final int DEFAULT_TASK_BATCH_SIZE = 2000;
    static final ConfigDef CONFIG_DEF = new ConfigDef().define("file", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Source filename. If not specified, the standard input will be used").define("topic", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.HIGH, "The topic to publish data to").define("batch.size", ConfigDef.Type.INT, (Object)2000, ConfigDef.Importance.LOW, "The maximum number of records the source task can read from the file each time it is polled");
    private Map<String, String> props;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> props) {
        this.props = props;
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, props);
        String filename = config.getString(FILE_CONFIG);
        filename = filename == null || filename.isEmpty() ? "standard input" : filename;
        log.info("Starting file source connector reading from {}", (Object)filename);
    }

    public Class<? extends Task> taskClass() {
        return FileStreamSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        configs.add(this.props);
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public ExactlyOnceSupport exactlyOnceSupport(Map<String, String> props) {
        AbstractConfig parsedConfig = new AbstractConfig(CONFIG_DEF, props);
        String filename = parsedConfig.getString(FILE_CONFIG);
        return filename != null && !filename.isEmpty() ? ExactlyOnceSupport.SUPPORTED : ExactlyOnceSupport.UNSUPPORTED;
    }

    public boolean alterOffsets(Map<String, String> connectorConfig, Map<Map<String, ?>, Map<String, ?>> offsets) {
        AbstractConfig config = new AbstractConfig(CONFIG_DEF, connectorConfig);
        String filename = config.getString(FILE_CONFIG);
        if (filename == null || filename.isEmpty()) {
            throw new ConnectException("Offsets cannot be modified if the 'file' configuration is unspecified. This is because stdin is used for input and offsets are not tracked.");
        }
        for (Map.Entry<Map<String, ?>, Map<String, ?>> partitionOffset : offsets.entrySet()) {
            Map<String, ?> offset = partitionOffset.getValue();
            if (offset == null) continue;
            if (!offset.containsKey("position")) {
                throw new ConnectException("Offset objects should either be null or contain the key 'position'");
            }
            if (!(offset.get("position") instanceof Long)) {
                throw new ConnectException("The value for the 'position' key in the offset is expected to be a Long value");
            }
            long offsetPosition = (Long)offset.get("position");
            if (offsetPosition < 0L) {
                throw new ConnectException("The value for the 'position' key in the offset should be a non-negative value");
            }
            Map<String, ?> partition = partitionOffset.getKey();
            if (partition == null) {
                throw new ConnectException("Partition objects cannot be null");
            }
            if (partition.containsKey("filename")) continue;
            throw new ConnectException("Partition objects should contain the key 'filename'");
        }
        return true;
    }
}

