/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.assignment;

import java.util.List;
import java.util.OptionalInt;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.streams.StreamsConfig;

public class AssignmentConfigs {
    private final long acceptableRecoveryLag;
    private final int maxWarmupReplicas;
    private final int numStandbyReplicas;
    private final long probingRebalanceIntervalMs;
    private final List<String> rackAwareAssignmentTags;
    private final OptionalInt rackAwareTrafficCost;
    private final OptionalInt rackAwareNonOverlapCost;
    private final String rackAwareAssignmentStrategy;

    public static AssignmentConfigs of(StreamsConfig configs) {
        long acceptableRecoveryLag = configs.getLong("acceptable.recovery.lag");
        int maxWarmupReplicas = configs.getInt("max.warmup.replicas");
        int numStandbyReplicas = configs.getInt("num.standby.replicas");
        long probingRebalanceIntervalMs = configs.getLong("probing.rebalance.interval.ms");
        List rackAwareAssignmentTags = configs.getList("rack.aware.assignment.tags");
        String rackAwareAssignmentStrategy = configs.getString("rack.aware.assignment.strategy");
        Integer rackAwareTrafficCost = configs.getInt("rack.aware.assignment.traffic_cost");
        Integer rackAwareNonOverlapCost = configs.getInt("rack.aware.assignment.non_overlap_cost");
        return new AssignmentConfigs(acceptableRecoveryLag, maxWarmupReplicas, numStandbyReplicas, probingRebalanceIntervalMs, (List<String>)rackAwareAssignmentTags, rackAwareTrafficCost != null ? OptionalInt.of(rackAwareTrafficCost) : OptionalInt.empty(), rackAwareNonOverlapCost != null ? OptionalInt.of(rackAwareNonOverlapCost) : OptionalInt.empty(), rackAwareAssignmentStrategy);
    }

    public AssignmentConfigs(long acceptableRecoveryLag, int maxWarmupReplicas, int numStandbyReplicas, long probingRebalanceIntervalMs, List<String> rackAwareAssignmentTags, OptionalInt rackAwareTrafficCost, OptionalInt rackAwareNonOverlapCost, String rackAwareAssignmentStrategy) {
        this.acceptableRecoveryLag = AssignmentConfigs.validated("acceptable.recovery.lag", acceptableRecoveryLag);
        this.maxWarmupReplicas = AssignmentConfigs.validated("max.warmup.replicas", maxWarmupReplicas);
        this.numStandbyReplicas = AssignmentConfigs.validated("num.standby.replicas", numStandbyReplicas);
        this.probingRebalanceIntervalMs = AssignmentConfigs.validated("probing.rebalance.interval.ms", probingRebalanceIntervalMs);
        this.rackAwareAssignmentTags = AssignmentConfigs.validated("rack.aware.assignment.tags", rackAwareAssignmentTags);
        this.rackAwareTrafficCost = AssignmentConfigs.validated("rack.aware.assignment.traffic_cost", AssignmentConfigs.defaultRackAwareTrafficCost(rackAwareTrafficCost));
        this.rackAwareNonOverlapCost = AssignmentConfigs.validated("rack.aware.assignment.non_overlap_cost", AssignmentConfigs.defaultRackAwareNonOverlapCost(rackAwareNonOverlapCost));
        this.rackAwareAssignmentStrategy = AssignmentConfigs.validated("rack.aware.assignment.strategy", rackAwareAssignmentStrategy);
    }

    public AssignmentConfigs(long acceptableRecoveryLag, int maxWarmupReplicas, int numStandbyReplicas, long probingRebalanceIntervalMs, List<String> rackAwareAssignmentTags, int rackAwareTrafficCost, int rackAwareNonOverlapCost, String rackAwareAssignmentStrategy) {
        this(acceptableRecoveryLag, maxWarmupReplicas, numStandbyReplicas, probingRebalanceIntervalMs, rackAwareAssignmentTags, OptionalInt.of(rackAwareTrafficCost), OptionalInt.of(rackAwareNonOverlapCost), rackAwareAssignmentStrategy);
    }

    public AssignmentConfigs(Long acceptableRecoveryLag, Integer maxWarmupReplicas, Integer numStandbyReplicas, Long probingRebalanceIntervalMs, List<String> rackAwareAssignmentTags) {
        this((long)acceptableRecoveryLag, (int)maxWarmupReplicas, (int)numStandbyReplicas, (long)probingRebalanceIntervalMs, rackAwareAssignmentTags, OptionalInt.empty(), OptionalInt.empty(), "none");
    }

    public long acceptableRecoveryLag() {
        return this.acceptableRecoveryLag;
    }

    public int maxWarmupReplicas() {
        return this.maxWarmupReplicas;
    }

    public int numStandbyReplicas() {
        return this.numStandbyReplicas;
    }

    public long probingRebalanceIntervalMs() {
        return this.probingRebalanceIntervalMs;
    }

    public List<String> rackAwareAssignmentTags() {
        return this.rackAwareAssignmentTags;
    }

    public OptionalInt rackAwareTrafficCost() {
        return this.rackAwareTrafficCost;
    }

    public OptionalInt rackAwareNonOverlapCost() {
        return this.rackAwareNonOverlapCost;
    }

    public String rackAwareAssignmentStrategy() {
        return this.rackAwareAssignmentStrategy;
    }

    private static <T> T validated(String configKey, T value) {
        ConfigDef.Validator validator = ((ConfigDef.ConfigKey)StreamsConfig.configDef().configKeys().get((Object)configKey)).validator;
        if (validator != null) {
            validator.ensureValid(configKey, value);
        }
        return value;
    }

    public String toString() {
        return "AssignmentConfigs{\n  acceptableRecoveryLag=" + this.acceptableRecoveryLag + "\n  maxWarmupReplicas=" + this.maxWarmupReplicas + "\n  numStandbyReplicas=" + this.numStandbyReplicas + "\n  probingRebalanceIntervalMs=" + this.probingRebalanceIntervalMs + "\n  rackAwareAssignmentTags=" + this.rackAwareAssignmentTags + "\n  rackAwareTrafficCost=" + this.rackAwareTrafficCost + "\n  rackAwareNonOverlapCost=" + this.rackAwareNonOverlapCost + "\n  rackAwareAssignmentStrategy=" + this.rackAwareAssignmentStrategy + "\n}";
    }

    private static OptionalInt defaultRackAwareTrafficCost(OptionalInt rackAwareTrafficCost) {
        if (rackAwareTrafficCost == null) {
            return OptionalInt.empty();
        }
        return rackAwareTrafficCost;
    }

    private static OptionalInt defaultRackAwareNonOverlapCost(OptionalInt rackAwareNonOverlapCost) {
        if (rackAwareNonOverlapCost == null) {
            return OptionalInt.empty();
        }
        return rackAwareNonOverlapCost;
    }
}

