/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.streams.kstream.NamedOperation;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.suppress.EagerBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.FinalResultsSuppressionBuilder;
import org.apache.kafka.streams.kstream.internals.suppress.StrictBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;

public interface Suppressed<K>
extends NamedOperation<Suppressed<K>> {
    public static Suppressed<Windowed> untilWindowCloses(StrictBufferConfig bufferConfig) {
        return new FinalResultsSuppressionBuilder<Windowed>(null, bufferConfig);
    }

    public static <K> Suppressed<K> untilTimeLimit(Duration timeToWaitForMoreEvents, BufferConfig bufferConfig) {
        return new SuppressedInternal(null, timeToWaitForMoreEvents, bufferConfig, null, false);
    }

    @Override
    public Suppressed<K> withName(String var1);

    public static interface StrictBufferConfig
    extends BufferConfig<StrictBufferConfig> {
    }

    public static interface BufferConfig<BC extends BufferConfig<BC>> {
        public static EagerBufferConfig maxRecords(long recordLimit) {
            return new EagerBufferConfigImpl(recordLimit, Long.MAX_VALUE, Collections.emptyMap());
        }

        public BC withMaxRecords(long var1);

        public static EagerBufferConfig maxBytes(long byteLimit) {
            return new EagerBufferConfigImpl(Long.MAX_VALUE, byteLimit, Collections.emptyMap());
        }

        public BC withMaxBytes(long var1);

        public static StrictBufferConfig unbounded() {
            return new StrictBufferConfigImpl();
        }

        public StrictBufferConfig withNoBound();

        public StrictBufferConfig shutDownWhenFull();

        public EagerBufferConfig emitEarlyWhenFull();

        public BC withLoggingDisabled();

        public BC withLoggingEnabled(Map<String, String> var1);
    }

    public static interface EagerBufferConfig
    extends BufferConfig<EagerBufferConfig> {
    }
}

