/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class InitializeShareGroupStateRequestData
implements ApiMessage {
    String groupId;
    List<InitializeStateData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("topics", new CompactArrayOf(InitializeStateData.SCHEMA_0), "The data for the topics."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public InitializeShareGroupStateRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public InitializeShareGroupStateRequestData() {
        this.groupId = "";
        this.topics = new ArrayList<InitializeStateData>(0);
    }

    @Override
    public short apiKey() {
        return 83;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<InitializeStateData> newCollection = new ArrayList<InitializeStateData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new InitializeStateData(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            InitializeStateData topicsElement = (InitializeStateData)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (InitializeStateData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitializeShareGroupStateRequestData)) {
            return false;
        }
        InitializeShareGroupStateRequestData other = (InitializeShareGroupStateRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public InitializeShareGroupStateRequestData duplicate() {
        InitializeShareGroupStateRequestData _duplicate = new InitializeShareGroupStateRequestData();
        _duplicate.groupId = this.groupId;
        ArrayList<InitializeStateData> newTopics = new ArrayList<InitializeStateData>(this.topics.size());
        for (InitializeStateData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "InitializeShareGroupStateRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public List<InitializeStateData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public InitializeShareGroupStateRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public InitializeShareGroupStateRequestData setTopics(List<InitializeStateData> v) {
        this.topics = v;
        return this;
    }

    public static class InitializeStateData
    implements Message {
        Uuid topicId;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The topic identifier."), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), "The data for the partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public InitializeStateData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public InitializeStateData() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of InitializeStateData");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of InitializeStateData");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InitializeStateData)) {
                return false;
            }
            InitializeStateData other = (InitializeStateData)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public InitializeStateData duplicate() {
            InitializeStateData _duplicate = new InitializeStateData();
            _duplicate.topicId = this.topicId;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "InitializeStateData(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public InitializeStateData setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public InitializeStateData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class PartitionData
    implements Message {
        int partition;
        int stateEpoch;
        long startOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("state_epoch", Type.INT32, "The state epoch for this share-partition."), new Field("start_offset", Type.INT64, "The share-partition start offset, or -1 if the start offset is not being initialized."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionData() {
            this.partition = 0;
            this.stateEpoch = 0;
            this.startOffset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partition = _readable.readInt();
            this.stateEpoch = _readable.readInt();
            this.startOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            _writable.writeInt(this.stateEpoch);
            _writable.writeLong(this.startOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.stateEpoch != other.stateEpoch) {
                return false;
            }
            if (this.startOffset != other.startOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + this.stateEpoch;
            hashCode = 31 * hashCode + ((int)(this.startOffset >> 32) ^ (int)this.startOffset);
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partition = this.partition;
            _duplicate.stateEpoch = this.stateEpoch;
            _duplicate.startOffset = this.startOffset;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partition=" + this.partition + ", stateEpoch=" + this.stateEpoch + ", startOffset=" + this.startOffset + ")";
        }

        public int partition() {
            return this.partition;
        }

        public int stateEpoch() {
            return this.stateEpoch;
        }

        public long startOffset() {
            return this.startOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartition(int v) {
            this.partition = v;
            return this;
        }

        public PartitionData setStateEpoch(int v) {
            this.stateEpoch = v;
            return this;
        }

        public PartitionData setStartOffset(long v) {
            this.startOffset = v;
            return this;
        }
    }
}

