/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AddPartitionsToTxnRequestData
implements ApiMessage {
    AddPartitionsToTxnTransactionCollection transactions;
    String v3AndBelowTransactionalId;
    long v3AndBelowProducerId;
    short v3AndBelowProducerEpoch;
    AddPartitionsToTxnTopicCollection v3AndBelowTopics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public AddPartitionsToTxnRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddPartitionsToTxnRequestData() {
        this.transactions = new AddPartitionsToTxnTransactionCollection(0);
        this.v3AndBelowTransactionalId = "";
        this.v3AndBelowProducerId = 0L;
        this.v3AndBelowProducerEpoch = 0;
        this.v3AndBelowTopics = new AddPartitionsToTxnTopicCollection(0);
    }

    @Override
    public short apiKey() {
        return 24;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        ImplicitLinkedHashMultiCollection newCollection;
        int arrayLength;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field transactions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new AddPartitionsToTxnTransactionCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTransaction(_readable, _version));
            }
            this.transactions = newCollection;
        } else {
            this.transactions = new AddPartitionsToTxnTransactionCollection(0);
        }
        if (_version <= 3) {
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field v3AndBelowTransactionalId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field v3AndBelowTransactionalId had invalid length " + length);
            }
            this.v3AndBelowTransactionalId = _readable.readString(length);
        } else {
            this.v3AndBelowTransactionalId = "";
        }
        this.v3AndBelowProducerId = _version <= 3 ? _readable.readLong() : 0L;
        this.v3AndBelowProducerEpoch = _version <= 3 ? _readable.readShort() : (short)0;
        if (_version <= 3) {
            if (_version >= 3) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field v3AndBelowTopics was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AddPartitionsToTxnTopicCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnTopic(_readable, _version));
                }
                this.v3AndBelowTopics = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field v3AndBelowTopics was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AddPartitionsToTxnTopicCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AddPartitionsToTxnTopic(_readable, _version));
                }
                this.v3AndBelowTopics = newCollection;
            }
        } else {
            this.v3AndBelowTopics = new AddPartitionsToTxnTopicCollection(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.transactions.size() + 1);
            for (AddPartitionsToTxnTransaction transactionsElement : this.transactions) {
                transactionsElement.write(_writable, _cache, _version);
            }
        } else if (!this.transactions.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default transactions at version " + _version);
        }
        if (_version <= 3) {
            _stringBytes = _cache.getSerializedValue(this.v3AndBelowTransactionalId);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        } else if (!this.v3AndBelowTransactionalId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default v3AndBelowTransactionalId at version " + _version);
        }
        if (_version <= 3) {
            _writable.writeLong(this.v3AndBelowProducerId);
        } else if (this.v3AndBelowProducerId != 0L) {
            throw new UnsupportedVersionException("Attempted to write a non-default v3AndBelowProducerId at version " + _version);
        }
        if (_version <= 3) {
            _writable.writeShort(this.v3AndBelowProducerEpoch);
        } else if (this.v3AndBelowProducerEpoch != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default v3AndBelowProducerEpoch at version " + _version);
        }
        if (_version <= 3) {
            AddPartitionsToTxnTopic v3AndBelowTopicsElement;
            if (_version >= 3) {
                _writable.writeUnsignedVarint(this.v3AndBelowTopics.size() + 1);
                _stringBytes = this.v3AndBelowTopics.iterator();
                while (_stringBytes.hasNext()) {
                    v3AndBelowTopicsElement = (AddPartitionsToTxnTopic)_stringBytes.next();
                    v3AndBelowTopicsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.v3AndBelowTopics.size());
                _stringBytes = this.v3AndBelowTopics.iterator();
                while (_stringBytes.hasNext()) {
                    v3AndBelowTopicsElement = (AddPartitionsToTxnTopic)_stringBytes.next();
                    v3AndBelowTopicsElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.v3AndBelowTopics.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default v3AndBelowTopics at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.transactions.size() + 1));
            for (AddPartitionsToTxnTransaction transactionsElement : this.transactions) {
                transactionsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version <= 3) {
            byte[] _stringBytes = this.v3AndBelowTransactionalId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'v3AndBelowTransactionalId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.v3AndBelowTransactionalId, _stringBytes);
            if (_version >= 3) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version <= 3) {
            _size.addBytes(8);
        }
        if (_version <= 3) {
            _size.addBytes(2);
        }
        if (_version <= 3) {
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.v3AndBelowTopics.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (AddPartitionsToTxnTopic v3AndBelowTopicsElement : this.v3AndBelowTopics) {
                v3AndBelowTopicsElement.addSize(_size, _cache, _version);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnRequestData)) {
            return false;
        }
        AddPartitionsToTxnRequestData other = (AddPartitionsToTxnRequestData)obj;
        if (this.transactions == null ? other.transactions != null : !this.transactions.equals(other.transactions)) {
            return false;
        }
        if (this.v3AndBelowTransactionalId == null ? other.v3AndBelowTransactionalId != null : !this.v3AndBelowTransactionalId.equals(other.v3AndBelowTransactionalId)) {
            return false;
        }
        if (this.v3AndBelowProducerId != other.v3AndBelowProducerId) {
            return false;
        }
        if (this.v3AndBelowProducerEpoch != other.v3AndBelowProducerEpoch) {
            return false;
        }
        if (this.v3AndBelowTopics == null ? other.v3AndBelowTopics != null : !this.v3AndBelowTopics.equals(other.v3AndBelowTopics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactions == null ? 0 : this.transactions.hashCode());
        hashCode = 31 * hashCode + (this.v3AndBelowTransactionalId == null ? 0 : this.v3AndBelowTransactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.v3AndBelowProducerId >> 32) ^ (int)this.v3AndBelowProducerId);
        hashCode = 31 * hashCode + this.v3AndBelowProducerEpoch;
        hashCode = 31 * hashCode + (this.v3AndBelowTopics == null ? 0 : this.v3AndBelowTopics.hashCode());
        return hashCode;
    }

    @Override
    public AddPartitionsToTxnRequestData duplicate() {
        AddPartitionsToTxnRequestData _duplicate = new AddPartitionsToTxnRequestData();
        AddPartitionsToTxnTransactionCollection newTransactions = new AddPartitionsToTxnTransactionCollection(this.transactions.size());
        for (AddPartitionsToTxnTransaction _element : this.transactions) {
            newTransactions.add(_element.duplicate());
        }
        _duplicate.transactions = newTransactions;
        _duplicate.v3AndBelowTransactionalId = this.v3AndBelowTransactionalId;
        _duplicate.v3AndBelowProducerId = this.v3AndBelowProducerId;
        _duplicate.v3AndBelowProducerEpoch = this.v3AndBelowProducerEpoch;
        AddPartitionsToTxnTopicCollection newV3AndBelowTopics = new AddPartitionsToTxnTopicCollection(this.v3AndBelowTopics.size());
        for (AddPartitionsToTxnTopic _element : this.v3AndBelowTopics) {
            newV3AndBelowTopics.add(_element.duplicate());
        }
        _duplicate.v3AndBelowTopics = newV3AndBelowTopics;
        return _duplicate;
    }

    public String toString() {
        return "AddPartitionsToTxnRequestData(transactions=" + MessageUtil.deepToString(this.transactions.iterator()) + ", v3AndBelowTransactionalId=" + (this.v3AndBelowTransactionalId == null ? "null" : "'" + this.v3AndBelowTransactionalId.toString() + "'") + ", v3AndBelowProducerId=" + this.v3AndBelowProducerId + ", v3AndBelowProducerEpoch=" + this.v3AndBelowProducerEpoch + ", v3AndBelowTopics=" + MessageUtil.deepToString(this.v3AndBelowTopics.iterator()) + ")";
    }

    public AddPartitionsToTxnTransactionCollection transactions() {
        return this.transactions;
    }

    public String v3AndBelowTransactionalId() {
        return this.v3AndBelowTransactionalId;
    }

    public long v3AndBelowProducerId() {
        return this.v3AndBelowProducerId;
    }

    public short v3AndBelowProducerEpoch() {
        return this.v3AndBelowProducerEpoch;
    }

    public AddPartitionsToTxnTopicCollection v3AndBelowTopics() {
        return this.v3AndBelowTopics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddPartitionsToTxnRequestData setTransactions(AddPartitionsToTxnTransactionCollection v) {
        this.transactions = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setV3AndBelowTransactionalId(String v) {
        this.v3AndBelowTransactionalId = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setV3AndBelowProducerId(long v) {
        this.v3AndBelowProducerId = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setV3AndBelowProducerEpoch(short v) {
        this.v3AndBelowProducerEpoch = v;
        return this;
    }

    public AddPartitionsToTxnRequestData setV3AndBelowTopics(AddPartitionsToTxnTopicCollection v) {
        this.v3AndBelowTopics = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("v3_and_below_transactional_id", Type.STRING, "The transactional id corresponding to the transaction."), new Field("v3_and_below_producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("v3_and_below_producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("v3_and_below_topics", new ArrayOf(AddPartitionsToTxnTopic.SCHEMA_0), "The partitions to add to the transaction.")));
        SCHEMA_3 = new Schema(new Field("v3_and_below_transactional_id", Type.COMPACT_STRING, "The transactional id corresponding to the transaction."), new Field("v3_and_below_producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("v3_and_below_producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("v3_and_below_topics", new CompactArrayOf(AddPartitionsToTxnTopic.SCHEMA_3), "The partitions to add to the transaction."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("transactions", new CompactArrayOf(AddPartitionsToTxnTransaction.SCHEMA_4), "List of transactions to add partitions to."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class AddPartitionsToTxnTransactionCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnTransaction> {
        public AddPartitionsToTxnTransactionCollection() {
        }

        public AddPartitionsToTxnTransactionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTransactionCollection(Iterator<AddPartitionsToTxnTransaction> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnTransaction find(String transactionalId) {
            AddPartitionsToTxnTransaction _key = new AddPartitionsToTxnTransaction();
            _key.setTransactionalId(transactionalId);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnTransaction> findAll(String transactionalId) {
            AddPartitionsToTxnTransaction _key = new AddPartitionsToTxnTransaction();
            _key.setTransactionalId(transactionalId);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnTransactionCollection duplicate() {
            AddPartitionsToTxnTransactionCollection _duplicate = new AddPartitionsToTxnTransactionCollection(this.size());
            for (AddPartitionsToTxnTransaction _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnTopicCollection
    extends ImplicitLinkedHashMultiCollection<AddPartitionsToTxnTopic> {
        public AddPartitionsToTxnTopicCollection() {
        }

        public AddPartitionsToTxnTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicCollection(Iterator<AddPartitionsToTxnTopic> iterator) {
            super(iterator);
        }

        @Override
        public AddPartitionsToTxnTopic find(String name) {
            AddPartitionsToTxnTopic _key = new AddPartitionsToTxnTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<AddPartitionsToTxnTopic> findAll(String name) {
            AddPartitionsToTxnTopic _key = new AddPartitionsToTxnTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public AddPartitionsToTxnTopicCollection duplicate() {
            AddPartitionsToTxnTopicCollection _duplicate = new AddPartitionsToTxnTopicCollection(this.size());
            for (AddPartitionsToTxnTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AddPartitionsToTxnTransaction
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String transactionalId;
        long producerId;
        short producerEpoch;
        boolean verifyOnly;
        AddPartitionsToTxnTopicCollection topics;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 4;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public AddPartitionsToTxnTransaction(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnTransaction() {
            this.transactionalId = "";
            this.producerId = 0L;
            this.producerEpoch = 0;
            this.verifyOnly = false;
            this.topics = new AddPartitionsToTxnTopicCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AddPartitionsToTxnTransaction");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionalId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionalId had invalid length " + length);
            }
            this.transactionalId = _readable.readString(length);
            this.producerId = _readable.readLong();
            this.producerEpoch = _readable.readShort();
            this.verifyOnly = _readable.readByte() != 0;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            AddPartitionsToTxnTopicCollection newCollection = new AddPartitionsToTxnTopicCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AddPartitionsToTxnTopic(_readable, _version));
            }
            this.topics = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AddPartitionsToTxnTransaction");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.transactionalId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeLong(this.producerId);
            _writable.writeShort(this.producerEpoch);
            _writable.writeByte(this.verifyOnly ? (byte)1 : 0);
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                AddPartitionsToTxnTopic topicsElement = (AddPartitionsToTxnTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AddPartitionsToTxnTransaction");
            }
            byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionalId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(8);
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (AddPartitionsToTxnTopic topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTransaction)) {
                return false;
            }
            AddPartitionsToTxnTransaction other = (AddPartitionsToTxnTransaction)obj;
            return !(this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTransaction)) {
                return false;
            }
            AddPartitionsToTxnTransaction other = (AddPartitionsToTxnTransaction)obj;
            if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
                return false;
            }
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.producerEpoch != other.producerEpoch) {
                return false;
            }
            if (this.verifyOnly != other.verifyOnly) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnTransaction duplicate() {
            AddPartitionsToTxnTransaction _duplicate = new AddPartitionsToTxnTransaction();
            _duplicate.transactionalId = this.transactionalId;
            _duplicate.producerId = this.producerId;
            _duplicate.producerEpoch = this.producerEpoch;
            _duplicate.verifyOnly = this.verifyOnly;
            AddPartitionsToTxnTopicCollection newTopics = new AddPartitionsToTxnTopicCollection(this.topics.size());
            for (AddPartitionsToTxnTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnTransaction(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", verifyOnly=" + (this.verifyOnly ? "true" : "false") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public String transactionalId() {
            return this.transactionalId;
        }

        public long producerId() {
            return this.producerId;
        }

        public short producerEpoch() {
            return this.producerEpoch;
        }

        public boolean verifyOnly() {
            return this.verifyOnly;
        }

        public AddPartitionsToTxnTopicCollection topics() {
            return this.topics;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnTransaction setTransactionalId(String v) {
            this.transactionalId = v;
            return this;
        }

        public AddPartitionsToTxnTransaction setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public AddPartitionsToTxnTransaction setProducerEpoch(short v) {
            this.producerEpoch = v;
            return this;
        }

        public AddPartitionsToTxnTransaction setVerifyOnly(boolean v) {
            this.verifyOnly = v;
            return this;
        }

        public AddPartitionsToTxnTransaction setTopics(AddPartitionsToTxnTopicCollection v) {
            this.topics = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("transactional_id", Type.COMPACT_STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("verify_only", Type.BOOLEAN, "Boolean to signify if we want to check if the partition is in the transaction rather than add it."), new Field("topics", new CompactArrayOf(AddPartitionsToTxnTopic.SCHEMA_3), "The partitions to add to the transaction."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class AddPartitionsToTxnTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public AddPartitionsToTxnTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public AddPartitionsToTxnTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 3) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
            } else {
                _writable.writeInt(this.partitions.size());
            }
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 3) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopic)) {
                return false;
            }
            AddPartitionsToTxnTopic other = (AddPartitionsToTxnTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopic)) {
                return false;
            }
            AddPartitionsToTxnTopic other = (AddPartitionsToTxnTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public AddPartitionsToTxnTopic duplicate() {
            AddPartitionsToTxnTopic _duplicate = new AddPartitionsToTxnTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "AddPartitionsToTxnTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AddPartitionsToTxnTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The name of the topic."), new Field("partitions", new ArrayOf(Type.INT32), "The partition indexes to add to the transaction")));
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the topic."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partition indexes to add to the transaction"), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

