/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zk.migration.ZkConfigMigrationClient$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u000b\u0017\u0001uA\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)A\t\u0001C\u0001\u000b\"9!\n\u0001b\u0001\n\u0003Y\u0005BB(\u0001A\u0003%A\nC\u0003Q\u0001\u0011%\u0011\u000bC\u0003b\u0001\u0011%!\rC\u0003e\u0001\u0011%Q\rC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!(\u0001\t\u0013\tyjB\u0004\u0002DZA\t!!2\u0007\rU1\u0002\u0012AAd\u0011\u0019!%\u0003\"\u0001\u0002P\"9\u0011\u0011\u001b\n\u0005\u0002\u0005M'a\u0006.l\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0015\t9\u0002$A\u0005nS\u001e\u0014\u0018\r^5p]*\u0011\u0011DG\u0001\u0003u.T\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001aD\n\u001a\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001\u00027b]\u001eT\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\t1qJ\u00196fGR\u0004\"a\n\u0019\u000e\u0003!R!aF\u0015\u000b\u0005)Z\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005ma#BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001eL!!\r\u0015\u0003+\r{gNZ5h\u001b&<'/\u0019;j_:\u001cE.[3oiB\u00111GN\u0007\u0002i)\u0011QGG\u0001\u0006kRLGn]\u0005\u0003oQ\u0012q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\tQ4(D\u0001\u0019\u0013\ta\u0004DA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0010a\u0006\u001c8o^8sI\u0016s7m\u001c3feB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iK\u0001\tg\u0016\u001cWO]5us&\u00111\t\u0011\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u00061A(\u001b8jiz\"2A\u0012%J!\t9\u0005!D\u0001\u0017\u0011\u0015A4\u00011\u0001:\u0011\u0015i4\u00011\u0001?\u00035\tG-\\5o5.\u001cE.[3oiV\tA\n\u0005\u0002;\u001b&\u0011a\n\u0007\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\u001d\u0005$W.\u001b8[W\u000ec\u0017.\u001a8uA\u00059bM]8n5.\u001cuN\u001c4jO\u001a,e\u000e^5us:\u000bW.\u001a\u000b\u0003%~\u0003\"a\u0015/\u000f\u0005QS\u0006CA+Y\u001b\u00051&BA,\u001d\u0003\u0019a$o\\8u})\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\u00061\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tY\u0006\fC\u0003a\r\u0001\u0007!+\u0001\u0006f]RLG/\u001f(b[\u0016\fA\u0003^8[W\u000e{gNZ5h\u000b:$\u0018\u000e^=OC6,GC\u0001*d\u0011\u0015\u0001w\u00011\u0001S\u0003i\u0011W/\u001b7e\u00072LWM\u001c;Rk>$\u0018-\u00128uSRLH)\u0019;b)\r1'\u0010 \t\u0003O^t!\u0001\u001b;\u000f\u0005%\u0014hB\u00016q\u001d\tYwN\u0004\u0002m]:\u0011Q+\\\u0005\u0002_%\u0011QFL\u0005\u000371J!!]\u0016\u0002\r\r|W.\\8o\u0013\tQ3O\u0003\u0002rW%\u0011QO^\u0001\u0012\u00072LWM\u001c;Rk>$\u0018MU3d_J$'B\u0001\u0016t\u0013\tA\u0018P\u0001\u0006F]RLG/\u001f#bi\u0006T!!\u001e<\t\u000bmD\u0001\u0019\u0001*\u0002\u0015\u0015tG/\u001b;z)f\u0004X\rC\u0003~\u0011\u0001\u0007!+A\u0005{]>$WMT1nK\u0006\u0019\u0012\u000e^3sCR,7\t\\5f]R\fVo\u001c;bgR!\u0011\u0011AA\u0005!\u0011\t\u0019!!\u0002\u000e\u0003aK1!a\u0002Y\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0011\u00021\u0001\u0002\u000e\u00059a/[:ji>\u0014\b\u0003BA\b\u0003;qA!!\u0005\u0002\u001a9!\u00111CA\f\u001d\rQ\u0017QC\u0005\u0003U-J!aF\u0015\n\u0007\u0005m\u0001&A\u000bD_:4\u0017nZ'jOJ\fG/[8o\u00072LWM\u001c;\n\t\u0005}\u0011\u0011\u0005\u0002\u0013\u00072LWM\u001c;Rk>$\u0018MV5tSR|'OC\u0002\u0002\u001c!\nA#\u001b;fe\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cH\u0003BA\u0001\u0003OAq!!\u000b\u000b\u0001\u0004\tY#\u0001\bd_:4\u0017nZ\"p]N,X.\u001a:\u0011\u000f\u00055\u0012q\u0007*\u0002<5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$\u0001\u0005gk:\u001cG/[8o\u0015\r\t)DI\u0001\u0005kRLG.\u0003\u0003\u0002:\u0005=\"A\u0003\"j\u0007>t7/^7feB1\u0011QHA %Jk!!a\r\n\t\u0005\u0005\u00131\u0007\u0002\u0004\u001b\u0006\u0004\u0018aE5uKJ\fG/\u001a+pa&\u001c7i\u001c8gS\u001e\u001cH\u0003BA\u0001\u0003\u000fBq!!\u000b\f\u0001\u0004\tY#\u0001\tsK\u0006$Gk\u001c9jG\u000e{gNZ5hgR1\u0011\u0011AA'\u0003#Ba!a\u0014\r\u0001\u0004\u0011\u0016!\u0003;pa&\u001cg*Y7f\u0011\u001d\tI\u0003\u0004a\u0001\u0003'\u0002b!!\f\u0002V\u0005m\u0012\u0002BA,\u0003_\u0011\u0001bQ8ogVlWM]\u0001\roJLG/Z\"p]\u001aLwm\u001d\u000b\t\u0003;\n\u0019'a\u001d\u0002xA\u0019q%a\u0018\n\u0007\u0005\u0005\u0004F\u0001\u000e[W6KwM]1uS>tG*Z1eKJ\u001c\b.\u001b9Ti\u0006$X\rC\u0004\u0002f5\u0001\r!a\u001a\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKB!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002nM\faaY8oM&<\u0017\u0002BA9\u0003W\u0012abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0002v5\u0001\r!a\u000f\u0002\u0013\r|gNZ5h\u001b\u0006\u0004\bbBA=\u001b\u0001\u0007\u0011QL\u0001\u0006gR\fG/Z\u0001\u000eI\u0016dW\r^3D_:4\u0017nZ:\u0015\r\u0005u\u0013qPAA\u0011\u001d\t)G\u0004a\u0001\u0003OBq!!\u001f\u000f\u0001\u0004\ti&A\txe&$Xm\u00117jK:$\u0018+^8uCN$\"\"!\u0018\u0002\b\u0006-\u0015qSAN\u0011\u001d\tIi\u0004a\u0001\u0003w\ta!\u001a8uSRL\bbBAG\u001f\u0001\u0007\u0011qR\u0001\u0007cV|G/Y:\u0011\u000f\u0005u\u0012q\b*\u0002\u0012B\u0019q$a%\n\u0007\u0005U\u0005E\u0001\u0004E_V\u0014G.\u001a\u0005\b\u00033{\u0001\u0019AA\u001e\u0003\u0015\u00198M]1n\u0011\u001d\tIh\u0004a\u0001\u0003;\nA\u0003\u001e:z/JLG/Z#oi&$\u0018pQ8oM&<G\u0003DAQ\u0003O\u000bI+!,\u00028\u0006\u0005\u0007CBA\u0002\u0003G\u000bi&C\u0002\u0002&b\u0013aa\u00149uS>t\u0007\"B>\u0011\u0001\u0004\u0011\u0006BBAV!\u0001\u0007!+\u0001\u0003qCRD\u0007bBAX!\u0001\u0007\u0011\u0011W\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003{\t\u0019,\u0003\u0003\u00026\u0006M\"A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\u0018\tA\u0002\u0005m\u0016AB2sK\u0006$X\r\u0005\u0003\u0002\u0004\u0005u\u0016bAA`1\n9!i\\8mK\u0006t\u0007bBA=!\u0001\u0007\u0011QL\u0001\u00185.\u001cuN\u001c4jO6KwM]1uS>t7\t\\5f]R\u0004\"a\u0012\n\u0014\u0007I\tI\r\u0005\u0003\u0002\u0004\u0005-\u0017bAAg1\n1\u0011I\\=SK\u001a$\"!!2\u0002A\u001d,GoU1oSRL'0\u001a3DY&,g\u000e^)v_R\f'LT8eK:\u000bW.\u001a\u000b\u0007\u0003+\f9.!7\u0011\u000b\u0005\r\u00111\u0015*\t\u000f\u0005%E\u00031\u0001\u0002<!1\u00111\u001c\u000bA\u0002I\u000b\u0011bY8na>tWM\u001c;")
public class ZkConfigMigrationClient
implements ConfigMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final PasswordEncoder passwordEncoder;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> getSanitizedClientQuotaZNodeName(java.util.Map<String, String> entity, String component) {
        return ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity, component);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String fromZkConfigfEntityName(String entityName) {
        if (entityName.equals("<default>")) {
            return "";
        }
        return entityName;
    }

    private String toZkConfigEntityName(String entityName) {
        if (entityName.isEmpty()) {
            return "<default>";
        }
        return entityName;
    }

    private ClientQuotaRecord.EntityData buildClientQuotaEntityData(String entityType, String znodeName) {
        ClientQuotaRecord.EntityData result = new ClientQuotaRecord.EntityData().setEntityType(entityType);
        if (znodeName.equals("<default>")) {
            result.setEntityName(null);
        } else {
            result.setEntityName(Sanitizer.desanitize((String)znodeName));
        }
        return result;
    }

    public void iterateClientQuotas(ConfigMigrationClient.ClientQuotaVisitor visitor) {
        this.migrateEntityType$1("users", "user", visitor);
        this.migrateEntityType$1("clients", "client-id", visitor);
        this.adminZkClient().fetchAllChildEntityConfigs("users", "clients").foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$7(this, visitor, x0$1);
            return BoxedUnit.UNIT;
        });
        this.migrateEntityType$1("ips", "ip", visitor);
    }

    public void iterateBrokerConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig("brokers");
        this.zkClient.getEntitiesConfigs("brokers", (Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateBrokerConfigs$1(this, configConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void iterateTopicConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        this.zkClient.getAllEntitiesWithConfig("topics").foreach((Function1 & Serializable)topic -> {
            this.readTopicConfigs(topic, props -> configConsumer.accept(topic, props));
            return BoxedUnit.UNIT;
        });
    }

    public void readTopicConfigs(String topicName, Consumer<java.util.Map<String, String>> configConsumer) {
        String topicResource = this.fromZkConfigfEntityName(topicName);
        Properties props = this.zkClient.getEntityConfigs("topics", topicResource);
        java.util.Map decodedProps = CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        String logAndRethrow_msg = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(topicResource).append(".").toString();
        try {
            configConsumer.accept(decodedProps);
        }
        catch (Throwable logAndRethrow_e) {
            this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource configResource, java.util.Map<String, String> configMap, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$writeConfigs$1(this, configResource, configMap, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteConfigs(ConfigResource configResource, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$deleteConfigs$1(this, configResource, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, java.util.Map<String, String> scram, ZkMigrationLeadershipState state) {
        Object object = new Object();
        try {
            ZkMigrationLeadershipState zkMigrationLeadershipState;
            try {
                zkMigrationLeadershipState = ZkConfigMigrationClient.$anonfun$writeClientQuotas$1(this, entity, object, state, quotas, scram);
            }
            catch (Throwable throwable) {
                if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                    throw throwable;
                }
                if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                    throw new MigrationClientAuthException(throwable);
                }
                if (throwable instanceof KeeperException) {
                    KeeperException keeperException = (KeeperException)throwable;
                    throw new MigrationClientException((Throwable)keeperException);
                }
                throw throwable;
            }
            return zkMigrationLeadershipState;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ZkMigrationLeadershipState)ex.value();
            }
            throw ex;
        }
    }

    private Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$tryWriteEntityConfig$1(this, props, create, entityType, path, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$iterateClientQuotas$2(ScramMechanism x$1) {
        ScramMechanism scramMechanism = x$1;
        ScramMechanism scramMechanism2 = ScramMechanism.UNKNOWN;
        return scramMechanism == null ? scramMechanism2 != null : !scramMechanism.equals(scramMechanism2);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$6(ConfigMigrationClient.ClientQuotaVisitor visitor$1, java.util.List entity$1, java.util.Map quotaMap$1) {
        visitor$1.visitClientQuota(entity$1, quotaMap$1);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$1(ZkConfigMigrationClient $this, String entityType$1, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String znodeName = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            java.util.List entity = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)$this.buildClientQuotaEntityData(entityType$1, znodeName), (List)Nil$.MODULE$)).asJava();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkConfigMigrationClient.$anonfun$iterateClientQuotas$2(x$1)))), (Function1 & Serializable)mechanism -> {
                String propertyValue = props.getProperty(mechanism.mechanismName());
                if (propertyValue != null) {
                    ScramCredential scramCredentials = ScramCredentialUtils.credentialFromString((String)propertyValue);
                    String logAndRethrow_msg = new StringBuilder(62).append("Error in client quota visitor for SCRAM credential. User was ").append(entity).append(".").toString();
                    try {
                        visitor$1.visitScramCredential(Sanitizer.desanitize((String)znodeName), mechanism, scramCredentials);
                    }
                    catch (Throwable logAndRethrow_e) {
                        $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                        throw logAndRethrow_e;
                    }
                    Object var8_8 = null;
                    return props.remove(mechanism.mechanismName());
                }
                return BoxedUnit.UNIT;
            });
            java.util.Map quotaMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala()).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    double value = x0$2._2$mcD$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            if (!quotaMap.isEmpty()) {
                String logAndRethrow_msg = new StringBuilder(43).append("Error in client quota visitor. Entity was ").append(entity).append(".").toString();
                try {
                    visitor$1.visitClientQuota(entity, quotaMap);
                }
                catch (Throwable logAndRethrow_e) {
                    $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                    throw logAndRethrow_e;
                }
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void migrateEntityType$1(String zkEntityType, String entityType, ConfigMigrationClient.ClientQuotaVisitor visitor$1) {
        this.adminZkClient().fetchAllEntityConfigs(zkEntityType).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$1(this, entityType, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$7(ZkConfigMigrationClient $this, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        block4: {
            Object[] components;
            Properties props;
            block6: {
                String znodePath;
                block5: {
                    if (x0$1 == null) break block4;
                    znodePath = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = znodePath.split("/");
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(components)) != 3) break block5;
                    Object object = components[1];
                    String string = "clients";
                    if (object != null && object.equals(string)) break block6;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(znodePath).toString());
            }
            .colon.colon entity = new .colon.colon((Object)$this.buildClientQuotaEntityData("user", (String)components[0]), (List)new .colon.colon((Object)$this.buildClientQuotaEntityData("client-id", (String)components[2]), (List)Nil$.MODULE$));
            java.util.Map quotaMap = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Double d;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    try {
                        d = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                    }
                    Double doubleValue = d;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)doubleValue);
                }
                throw new MatchError(null);
            })).asJava();
            String logAndRethrow_msg = new StringBuilder(50).append("Error in client quota entity visitor. Entity was ").append(entity).append(".").toString();
            try {
                visitor$1.visitClientQuota(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)entity)).asJava(), quotaMap);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$3(BiConsumer configConsumer$1, String brokerResource$1, java.util.Map decodedProps$1) {
        configConsumer$1.accept(brokerResource$1, decodedProps$1);
    }

    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$1(ZkConfigMigrationClient $this, BiConsumer configConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String brokerResource = $this.fromZkConfigfEntityName(broker);
            java.util.Map decodedProps = CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String logAndRethrow_msg = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append(brokerResource).append(".").toString();
            try {
                configConsumer$1.accept(brokerResource, decodedProps);
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$readTopicConfigs$2(Consumer configConsumer$3, java.util.Map decodedProps$2) {
        configConsumer$3.accept(decodedProps$2);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$1, java.util.Map configMap$1, ZkMigrationLeadershipState state$1) {
        ConfigResource.Type type = configResource$1.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)"brokers") : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)"topics") : None$.MODULE$);
        String configName = $this.toZkConfigEntityName(configResource$1.name());
        if (configType.isDefined()) {
            Properties props = new Properties();
            configMap$1.forEach((x0$1, x1$1) -> {
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig((String)x0$1)) {
                    props.put(x0$1, $this.passwordEncoder.encode(new Password(x1$1)));
                    return;
                }
                props.put(x0$1, x1$1);
            });
            Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType.get(), configName, props, false, state$1);
            if (option instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)configType.get());
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(configResource$1).append(" configs a second time.").toString());
                byte[] x$3 = $this.zkClient.createRecursive$default$2();
                $this.zkClient.createRecursive(createPath, x$3, false);
                Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType.get(), configName, props, true, state$1);
                if (option2 instanceof Some) {
                    return (ZkMigrationLeadershipState)((Some)option2).value();
                }
                if (None$.MODULE$.equals(option2)) {
                    throw new MigrationClientException(new StringBuilder(80).append("Could not write ").append(configType.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$1).append(" since it is not a Broker or Topic entity.").toString());
        return state$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$2, ZkMigrationLeadershipState state$2) {
        ConfigResource.Type type = configResource$2.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)"brokers") : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)"topics") : None$.MODULE$);
        String configName = $this.toZkConfigEntityName(configResource$2.name());
        if (configType.isDefined()) {
            void var10_10;
            String path = ConfigEntityZNode$.MODULE$.path((String)configType.get(), configName);
            .colon.colon requests = new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
            Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$2);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int migrationZkVersion = tuple2._1$mcI$sp();
            Seq responses = (Seq)tuple2._2();
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Did not delete ").append(configResource$2).append(" since the node did not exist.").toString());
                return state$2;
            }
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
                void var9_9;
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(configType.get()).append("/").append(configName).toString());
                return state$2.withMigrationZkVersion((int)var9_9);
            }
            throw KeeperException.create((KeeperException.Code)((DeleteResponse)var10_10.head()).resultCode(), (String)path);
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$2).append(" since it is not a Broker or Topic entity.").toString());
        return state$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeClientQuotas$1(ZkConfigMigrationClient $this, java.util.Map entity$3, Object nonLocalReturnKey1$1, ZkMigrationLeadershipState state$3, java.util.Map quotas$1, java.util.Map scram$1) {
        void var10_12;
        void var11_13;
        java.util.Map<String, ConfigDef.ConfigKey> map;
        Option<String> option;
        Some some;
        Option<String> user = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "user");
        Option<String> client = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "client-id");
        Option<String> ip = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "ip");
        Properties props = new Properties();
        if (user.isDefined() && client.isEmpty()) {
            some = new Some((Object)"users");
            option = user;
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (user.isDefined() && client.isDefined()) {
            some = new Some((Object)"users");
            option = new Some((Object)new StringBuilder(9).append(user.get()).append("/clients/").append(client.get()).toString());
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (client.isDefined()) {
            some = new Some((Object)"clients");
            option = client;
            map = DynamicConfig$Client$.MODULE$.configKeys();
        } else if (ip.isDefined()) {
            some = new Some((Object)"ips");
            option = ip;
            map = DynamicConfig$Ip$.MODULE$.configKeys();
        } else {
            some = None$.MODULE$;
            option = None$.MODULE$;
            map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }
        java.util.Map<String, ConfigDef.ConfigKey> map2 = map;
        Option<String> option2 = option;
        Option configType = (Option)some;
        Option<String> path = option2;
        if (var11_13.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity$3).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)state$3);
        }
        quotas$1.forEach((x0$1, x1$1) -> {
            ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)map2.get(x0$1);
            if (configKey == null) {
                throw new MigrationClientException(new StringBuilder(26).append("Invalid configuration key ").append((String)x0$1).toString());
            }
            ConfigDef.Type type = configKey.type;
            if (ConfigDef.Type.DOUBLE.equals(type)) {
                props.setProperty((String)x0$1, x1$1.toString());
                return;
            }
            if (ConfigDef.Type.LONG.equals(type) ? true : ConfigDef.Type.INT.equals(type)) {
                long intValue;
                double epsilon = 1.0E-6;
                ConfigDef.Type type2 = configKey.type;
                ConfigDef.Type type3 = ConfigDef.Type.LONG;
                long l = !(type2 != null ? !type2.equals(type3) : type3 != null) ? (long)(Predef$.MODULE$.Double2double(x1$1) + epsilon) : (intValue = (long)((int)(Predef$.MODULE$.Double2double(x1$1) + epsilon)));
                if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((double)intValue - Predef$.MODULE$.Double2double(x1$1))) > epsilon) {
                    throw new InvalidRequestException(new StringBuilder(31).append("Configuration ").append((String)x0$1).append(" must be a ").append(configKey.type).append(" value").toString());
                }
                props.setProperty((String)x0$1, Long.toString(intValue));
                return;
            }
            throw new MigrationClientException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
        });
        scram$1.forEach((x0$2, x1$2) -> props.put(x0$2, x1$2));
        Option<ZkMigrationLeadershipState> option3 = $this.tryWriteEntityConfig((String)var10_12.get(), (String)var11_13.get(), props, false, state$3);
        if (option3 instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option3).value();
        }
        if (None$.MODULE$.equals(option3)) {
            String createPath = user.isDefined() && client.isDefined() ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)var10_12.get())).append("/").append(user.get()).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)var10_12.get());
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(createPath, x$3, false);
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity$3).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option4 = $this.tryWriteEntityConfig((String)var10_12.get(), (String)var11_13.get(), props, true, state$3);
            if (option4 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option4).value();
            }
            if (None$.MODULE$.equals(option4)) {
                throw new MigrationClientException(new StringBuilder(89).append("Could not write client quotas for ").append(entity$3).append(" on second attempt when using Create instead of SetData").toString());
            }
            throw new MatchError(option4);
        }
        throw new MatchError(option3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteEntityConfig$1(ZkConfigMigrationClient $this, Properties props$4, boolean create$1, String entityType$2, String path$1, ZkMigrationLeadershipState state$4) {
        void var10_10;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props$4);
        .colon.colon requests = create$1 ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, $this.zkClient.defaultAcls(path$1), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create$1 && ((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var9_9;
            $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(entityType$2).append("/").append(path$1).toString());
            return new Some((Object)state$4.withMigrationZkVersion((int)var9_9));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var10_10.head()).resultCode(), (String)path$1);
    }

    public ZkConfigMigrationClient(KafkaZkClient zkClient, PasswordEncoder passwordEncoder) {
        this.zkClient = zkClient;
        this.passwordEncoder = passwordEncoder;
        this.adminZkClient = new AdminZkClient(zkClient, (Option<KafkaConfig>)None$.MODULE$);
    }
}

