/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.Consumer;
import joptsimple.OptionException;
import joptsimple.OptionSet;
import kafka.common.MessageReader;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import kafka.utils.Exit$;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.api.RecordReader;
import scala.Function0;
import scala.None$;
import scala.Option;

public final class ConsoleProducer$
implements Logging {
    public static final ConsoleProducer$ MODULE$ = new ConsoleProducer$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public RecordReader newReader(String className, Properties prop) {
        Object reader = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (reader instanceof RecordReader) {
            RecordReader recordReader = (RecordReader)reader;
            recordReader.configure((Map)prop);
            return recordReader;
        }
        if (reader instanceof MessageReader) {
            MessageReader messageReader = (MessageReader)reader;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("MessageReader is deprecated. Please use org.apache.kafka.tools.api.RecordReader instead");
            }
            return new RecordReader(messageReader, prop){
                private boolean initialized;
                public final MessageReader x3$1;
                private final Properties prop$1;

                public void configure(Map<String, ?> x$1) {
                    super.configure(x$1);
                }

                public Iterator<ProducerRecord<byte[], byte[]>> readRecords(InputStream inputStream) {
                    if (this.initialized) {
                        throw new IllegalStateException("It is invalid to call readRecords again when the reader is based on deprecated MessageReader");
                    }
                    if (!this.initialized) {
                        this.x3$1.init(inputStream, this.prop$1);
                        this.initialized = true;
                    }
                    return new Iterator<ProducerRecord<byte[], byte[]>>(this){
                        private ProducerRecord<byte[], byte[]> current;
                        private boolean done;
                        private final /* synthetic */ anon.1 $outer;

                        public void remove() {
                            Iterator.super.remove();
                        }

                        public void forEachRemaining(Consumer<? super ProducerRecord<byte[], byte[]>> x$1) {
                            Iterator.super.forEachRemaining(x$1);
                        }

                        public boolean hasNext() {
                            if (this.current != null) {
                                return true;
                            }
                            if (this.done) {
                                return false;
                            }
                            this.current = this.$outer.x3$1.readMessage();
                            boolean bl = this.done = this.current == null;
                            return !this.done;
                        }

                        public ProducerRecord<byte[], byte[]> next() {
                            ProducerRecord<byte[], byte[]> producerRecord;
                            block4: {
                                try {
                                    if (this.hasNext()) {
                                        producerRecord = this.current;
                                        break block4;
                                    }
                                    throw new NoSuchElementException("no more records from input stream");
                                }
                                finally {
                                    this.current = null;
                                }
                            }
                            return producerRecord;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.done = false;
                        }
                    };
                }

                public void close() {
                    this.x3$1.close();
                }
                {
                    this.x3$1 = x3$1;
                    this.prop$1 = prop$1;
                    this.initialized = false;
                }
            };
        }
        throw new IllegalArgumentException(new StringBuilder(23).append("the reader must extend ").append(RecordReader.class.getName()).toString());
    }

    public void loopReader(Producer<byte[], byte[]> producer, RecordReader reader, InputStream inputStream, boolean sync) {
        Iterator iter = reader.readRecords(inputStream);
        try {
            while (iter.hasNext()) {
                this.send(producer, (ProducerRecord<byte[], byte[]>)((ProducerRecord)iter.next()), sync);
            }
        }
        finally {
            reader.close();
        }
    }

    public void main(String[] args) {
        try {
            ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
            InputStream input = System.in;
            try (KafkaProducer producer = new KafkaProducer(this.producerProps(config));){
                this.loopReader((Producer<byte[], byte[]>)producer, this.newReader(config.readerClass(), this.getReaderProps(config)), input, config.sync());
            }
            throw Exit$.MODULE$.exit(0, (Option<String>)None$.MODULE$);
        }
        catch (OptionException e) {
            System.err.println(e.getMessage());
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    private void send(Producer<byte[], byte[]> producer, ProducerRecord<byte[], byte[]> record, boolean sync) {
        if (sync) {
            producer.send(record).get();
            return;
        }
        producer.send(record, (Callback)new ErrorLoggingCallback(record.topic(), (byte[])record.key(), (byte[])record.value(), false));
    }

    public Properties getReaderProps(ConsoleProducer.ProducerConfig config) {
        Properties props = config.options.has(config.readerConfigOpt()) ? Utils.loadProps((String)((String)config.options.valueOf(config.readerConfigOpt())), null) : new Properties();
        props.put("topic", config.topic());
        new Implicits.PropertiesOps(props).$plus$plus$eq(config.cmdLineProps());
        return props;
    }

    public Properties producerProps(ConsoleProducer.ProducerConfig config) {
        Properties props = config.options.has(config.producerConfigOpt()) ? Utils.loadProps((String)((String)config.options.valueOf(config.producerConfigOpt())), null) : new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(config.extraProducerProps());
        if (config.bootstrapServer() != null) {
            props.put("bootstrap.servers", config.bootstrapServer());
        } else {
            props.put("bootstrap.servers", config.brokerList());
        }
        props.put("compression.type", config.compressionCodec());
        if (props.getProperty("client.id") == null) {
            props.put("client.id", "console-producer");
        }
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"linger.ms", (OptionSet)config.options, config.sendTimeoutOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"acks", (OptionSet)config.options, config.requestRequiredAcksOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"request.timeout.ms", (OptionSet)config.options, config.requestTimeoutMsOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"retries", (OptionSet)config.options, config.messageSendMaxRetriesOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"retry.backoff.ms", (OptionSet)config.options, config.retryBackoffMsOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"send.buffer.bytes", (OptionSet)config.options, config.socketBufferSizeOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"buffer.memory", (OptionSet)config.options, config.maxMemoryBytesOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"batch.size", (OptionSet)config.options, config.batchSizeOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"batch.size", (OptionSet)config.options, config.maxPartitionMemoryBytesOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"metadata.max.age.ms", (OptionSet)config.options, config.metadataExpiryMsOpt());
        CommandLineUtils.maybeMergeOptions((Properties)props, (String)"max.block.ms", (OptionSet)config.options, config.maxBlockMsOpt());
        return props;
    }

    private ConsoleProducer$() {
    }
}

