/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\u000b\u0017\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!!\u0006\u00011A\u0005\u0002Y)\u0006\u0002C4\u0001\u0001\u0004%\tA\u00065\t\r9\u0004\u0001\u0015)\u0003W\u0011\u001dy\u0007A1A\u0005\nUCa\u0001\u001d\u0001!\u0002\u00131\u0006bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000f]\u0004!\u0019!C\u0005q\"1A\u0010\u0001Q\u0001\neDQ! \u0001\u0005ByDq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u0011\u0005]\u0001\u0001\"\u0001\u0017\u0003+A\u0001\"!\u0007\u0001\t\u00031\u00121\u0004\u0005\b\u0003[\u0001A\u0011BA\u000b\u0005Q\u0011\u0006k\u0011)s_\u0012,8-\u001a:JI6\u000bg.Y4fe*\u0011q\u0003G\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u001a5\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005Y\u0012!B6bM.\f7\u0001A\n\u0005\u0001y!\u0003\u0006\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011AF\u0005\u0003OY\u0011\u0011\u0003\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s!\tIC&D\u0001+\u0015\tY#$A\u0003vi&d7/\u0003\u0002.U\t9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0011\u0005}\u0001\u0014BA\u0019!\u0005\rIe\u000e^\u0001\u0005i&lW\r\u0005\u00025{5\tQG\u0003\u0002,m)\u0011q\u0007O\u0001\u0007G>lWn\u001c8\u000b\u0005mI$B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001eL!AP\u001b\u0003\tQKW.Z\u0001\u0014EJ|7.\u001a:Fa>\u001c\u0007nU;qa2LWM\u001d\t\u0004?\u0005\u001b\u0015B\u0001\"!\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002 \t&\u0011Q\t\t\u0002\u0005\u0019>tw-A\td_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2\u0004\"\u0001S&\u000e\u0003%S!A\u0013\u001d\u0002\rM,'O^3s\u0013\ta\u0015J\u0001\u0010O_\u0012,Gk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u00061A(\u001b8jiz\"Ra\u0014)R%N\u0003\"!\n\u0001\t\u000b9*\u0001\u0019A\u0018\t\u000bI*\u0001\u0019A\u001a\t\u000b}*\u0001\u0019\u0001!\t\u000b\u0019+\u0001\u0019A$\u0002'9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI\ncwnY6\u0016\u0003Y\u00032a\u00161c\u001b\u0005A&BA-[\u0003\u0019\tGo\\7jG*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/_\u0003\u0011)H/\u001b7\u000b\u0003}\u000bAA[1wC&\u0011\u0011\r\u0017\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u00111-Z\u0007\u0002I*\u0011q'S\u0005\u0003M\u0012\u0014\u0001\u0003\u0015:pIV\u001cWM]%eg\ncwnY6\u0002/9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI\ncwnY6`I\u0015\fHCA5m!\ty\".\u0003\u0002lA\t!QK\\5u\u0011\u001diw!!AA\u0002Y\u000b1\u0001\u001f\u00132\u0003QqW\r\u001f;Qe>$WoY3s\u0013\u0012\u0014En\\2lA\u000512-\u001e:sK:$\bK]8ek\u000e,'/\u00133CY>\u001c7.A\fdkJ\u0014XM\u001c;Qe>$WoY3s\u0013\u0012\u0014En\\2lA\u0005y!/Z9vKN$\u0018J\u001c$mS\u001eDG/F\u0001t!\t9F/\u0003\u0002v1\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0001C]3rk\u0016\u001cH/\u00138GY&<\u0007\u000e\u001e\u0011\u0002#\t\f7m[8gM\u0012+\u0017\r\u001a7j]\u0016l5/F\u0001z!\t9&0\u0003\u0002|1\nQ\u0011\t^8nS\u000eduN\\4\u0002%\t\f7m[8gM\u0012+\u0017\r\u001a7j]\u0016l5\u000fI\u0001\u000eQ\u0006\u001ch+\u00197jI\ncwnY6\u0016\u0003}\u00042aHA\u0001\u0013\r\t\u0019\u0001\t\u0002\b\u0005>|G.Z1o\u0003I9WM\\3sCR,\u0007K]8ek\u000e,'/\u00133\u0015\u0005\u0005%\u0001#BA\u0006\u0003\u001f\u0019UBAA\u0007\u0015\ti\u0006%\u0003\u0003\u0002\u0012\u00055!a\u0001+ss\u0006)R.Y=cKJ+\u0017/^3ti:+\u0007\u0010\u001e\"m_\u000e\\G#A5\u0002\u0017M,g\u000e\u001a*fcV,7\u000f^\u0001\"Q\u0006tG\r\\3BY2|7-\u0019;f!J|G-^2fe&#7OU3ta>t7/\u001a\u000b\u0004S\u0006u\u0001bBA\u0010'\u0001\u0007\u0011\u0011E\u0001\te\u0016\u001c\bo\u001c8tKB!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(Y\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003W\t)CA\u000eBY2|7-\u0019;f!J|G-^2fe&#7OU3ta>t7/Z\u0001\u000eQ\u0006tG\r\\3US6,w.\u001e;")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Time time;
    private final Function0<Object> brokerEpochSupplier;
    private final NodeToControllerChannelManager controllerChannel;
    private AtomicReference<ProducerIdsBlock> nextProducerIdBlock;
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private final AtomicLong backoffDeadlineMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicReference<ProducerIdsBlock> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    public void nextProducerIdBlock_$eq(AtomicReference<ProducerIdsBlock> x$1) {
        this.nextProducerIdBlock = x$1;
    }

    private AtomicReference<ProducerIdsBlock> currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private AtomicLong backoffDeadlineMs() {
        return this.backoffDeadlineMs;
    }

    @Override
    public boolean hasValidBlock() {
        return this.nextProducerIdBlock().get() != null;
    }

    @Override
    public Try<Object> generateProducerId() {
        Failure result = null;
        int iteration = 0;
        while (result == null) {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.currentProducerIdBlock().get().claimNextId()));
            if (None$.MODULE$.equals(option)) {
                ProducerIdsBlock block = this.nextProducerIdBlock().getAndSet(null);
                if (block == null) {
                    this.maybeRequestNextBlock();
                    result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
                } else {
                    this.currentProducerIdBlock().set(block);
                    this.requestInFlight().set(false);
                    ++iteration;
                }
            } else if (option instanceof Some) {
                long prefetchTarget;
                Long nextProducerId = (Long)((Some)option).value();
                if (BoxesRunTime.equalsNumObject((Number)nextProducerId, (Object)BoxesRunTime.boxToLong((long)(prefetchTarget = this.currentProducerIdBlock().get().firstProducerId() + (long)((double)this.currentProducerIdBlock().get().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()))))) {
                    this.maybeRequestNextBlock();
                }
                result = new Success((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(nextProducerId)));
            } else {
                throw new MatchError((Object)option);
            }
            if (iteration != ProducerIdManager$.MODULE$.IterationLimit()) continue;
            result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
        }
        return result;
    }

    private void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs().get();
        if (retryTimestamp == ProducerIdManager$.MODULE$.NoRetry() || this.time.milliseconds() >= retryTimestamp) {
            if (this.nextProducerIdBlock().get() == null && this.requestInFlight().compareAndSet(false, true)) {
                this.sendRequest();
                this.backoffDeadlineMs().set(ProducerIdManager$.MODULE$.NoRetry());
                return;
            }
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse message = (AllocateProducerIdsResponse)response.responseBody();
                this.$outer.handleAllocateProducerIdsResponse(message);
            }

            public void onTimeout() {
                this.$outer.kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
        AllocateProducerIdsResponseData data = response.data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().get().lastProducerId()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString());
            } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString());
            } else {
                this.nextProducerIdBlock().set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
                successfulResponse = true;
            }
        } else if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker currentBlockCount was stale, trying again.");
        } else if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
        } else if (errors != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Received an unexpected error code from the controller: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        if (!successfulResponse) {
            this.backoffDeadlineMs().set(this.time.milliseconds() + (long)ProducerIdManager$.MODULE$.RetryBackoffMs());
            this.requestInFlight().set(false);
            return;
        }
    }

    public void kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
    }

    public RPCProducerIdManager(int brokerId, Time time, Function0<Object> brokerEpochSupplier, NodeToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new AtomicReference<Object>(null);
        this.currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
        this.requestInFlight = new AtomicBoolean(false);
        this.backoffDeadlineMs = new AtomicLong(ProducerIdManager$.MODULE$.NoRetry());
    }
}

