/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.algorithms.Tarjan;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public class CycleDetector
extends Test {
    protected static final int CYCLE_DETECTED = 4200;
    private final Set<Way> usableWaterways = new HashSet<Way>();
    private final Set<Long> visitedWays = new HashSet<Long>();
    private List<String> directionalWaterways;
    protected static final String PREFIX = "validator." + CycleDetector.class.getSimpleName();

    public CycleDetector() {
        super(I18n.tr("Cycle detector", new Object[0]), I18n.tr("Detects cycles in drainage systems.", new Object[0]));
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isUsable() && p instanceof Way && ((Way)p).getNodesCount() > 1 && p.hasTag("waterway", this.directionalWaterways);
    }

    @Override
    public void visit(Way w) {
        if (this.isPrimitiveUsable(w)) {
            this.usableWaterways.add(w);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.directionalWaterways = Config.getPref().getList(PREFIX + ".directionalWaterways", Arrays.asList("river", "stream", "tidal_channel", "drain", "ditch", "fish_pass"));
    }

    @Override
    public void endTest() {
        QuadBuckets<Way> quadBuckets = new QuadBuckets<Way>();
        quadBuckets.addAll((Collection<Way>)this.usableWaterways);
        for (Collection<Way> graph : this.getGraphs()) {
            NodeGraph nodeGraph = NodeGraph.createDirectedGraphFromWays(graph);
            Tarjan tarjan = new Tarjan(nodeGraph);
            Collection<List<Node>> scc = tarjan.getSCC();
            if (this.partialSelection) {
                quadBuckets.addAll(graph);
            }
            for (List<Node> possibleCycle : scc) {
                if (possibleCycle.size() <= 1) continue;
                BBox bBox = new BBox();
                possibleCycle.forEach(node -> bBox.addPrimitive((OsmPrimitive)node, 0.0));
                List waysWithinErrorBbox = quadBuckets.search(bBox);
                List toReport = waysWithinErrorBbox.stream().filter(w -> possibleCycle.stream().filter(w.getNodes()::contains).count() > 1L).collect(Collectors.toList());
                Map<Node, List<Node>> graphMap = tarjan.getGraphMap();
                this.errors.add(TestError.builder(this, Severity.ERROR, 4200).message(I18n.trc("graph theory", "Cycle in directional waterway network")).primitives(toReport).highlightWaySegments(CycleDetector.createSegments(graphMap, possibleCycle)).build());
            }
        }
        this.usableWaterways.clear();
        this.visitedWays.clear();
        super.endTest();
    }

    private static Collection<WaySegment> createSegments(Map<Node, List<Node>> graphMap, Collection<Node> nodes) {
        ArrayList<Pair<Node, Node>> pairs = new ArrayList<Pair<Node, Node>>();
        for (Node node : nodes) {
            for (Node successor : graphMap.get(node)) {
                if (!nodes.contains(successor)) continue;
                pairs.add(new Pair<Node, Node>(node, successor));
            }
        }
        ArrayList<WaySegment> segments = new ArrayList<WaySegment>();
        for (Pair pair : pairs) {
            Node n = (Node)pair.a;
            Node m = (Node)pair.b;
            if (n == null || m == null || n.equals(m)) continue;
            ArrayList<Way> intersect = new ArrayList<Way>(n.getParentWays());
            List<Way> mWays = m.getParentWays();
            intersect.retainAll(mWays);
            for (Way w : intersect) {
                if (!CycleDetector.isConsecutive(w, n, m)) continue;
                segments.add(WaySegment.forNodePair(w, n, m));
            }
        }
        return segments;
    }

    private static boolean isConsecutive(Way w, Node n, Node m) {
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            if (!w.getNode(i).equals(n) || !w.getNode(i + 1).equals(m)) continue;
            return true;
        }
        return false;
    }

    private Collection<Collection<Way>> getGraphs() {
        ArrayList<Collection<Way>> graphs = new ArrayList<Collection<Way>>();
        for (Way waterway : this.usableWaterways) {
            Collection<Way> graph;
            if (this.visitedWays.contains(waterway.getUniqueId()) || (graph = this.buildGraph(waterway)).isEmpty()) continue;
            graphs.add(graph);
        }
        return graphs;
    }

    private Collection<Way> buildGraph(Way way) {
        HashSet<Way> graph = new HashSet<Way>();
        ArrayDeque<Way> queue = new ArrayDeque<Way>();
        queue.offer(way);
        while (!queue.isEmpty()) {
            Way currentWay = (Way)queue.poll();
            this.visitedWays.add(currentWay.getUniqueId());
            for (Node node : currentWay.getNodes()) {
                Collection referrers = node.referrers(Way.class).filter(this::isPrimitiveUsable).filter(candidate -> candidate != currentWay).collect(Collectors.toList());
                if (referrers.isEmpty()) continue;
                for (Way referrer : referrers) {
                    if (this.visitedWays.contains(referrer.getUniqueId())) continue;
                    queue.offer(referrer);
                    this.visitedWays.add(referrer.getUniqueId());
                }
                graph.addAll(referrers);
            }
        }
        if (graph.isEmpty()) {
            graph.add(way);
        }
        return graph;
    }
}

