/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javajs.J2SIgnoreImport;
import javajs.api.BytePoster;
import javajs.api.GenericOutputChannel;
import javajs.api.js.J2SObjectInterface;
import javajs.util.Base64;
import javajs.util.SB;

@J2SIgnoreImport(value={FileOutputStream.class})
public class OC
extends OutputStream
implements GenericOutputChannel {
    private BytePoster bytePoster;
    private String fileName;
    private BufferedWriter bw;
    private boolean isLocalFile;
    private int byteCount;
    private boolean isCanceled;
    private boolean closed;
    private OutputStream os;
    private SB sb;
    private String type;
    private boolean isBase64;
    private OutputStream os0;
    private byte[] bytes;
    public boolean bigEndian = true;
    public static final String[] urlPrefixes = new String[]{"http:", "https:", "sftp:", "ftp:", "file:", "cache:"};
    public static final int URL_LOCAL = 4;
    public static final int URL_CACHE = 5;

    public OC() {
    }

    public OC(String fileName) {
        this.setParams(null, fileName, false, null);
    }

    public OC setParams(BytePoster bytePoster, String fileName, boolean asWriter, OutputStream os) {
        this.bytePoster = bytePoster;
        this.isBase64 = ";base64,".equals(fileName);
        if (this.isBase64) {
            fileName = null;
            this.os0 = os;
            os = null;
        }
        this.fileName = fileName;
        this.os = os;
        boolean bl = this.isLocalFile = fileName != null && !OC.isRemote(fileName);
        if (asWriter && !this.isBase64 && os != null) {
            this.bw = new BufferedWriter(new OutputStreamWriter(os));
        }
        return this;
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean TF) {
        this.bigEndian = TF;
    }

    public OC setBytes(byte[] b) {
        this.bytes = b;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.fileName == null ? null : this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public OC append(String s) {
        block5: {
            try {
                if (this.bw != null) {
                    this.bw.write(s);
                    break block5;
                }
                if (this.os == null) {
                    if (this.sb == null) {
                        this.sb = new SB();
                    }
                    this.sb.append(s);
                    break block5;
                }
                byte[] b = s.getBytes();
                this.os.write(b, 0, b.length);
                this.byteCount += b.length;
                return this;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.byteCount += s.length();
        return this;
    }

    @Override
    public void reset() {
        this.sb = null;
        this.initOS();
    }

    private void initOS() {
        if (this.sb != null) {
            String s = this.sb.toString();
            this.reset();
            this.append(s);
            return;
        }
        try {
            if (this.os instanceof FileOutputStream) {
                this.os.close();
                this.os = new FileOutputStream(this.fileName);
            } else {
                this.os = null;
            }
            if (this.os == null) {
                this.os = new ByteArrayOutputStream();
            }
            if (this.bw != null) {
                this.bw.close();
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.byteCount = 0;
    }

    @Override
    public void writeByteAsInt(int b) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.byteCount;
    }

    @Override
    public void write(byte[] buf, int i, int len) {
        if (this.os == null) {
            this.initOS();
        }
        if (len < 0) {
            len = buf.length - i;
        }
        try {
            this.os.write(buf, i, len);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.byteCount += len;
    }

    @Override
    public void writeShort(short i) {
        if (this.isBigEndian()) {
            this.writeByteAsInt(i >> 8);
            this.writeByteAsInt(i);
        } else {
            this.writeByteAsInt(i);
            this.writeByteAsInt(i >> 8);
        }
    }

    @Override
    public void writeLong(long b) {
        if (this.isBigEndian()) {
            this.writeInt((int)(b >> 32 & 0xFFFFFFFFL));
            this.writeInt((int)(b & 0xFFFFFFFFL));
        } else {
            this.writeByteAsInt((int)(b >> 56));
            this.writeByteAsInt((int)(b >> 48));
            this.writeByteAsInt((int)(b >> 40));
            this.writeByteAsInt((int)(b >> 32));
            this.writeByteAsInt((int)(b >> 24));
            this.writeByteAsInt((int)(b >> 16));
            this.writeByteAsInt((int)(b >> 8));
            this.writeByteAsInt((int)b);
        }
    }

    @Override
    @Deprecated
    public void write(int b) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.byteCount;
    }

    public void cancel() {
        this.isCanceled = true;
        this.closeChannel();
    }

    @Override
    public String closeChannel() {
        if (this.closed) {
            return null;
        }
        try {
            if (this.bw != null) {
                this.bw.flush();
                this.bw.close();
            } else if (this.os != null) {
                this.os.flush();
                this.os.close();
            }
            if (this.os0 != null && this.isCanceled) {
                this.os0.flush();
                this.os0.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isCanceled) {
            this.closed = true;
            return null;
        }
        if (this.fileName == null) {
            if (this.isBase64) {
                String s = this.getBase64();
                if (this.os0 != null) {
                    this.os = this.os0;
                    this.append(s);
                }
                this.sb = new SB();
                this.sb.append(s);
                this.isBase64 = false;
                return this.closeChannel();
            }
            return this.sb == null ? null : this.sb.toString();
        }
        this.closed = true;
        if (!this.isLocalFile) {
            String ret = this.postByteArray();
            if (ret == null || ret.startsWith("java.net")) {
                this.byteCount = -1;
            }
            return ret;
        }
        J2SObjectInterface jmol = null;
        Object _function = null;
        if (jmol != null) {
            Object data;
            Object object = data = this.sb == null ? this.toByteArray() : (Object)this.sb.toString();
            if (_function == null) {
                jmol.doAjax((Object)this.fileName, null, data, this.sb == null);
            } else {
                jmol.applyFunc(this.fileName, data);
            }
        }
        return null;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public String getBase64() {
        return Base64.getBase64(this.toByteArray()).toString();
    }

    public byte[] toByteArray() {
        return this.bytes != null ? this.bytes : (byte[])(this.os instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.os).toByteArray() : null);
    }

    @Override
    @Deprecated
    public void close() {
        this.closeChannel();
    }

    public String toString() {
        if (this.bw != null) {
            try {
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sb != null) {
            return this.closeChannel();
        }
        return this.byteCount + " bytes";
    }

    private String postByteArray() {
        byte[] bytes = this.sb == null ? this.toByteArray() : this.sb.toString().getBytes();
        return this.bytePoster.postByteArray(this.fileName, bytes);
    }

    public static boolean isRemote(String fileName) {
        if (fileName == null) {
            return false;
        }
        int itype = OC.urlTypeIndex(fileName);
        return itype >= 0 && itype < 4;
    }

    public static boolean isLocal(String fileName) {
        return fileName != null && !OC.isRemote(fileName);
    }

    public static int urlTypeIndex(String name) {
        if (name == null) {
            return -2;
        }
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void writeInt(int i) {
        if (this.bigEndian) {
            this.writeByteAsInt(i >> 24);
            this.writeByteAsInt(i >> 16);
            this.writeByteAsInt(i >> 8);
            this.writeByteAsInt(i);
        } else {
            this.writeByteAsInt(i);
            this.writeByteAsInt(i >> 8);
            this.writeByteAsInt(i >> 16);
            this.writeByteAsInt(i >> 24);
        }
    }

    public void writeFloat(float x) {
        this.writeInt(x == 0.0f ? 0 : Float.floatToIntBits(x));
    }
}

