/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.IOException;
import java.util.Iterator;
import javajs.util.SB;
import jspecview.common.Coordinate;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.util.Logger;

public class JDXDecompressor
implements Iterator<Double> {
    private double xFactor;
    private double yFactor;
    private int nPoints;
    private static final String delimiters = " ,\t\n";
    private static final int[] actions = new int[255];
    private static final int ACTION_INVALID = -1;
    private static final int ACTION_UNKNOWN = 0;
    private static final int ACTION_DIF = 1;
    private static final int ACTION_DUP = 2;
    private static final int ACTION_SQZ = 3;
    private static final int ACTION_NUMERIC = 4;
    private static final double INVALID_Y = Double.MAX_VALUE;
    int ich;
    private JDXSourceStreamTokenizer t;
    private double firstX;
    double lastX;
    private double maxY = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private boolean debugging;
    private Coordinate[] xyCoords;
    private String line;
    private int lineLen;
    private SB errorLog;
    private int lastDif = Integer.MIN_VALUE;
    private int dupCount;
    private int nptsFound;
    double lastY;
    private boolean isDIF = true;

    static {
        int n = 37;
        while (n <= 115) {
            char c = (char)n;
            switch (c) {
                case '%': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': {
                    JDXDecompressor.actions[n] = 1;
                    break;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    JDXDecompressor.actions[n] = 4;
                    break;
                }
                case '?': {
                    JDXDecompressor.actions[n] = -1;
                    break;
                }
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': {
                    JDXDecompressor.actions[n] = 3;
                    break;
                }
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 's': {
                    JDXDecompressor.actions[n] = 2;
                }
            }
            ++n;
        }
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public JDXDecompressor(JDXSourceStreamTokenizer jDXSourceStreamTokenizer, double d, double d2, double d3, double d4, int n) {
        this.t = jDXSourceStreamTokenizer;
        this.firstX = d;
        this.lastX = d2;
        this.xFactor = d3;
        this.yFactor = d4;
        this.nPoints = n;
        this.debugging = Logger.isActiveLevel(6);
    }

    public JDXDecompressor(String string, int n) {
        this.line = string.trim();
        this.lineLen = string.length();
        this.lastY = n;
    }

    public Coordinate[] decompressData(SB sB) {
        this.errorLog = sB;
        double d = Coordinate.deltaX(this.lastX, this.firstX, this.nPoints);
        if (this.debugging) {
            this.logError("firstX=" + this.firstX + " lastX=" + this.lastX + " xFactor=" + this.xFactor + " yFactor=" + this.yFactor + " deltaX=" + d + " nPoints=" + this.nPoints);
        }
        this.xyCoords = new Coordinate[this.nPoints];
        double d2 = 0.5;
        double d3 = 0.0;
        int n = 0;
        double d4 = this.lastX;
        double d5 = this.lastX = this.firstX;
        String string = null;
        int n2 = 0;
        double d6 = 0.0;
        boolean bl = false;
        int n3 = this.t.labelLineNo;
        try {
            while ((this.line = this.t.readLineTrimmed()) != null && this.line.indexOf("##") < 0) {
                ++n3;
                this.lineLen = this.line.length();
                if (this.lineLen == 0) continue;
                this.ich = 0;
                boolean bl2 = this.isDIF;
                double d7 = this.readSignedFloat() * this.xFactor;
                d6 = this.nextValue(d6);
                if (!bl2 && n2 > 0) {
                    d5 += d;
                }
                if (this.debugging) {
                    this.logError("Line: " + n3 + " isCP=" + bl2 + "\t>>" + this.line + "<<\n x, xcheck " + d5 + " " + d5 / this.xFactor + " " + d7 / this.xFactor + " " + d / this.xFactor);
                }
                double d8 = d6 * this.yFactor;
                Coordinate coordinate = new Coordinate().set(d5, d8);
                if (n2 == 0 || !bl2) {
                    this.addPoint(coordinate, n2++);
                } else if (n2 < this.nPoints) {
                    double d9 = this.xyCoords[n2 - 1].getYVal();
                    if (d8 != d9) {
                        this.xyCoords[n2 - 1] = coordinate;
                        this.logError(String.valueOf(string) + "\n" + this.line + "\nY-value Checkpoint Error! Line " + n3 + " for y=" + d8 + " yLast=" + d9);
                    }
                    if (d7 == d3 || d7 < d3 != d < 0.0) {
                        this.logError(String.valueOf(string) + "\n" + this.line + "\nX-sequence Checkpoint Error! Line " + n3 + " order for xCheck=" + d7 + " after prevXCheck=" + d3);
                    }
                    double d10 = Math.abs(d7 - d3);
                    double d11 = Math.abs((double)(n2 - n) * d);
                    double d12 = Math.abs(d10 - d11) / d10;
                    if (this.debugging) {
                        System.err.println("JDXD fracDif = " + d7 + "\t" + d3 + "\txcheckDif=" + d10 + "\txiptDif=" + d11 + "\tf=" + d12);
                    }
                    if (d12 > d2) {
                        this.logError(String.valueOf(string) + "\n" + this.line + "\nX-value Checkpoint Error! Line " + n3 + " expected " + d11 + " but X-Sequence Check difference reads " + d10);
                    }
                }
                n = n2 == 1 ? 0 : n2;
                d3 = d7;
                int n4 = 0;
                while (this.hasNext()) {
                    int n5 = this.ich;
                    if (this.debugging) {
                        this.logError("line " + n3 + " char " + n5 + ":" + this.line.substring(0, n5) + ">>>>" + this.line.substring(this.ich));
                    }
                    if (Double.isNaN(d6 = this.nextValue(d6))) {
                        this.logError("There was an error reading line " + n3 + " char " + n5 + ":" + this.line.substring(0, n5) + ">>>>" + this.line.substring(n5));
                        continue;
                    }
                    d5 += d;
                    if (d6 == Double.MAX_VALUE) {
                        d6 = 0.0;
                        this.logError("Point marked invalid '?' for line " + n3 + " char " + n5 + ":" + this.line.substring(0, n5) + ">>>>" + this.line.substring(n5));
                    }
                    this.addPoint(new Coordinate().set(d5, d6 * this.yFactor), n2++);
                    if (!this.debugging) continue;
                    this.logError("nx=" + ++n4 + " " + d5 + " " + d5 / this.xFactor + " yval=" + d6);
                }
                this.lastX = d5;
                if (!bl && n2 > this.nPoints) {
                    this.logError("! points overflow nPoints!");
                    bl = true;
                }
                string = this.line;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.checkZeroFill(n2, d4);
        return this.xyCoords;
    }

    private void checkZeroFill(int n, double d) {
        this.nptsFound = n;
        if (this.nPoints == this.nptsFound) {
            if (Math.abs(d - this.lastX) > 1.0E-5) {
                this.logError("Something went wrong! The last X value was " + this.lastX + " but expected " + d);
            }
        } else {
            this.logError("Decompressor did not find " + this.nPoints + " points -- instead " + this.nptsFound + " xyCoords.length set to " + this.nPoints);
            int n2 = this.nptsFound;
            while (n2 < this.nPoints) {
                this.addPoint(new Coordinate().set(0.0, Double.NaN), n2);
                ++n2;
            }
        }
    }

    private void addPoint(Coordinate coordinate, int n) {
        if (n >= this.nPoints) {
            return;
        }
        this.xyCoords[n] = coordinate;
        double d = coordinate.getYVal();
        if (d > this.maxY) {
            this.maxY = d;
        } else if (d < this.minY) {
            this.minY = d;
        }
        if (this.debugging) {
            this.logError("Coord: " + n + coordinate);
        }
    }

    private void logError(String string) {
        if (this.debugging) {
            Logger.debug(string);
        }
        System.err.println(string);
        this.errorLog.append(string).appendC('\n');
    }

    private double nextValue(double d) {
        if (this.dupCount > 0) {
            return this.getDuplicate(d);
        }
        char c = this.skipUnknown();
        switch (actions[c]) {
            case 1: {
                this.isDIF = true;
                this.lastDif = this.readNextInteger(c == '%' ? 0 : (c <= 'R' ? c - 73 : 105 - c));
                return d + (double)this.lastDif;
            }
            case 2: {
                this.dupCount = this.readNextInteger(c == 's' ? 9 : c - 82) - 1;
                return this.getDuplicate(d);
            }
            case 3: {
                d = this.readNextSqueezedNumber(c);
                break;
            }
            case 4: {
                --this.ich;
                d = this.readSignedFloat();
                break;
            }
            case -1: {
                d = Double.MAX_VALUE;
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        this.isDIF = false;
        return d;
    }

    private char skipUnknown() {
        char c = '\u0000';
        while (this.ich < this.lineLen && actions[c = this.line.charAt(this.ich++)] == 0) {
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private double readSignedFloat() throws NumberFormatException {
        var1_1 = this.ich;
        var2_2 = 0;
        if (true) ** GOTO lbl6
        do {
            ++this.ich;
lbl6:
            // 2 sources

            if (this.ich >= this.lineLen) break;
            v0 = this.line.charAt(this.ich);
            var2_2 = v0;
        } while (" ,\t\n".indexOf(v0) >= 0);
        var3_3 = 1.0;
        switch (var2_2) {
            case 45: {
                var3_3 = -1.0;
            }
            case 43: {
                var1_1 = ++this.ich;
            }
        }
        if (this.scanToNonnumeric() == 'E' && this.ich + 3 < this.lineLen) {
            switch (this.line.charAt(this.ich + 1)) {
                case '+': 
                case '-': {
                    this.ich += 4;
                    if (this.ich >= this.lineLen) break;
                    v1 = this.line.charAt(this.ich);
                    var2_2 = v1;
                    if (v1 < '0' || var2_2 > 57) break;
                    ++this.ich;
                }
            }
        }
        return var3_3 * Double.parseDouble(this.line.substring(var1_1, this.ich));
    }

    private double getDuplicate(double d) {
        --this.dupCount;
        return this.isDIF ? d + (double)this.lastDif : d;
    }

    private int readNextInteger(int n) {
        char c = '\u0000';
        while (this.ich < this.lineLen && (c = this.line.charAt(this.ich)) >= '0' && c <= '9') {
            n = n * 10 + (n < 0 ? 48 - c : c - 48);
            ++this.ich;
        }
        return n;
    }

    private double readNextSqueezedNumber(char c) {
        int n = this.ich;
        this.scanToNonnumeric();
        return Double.parseDouble(String.valueOf(c > '`' ? 96 - c : c - 64) + this.line.substring(n, this.ich));
    }

    private char scanToNonnumeric() {
        char c = '\u0000';
        while (this.ich < this.lineLen && ((c = this.line.charAt(this.ich)) == '.' || c >= '0' && c <= '9')) {
            ++this.ich;
        }
        return this.ich < this.lineLen ? c : (char)'\u0000';
    }

    public int getNPointsFound() {
        return this.nptsFound;
    }

    @Override
    public boolean hasNext() {
        return this.ich < this.lineLen || this.dupCount > 0;
    }

    @Override
    public Double next() {
        Double d;
        if (this.hasNext()) {
            this.lastY = this.nextValue(this.lastY);
            d = this.lastY;
        } else {
            d = null;
        }
        return d;
    }

    @Override
    public void remove() {
    }
}

