import { AbstractStreamReader } from "./AbstractStreamReader.js";
/**
 * Read from a WebStream using a BYOB reader
 * Reference: https://nodejs.org/api/webstreams.html#class-readablestreambyobreader
 */
export class WebStreamByobReader extends AbstractStreamReader {
    constructor(reader) {
        super();
        this.reader = reader;
    }
    async readFromStream(buffer, offset, length) {
        const result = await this.reader.read(new Uint8Array(length));
        if (result.done) {
            this.endOfStream = result.done;
        }
        if (result.value) {
            buffer.set(result.value, offset);
            return result.value.byteLength;
        }
        return 0;
    }
    abort() {
        return this.reader.cancel(); // Signals a loss of interest in the stream by a consumer
    }
    async close() {
        await this.abort();
        this.reader.releaseLock();
    }
}
