/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;

class LatestModuleConflictResolver<T extends ComponentResolutionState>
implements ModuleConflictResolver<T> {
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;

    LatestModuleConflictResolver(VersionComparator versionComparator, VersionParser versionParser) {
        this.versionComparator = versionComparator.asVersionComparator();
        this.versionParser = versionParser;
    }

    @Override
    public void select(ConflictResolverDetails<T> details) {
        Version baseVersion = null;
        LinkedHashMap<Version, ComponentResolutionState> matches = new LinkedHashMap<Version, ComponentResolutionState>();
        for (ComponentResolutionState candidate : details.getCandidates()) {
            Version version = this.versionParser.transform(candidate.getVersion());
            if (baseVersion == null || this.versionComparator.compare(version.getBaseVersion(), baseVersion) > 0) {
                matches.clear();
                baseVersion = version.getBaseVersion();
                matches.put(version, candidate);
                continue;
            }
            if (!version.getBaseVersion().equals(baseVersion)) continue;
            matches.put(version, candidate);
        }
        if (matches.size() == 1) {
            details.select((ComponentResolutionState)matches.values().iterator().next());
            return;
        }
        ArrayList sorted = new ArrayList(matches.keySet());
        sorted.sort(Collections.reverseOrder(this.versionComparator));
        ComponentResolutionState bestComponent = null;
        ComponentResolutionState unqalifiedComponent = null;
        for (Version version : sorted) {
            ComponentResolutionState component = (ComponentResolutionState)matches.get(version);
            if (!version.isQualified()) {
                if (bestComponent == null) {
                    details.select(component);
                    return;
                }
                if (unqalifiedComponent == null) {
                    unqalifiedComponent = component;
                }
            }
            if (bestComponent != null) continue;
            ComponentGraphResolveMetadata metaData = component.getMetadataOrNull();
            if (this.hasReleaseStatus(metaData)) {
                details.select(component);
                return;
            }
            if (!this.isMavenSnapshot(metaData)) continue;
            bestComponent = component;
        }
        if (unqalifiedComponent != null) {
            details.select(unqalifiedComponent);
            return;
        }
        if (bestComponent != null) {
            details.select(bestComponent);
        }
        details.select((ComponentResolutionState)matches.get(sorted.get(0)));
    }

    private boolean hasReleaseStatus(@Nullable ComponentGraphResolveMetadata metadata) {
        return metadata != null && "release".equals(metadata.getStatus());
    }

    private boolean isMavenSnapshot(@Nullable ComponentGraphResolveMetadata metadata) {
        if (metadata instanceof MavenModuleResolveMetadata) {
            return ((MavenModuleResolveMetadata)metadata).getSnapshotTimestamp() != null || metadata.getModuleVersionId().getVersion().endsWith("-SNAPSHOT");
        }
        return false;
    }
}

