/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptionalExpectationChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getOptionalExpectationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend"})
public final class OptionalExpectationChecker {
    @NotNull
    public static final OptionalExpectationChecker INSTANCE = new OptionalExpectationChecker();

    private OptionalExpectationChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        block2: {
            block1: {
                boolean isExpect;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                boolean bl = isExpect = descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect();
                if (!isExpect) break block1;
                if (!DescriptorUtils.isAnnotationClass(descriptor2) || descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor) break block2;
                KtAnnotationEntry ktAnnotationEntry = this.getOptionalExpectationEntry(declaration, trace);
                if (ktAnnotationEntry != null) {
                    KtAnnotationEntry it = ktAnnotationEntry;
                    boolean bl2 = false;
                    trace.report(Errors.NESTED_OPTIONAL_EXPECTATION.on(it));
                }
                break block2;
            }
            KtAnnotationEntry ktAnnotationEntry = this.getOptionalExpectationEntry(declaration, trace);
            if (ktAnnotationEntry == null) break block2;
            KtAnnotationEntry it = ktAnnotationEntry;
            boolean bl = false;
            trace.report(Errors.OPTIONAL_EXPECTATION_NOT_ON_EXPECTED.on(it));
        }
    }

    private final KtAnnotationEntry getOptionalExpectationEntry(KtDeclaration declaration, BindingTrace trace) {
        Object v2;
        block1: {
            List<KtAnnotationEntry> list2 = declaration.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.annotationEntries");
            Iterable iterable = list2;
            for (Object t : iterable) {
                AnnotationDescriptor annotationDescriptor;
                KtAnnotationEntry entry = (KtAnnotationEntry)t;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                if (!Intrinsics.areEqual((Object)(annotationDescriptor2 != null ? annotationDescriptor2.getFqName() : null), (Object)OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME())) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }
}

