/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.InputsCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.IncrementalFileToPathConverter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010*\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020\nJ\u001b\u0010,\u001a\u00020-\"\b\b\u0001\u0010.*\u00020\u000f*\u0002H.H\u0004\u00a2\u0006\u0002\u0010/R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "PlatformCache", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "", "cachesRootDir", "Ljava/io/File;", "rootProjectDir", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "storeFullFqNamesInLookupCache", "", "trackChangesInLookupCache", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/build/report/ICReporter;ZZ)V", "caches", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Lkotlin/collections/ArrayList;", "inputSnapshotsCacheDir", "inputsCache", "Lorg/jetbrains/kotlin/incremental/InputsCache;", "getInputsCache", "()Lorg/jetbrains/kotlin/incremental/InputsCache;", "isClosed", "()Z", "setClosed", "(Z)V", "isSuccessfulyClosed", "setSuccessfulyClosed", "lookupCache", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "getLookupCache", "()Lorg/jetbrains/kotlin/incremental/LookupStorage;", "lookupCacheDir", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter;", "getPathConverter", "()Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter;", "platformCache", "getPlatformCache", "()Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "getReporter", "()Lorg/jetbrains/kotlin/build/report/ICReporter;", "close", "flush", "registerCache", "", "T", "(Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;)V", "incremental-compilation-impl"})
public abstract class IncrementalCachesManager<PlatformCache extends AbstractIncrementalCache<?>> {
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final IncrementalFileToPathConverter pathConverter;
    @NotNull
    private final ArrayList<BasicMapsOwner> caches;
    private boolean isClosed;
    private boolean isSuccessfulyClosed;
    @NotNull
    private final File inputSnapshotsCacheDir;
    @NotNull
    private final File lookupCacheDir;
    @NotNull
    private final InputsCache inputsCache;
    @NotNull
    private final LookupStorage lookupCache;

    /*
     * WARNING - void declaration
     */
    public IncrementalCachesManager(@NotNull File cachesRootDir, @Nullable File rootProjectDir, @NotNull ICReporter reporter, boolean storeFullFqNamesInLookupCache, boolean trackChangesInLookupCache) {
        void $this$lookupCache_u24lambda_u2d4;
        Object $this$inputsCache_u24lambda_u2d3;
        Object $this$lookupCacheDir_u24lambda_u2d2;
        File $this$inputSnapshotsCacheDir_u24lambda_u2d1;
        Intrinsics.checkNotNullParameter((Object)cachesRootDir, (String)"cachesRootDir");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.reporter = reporter;
        this.pathConverter = new IncrementalFileToPathConverter(rootProjectDir);
        this.caches = new ArrayList();
        Object object = new File(cachesRootDir, "inputs");
        File file2 = object;
        IncrementalCachesManager incrementalCachesManager = this;
        boolean bl = false;
        $this$inputSnapshotsCacheDir_u24lambda_u2d1.mkdirs();
        incrementalCachesManager.inputSnapshotsCacheDir = object;
        object = new File(cachesRootDir, "lookups");
        $this$inputSnapshotsCacheDir_u24lambda_u2d1 = object;
        incrementalCachesManager = this;
        boolean bl2 = false;
        ((File)$this$lookupCacheDir_u24lambda_u2d2).mkdirs();
        incrementalCachesManager.lookupCacheDir = object;
        $this$lookupCacheDir_u24lambda_u2d2 = object = new InputsCache(this.inputSnapshotsCacheDir, this.reporter, this.pathConverter);
        incrementalCachesManager = this;
        boolean bl3 = false;
        this.registerCache((BasicMapsOwner)$this$inputsCache_u24lambda_u2d3);
        incrementalCachesManager.inputsCache = object;
        $this$inputsCache_u24lambda_u2d3 = object = new LookupStorage(this.lookupCacheDir, this.pathConverter, storeFullFqNamesInLookupCache, trackChangesInLookupCache);
        incrementalCachesManager = this;
        boolean bl4 = false;
        this.registerCache((BasicMapsOwner)$this$lookupCache_u24lambda_u2d4);
        incrementalCachesManager.lookupCache = object;
    }

    public /* synthetic */ IncrementalCachesManager(File file2, File file3, ICReporter iCReporter, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(file2, file3, iCReporter, bl, bl2);
    }

    @NotNull
    protected final ICReporter getReporter() {
        return this.reporter;
    }

    @NotNull
    public final IncrementalFileToPathConverter getPathConverter() {
        return this.pathConverter;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public final boolean isSuccessfulyClosed() {
        return this.isSuccessfulyClosed;
    }

    public final void setSuccessfulyClosed(boolean bl) {
        this.isSuccessfulyClosed = bl;
    }

    protected final synchronized <T extends BasicMapsOwner> void registerCache(@NotNull T $this$registerCache) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$registerCache, (String)"<this>");
        boolean bl2 = bl = !this.isClosed;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Attempted to add new cache into closed storage.";
            throw new AssertionError((Object)string2);
        }
        this.caches.add($this$registerCache);
    }

    @NotNull
    public final InputsCache getInputsCache() {
        return this.inputsCache;
    }

    @NotNull
    public final LookupStorage getLookupCache() {
        return this.lookupCache;
    }

    @NotNull
    public abstract PlatformCache getPlatformCache();

    public final synchronized boolean close(boolean flush2) {
        if (this.isClosed) {
            return this.isSuccessfulyClosed;
        }
        this.isSuccessfulyClosed = true;
        for (BasicMapsOwner cache2 : this.caches) {
            if (flush2) {
                try {
                    cache2.flush(false);
                }
                catch (Throwable e) {
                    this.isSuccessfulyClosed = false;
                    this.reporter.report((Function0<String>)((Function0)new Function0<String>(cache2, e){
                        final /* synthetic */ BasicMapsOwner $cache;
                        final /* synthetic */ Throwable $e;
                        {
                            this.$cache = $cache;
                            this.$e = $e;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Exception when flushing cache " + this.$cache.getClass() + ": " + this.$e;
                        }
                    }));
                }
            }
            try {
                cache2.close();
            }
            catch (Throwable e) {
                this.isSuccessfulyClosed = false;
                this.reporter.report((Function0<String>)((Function0)new Function0<String>(cache2, e){
                    final /* synthetic */ BasicMapsOwner $cache;
                    final /* synthetic */ Throwable $e;
                    {
                        this.$cache = $cache;
                        this.$e = $e;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Exception when closing cache " + this.$cache.getClass() + ": " + this.$e;
                    }
                }));
            }
        }
        this.isClosed = true;
        return this.isSuccessfulyClosed;
    }

    public static /* synthetic */ boolean close$default(IncrementalCachesManager incrementalCachesManager, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: close");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return incrementalCachesManager.close(bl);
    }
}

