/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.InheritanceImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ScopedClassHierarchy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiSearchScopeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class JavaClassSupersImpl
extends JavaClassSupers {
    private static final Logger LOG = Logger.getInstance(JavaClassSupersImpl.class);
    private static final Set<String> ourReportedInconsistencies = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    @Nullable
    public PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope2, @NotNull PsiSubstitutor derivedSubstitutor) {
        PsiType lowerBound;
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(0);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(2);
        }
        if (derivedSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(3);
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        List<PsiType> bounds = null;
        if (superClass instanceof InferenceVariable) {
            bounds = ((InferenceVariable)superClass).getBounds(InferenceBound.LOWER);
        } else if (superClass instanceof PsiTypeParameter && (lowerBound = TypeConversionUtil.getInferredLowerBoundForSynthetic((PsiTypeParameter)superClass)) != null) {
            bounds = Collections.singletonList(lowerBound);
        }
        if (bounds != null) {
            for (PsiType lowerBound2 : bounds) {
                PsiSubstitutor substitutor2;
                if (lowerBound2 == null || (substitutor2 = JavaClassSupersImpl.processLowerBound(lowerBound2, derivedClass, scope2, derivedSubstitutor)) == null) continue;
                return substitutor2;
            }
        }
        return derivedClass instanceof PsiTypeParameter ? JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)derivedClass, scope2, superClass, (Set<? super PsiTypeParameter>)new THashSet(), derivedSubstitutor) : JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, derivedClass, scope2, derivedSubstitutor);
    }

    private static PsiSubstitutor processLowerBound(@NotNull PsiType lowerBound, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope2, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (lowerBound == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(4);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(6);
        }
        if (derivedSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(7);
        }
        if (lowerBound instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)lowerBound).resolveGenerics();
            PsiClass boundClass = result2.getElement();
            if (boundClass != null) {
                if (boundClass.equals(derivedClass)) {
                    return derivedSubstitutor;
                }
                PsiSubstitutor substitutor2 = JavaClassSupersImpl.getSuperSubstitutorWithCaching(boundClass, derivedClass, scope2, result2.getSubstitutor());
                if (substitutor2 != null) {
                    return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor2, boundClass);
                }
            }
        } else if (lowerBound instanceof PsiIntersectionType) {
            for (PsiType bound : ((PsiIntersectionType)lowerBound).getConjuncts()) {
                PsiSubstitutor substitutor3 = JavaClassSupersImpl.processLowerBound(bound, derivedClass, scope2, derivedSubstitutor);
                if (substitutor3 == null) continue;
                return substitutor3;
            }
        } else if (lowerBound instanceof PsiCapturedWildcardType) {
            return JavaClassSupersImpl.processLowerBound(((PsiCapturedWildcardType)lowerBound).getUpperBound(), derivedClass, scope2, derivedSubstitutor);
        }
        return null;
    }

    @Nullable
    private static PsiSubstitutor getSuperSubstitutorWithCaching(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope resolveScope, @NotNull PsiSubstitutor derivedSubstitutor) {
        PsiSubstitutor substitutor2;
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(8);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(9);
        }
        if (resolveScope == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(10);
        }
        if (derivedSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(11);
        }
        if ((substitutor2 = ScopedClassHierarchy.getSuperClassSubstitutor(derivedClass, resolveScope, superClass)) == null) {
            return null;
        }
        if (PsiUtil.isRawSubstitutor(derivedClass, derivedSubstitutor)) {
            return JavaClassSupersImpl.createRawSubstitutor(superClass);
        }
        return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor2, superClass);
    }

    @NotNull
    static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass superClass) {
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(12);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(superClass.getProject()).createRawSubstitutor(superClass);
        if (psiSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(13);
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiSubstitutor composeSubstitutors(PsiSubstitutor outer, PsiSubstitutor inner, PsiClass onClass) {
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        Map<PsiTypeParameter, PsiType> outerMap = outer.getSubstitutionMap();
        Map<PsiTypeParameter, PsiType> innerMap = inner.getSubstitutionMap();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(onClass)) {
            PsiType targetType;
            PsiClass paramCandidate;
            if (!outerMap.containsKey(parameter) && !innerMap.containsKey(parameter)) continue;
            final PsiType innerType = inner.substitute(parameter);
            PsiClass psiClass = paramCandidate = PsiCapturedWildcardType.isCapture() ? PsiUtil.resolveClassInClassTypeOnly(innerType) : null;
            if (paramCandidate instanceof PsiTypeParameter && paramCandidate != parameter) {
                targetType = outer.substituteWithBoundsPromotion((PsiTypeParameter)paramCandidate);
                if (targetType != null && innerType.getAnnotations().length > 0) {
                    final PsiAnnotation[] typeAnnotations = targetType.getAnnotations();
                    targetType = targetType.annotate(new TypeAnnotationProvider(){

                        @Override
                        public PsiAnnotation @NotNull [] getAnnotations() {
                            PsiAnnotation[] psiAnnotationArray = ArrayUtil.mergeArrays(innerType.getAnnotations(), typeAnnotations);
                            if (psiAnnotationArray == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return psiAnnotationArray;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl$1", "getAnnotations"));
                        }
                    });
                }
            } else {
                targetType = outer.substitute(innerType);
            }
            answer = answer.put(parameter, targetType);
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(14);
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiSubstitutor processTypeParameter(PsiTypeParameter parameter, GlobalSearchScope scope2, PsiClass superClass, Set<? super PsiTypeParameter> visited2, PsiSubstitutor derivedSubstitutor) {
        if (parameter.getManager().areElementsEquivalent(parameter, superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        if (!visited2.add(parameter)) {
            return null;
        }
        for (PsiClassType type2 : parameter.getExtendsListTypes()) {
            PsiSubstitutor answer;
            PsiClassType.ClassResolveResult result2 = type2.resolveGenerics();
            PsiClass psiClass = result2.getElement();
            if (psiClass == null) continue;
            if (psiClass instanceof PsiTypeParameter) {
                answer = JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)psiClass, scope2, superClass, visited2, derivedSubstitutor);
                if (answer == null) continue;
                return answer;
            }
            answer = JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, psiClass, scope2, result2.getSubstitutor());
            if (answer == null) continue;
            return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, answer, superClass);
        }
        return null;
    }

    @Override
    public void reportHierarchyInconsistency(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass) {
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(15);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(16);
        }
        if (!ourReportedInconsistencies.add(derivedClass.getQualifiedName() + "/" + superClass.getQualifiedName()) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final StringBuilder msg2 = new StringBuilder("superClassSubstitutor requested when derived doesn't extend super:\n");
        msg2.append("Super: " + JavaClassSupersImpl.classInfo(superClass));
        msg2.append("Derived: " + JavaClassSupersImpl.classInfo(derivedClass));
        msg2.append("isInheritor: via util=" + InheritanceUtil.isInheritorOrSelf(derivedClass, superClass, true) + ", directly=" + derivedClass.isInheritor(superClass, true) + "\n");
        msg2.append("Super in derived's scope: " + PsiSearchScopeUtil.isInScope(derivedClass.getResolveScope(), (PsiElement)superClass) + "\n");
        if (!InheritanceUtil.processSupers(derivedClass, false, s -> s != superClass)) {
            msg2.append("Plain derived's supers contain Super\n");
        }
        msg2.append("Hierarchy:\n");
        new ScopedClassHierarchy(derivedClass, derivedClass.getResolveScope()){

            @Override
            void visitType(@NotNull PsiClassType type2, Map<PsiClass, PsiClassType.ClassResolveResult> map) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiClass eachClass = type2.resolve();
                msg2.append("  each: ");
                msg2.append(eachClass == null ? "unresolved " + type2 : JavaClassSupersImpl.classInfo(eachClass));
                super.visitType(type2, map);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl$2", "visitType"));
            }
        }.visitType(JavaPsiFacade.getElementFactory(derivedClass.getProject()).createType(derivedClass, PsiSubstitutor.EMPTY), new HashMap<PsiClass, PsiClassType.ClassResolveResult>());
        LOG.error(msg2);
    }

    @NotNull
    private static String classInfo(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(17);
        }
        String s = aClass.getQualifiedName() + "(" + aClass.getClass().getName() + "; " + PsiUtilCore.getVirtualFile(aClass) + ");\n";
        s = s + "    extends: ";
        for (PsiClassType type2 : aClass.getExtendsListTypes()) {
            s = s + "    " + type2 + " (" + type2.getClass().getName() + "; " + type2.resolve() + ") ";
        }
        s = s + "\n    implements: ";
        for (PsiClassType type2 : aClass.getImplementsListTypes()) {
            s = s + "    " + type2 + " (" + type2.getClass().getName() + "; " + type2.resolve() + ") ";
        }
        String string2 = s + "\n";
        if (string2 == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(18);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerBound";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "composeSubstitutors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "classInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processLowerBound";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSuperSubstitutorWithCaching";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportHierarchyInconsistency";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "classInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

