/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J$\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory;", "()V", "convertToIr", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$BackendInput;", "input", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$IrConversionInput;", "generateMultifileClass", "", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "multifileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "generatePackage", "packageFqName", "ktFiles", "getModuleChunkBackendInput", "wholeBackendInput", "sourceFiles", "invokeCodegen", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$CodegenInput;", "invokeLowerings", "DummyOldCodegenInput", "OldBackendInput", "backend"})
public final class DefaultCodegenFactory
implements CodegenFactory {
    @NotNull
    public static final DefaultCodegenFactory INSTANCE = new DefaultCodegenFactory();

    private DefaultCodegenFactory() {
    }

    @Override
    @NotNull
    public CodegenFactory.BackendInput convertToIr(@NotNull CodegenFactory.IrConversionInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new OldBackendInput(input.getFiles());
    }

    @Override
    @NotNull
    public CodegenFactory.BackendInput getModuleChunkBackendInput(@NotNull CodegenFactory.BackendInput wholeBackendInput, @NotNull Collection<? extends KtFile> sourceFiles2) {
        Intrinsics.checkNotNullParameter((Object)wholeBackendInput, (String)"wholeBackendInput");
        Intrinsics.checkNotNullParameter(sourceFiles2, (String)"sourceFiles");
        return new OldBackendInput(sourceFiles2);
    }

    @Override
    @NotNull
    public CodegenFactory.CodegenInput invokeLowerings(@NotNull GenerationState state, @NotNull CodegenFactory.BackendInput input) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        OldBackendInput cfr_ignored_0 = (OldBackendInput)input;
        MultiMap<FqName, KtFile> filesInPackages = new MultiMap<FqName, KtFile>();
        MultiMap<FqName, KtFile> filesInMultifileClasses = new MultiMap<FqName, KtFile>();
        for (KtFile ktFile : ((OldBackendInput)input).getKtFiles()) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), ktFile);
                continue;
            }
            filesInPackages.putValue(ktFile.getPackageFqName(), ktFile);
        }
        HashSet obsoleteMultifileClasses = new HashSet(state.getObsoleteMultifileClasses());
        Set set = filesInMultifileClasses.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"filesInMultifileClasses.keySet()");
        for (FqName multifileClassFqName : SetsKt.plus(set, (Iterable)obsoleteMultifileClasses)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            Intrinsics.checkNotNullExpressionValue((Object)multifileClassFqName, (String)"multifileClassFqName");
            Collection collection = filesInMultifileClasses.get(multifileClassFqName);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"filesInMultifileClasses.get(multifileClassFqName)");
            this.generateMultifileClass(state, multifileClassFqName, collection);
        }
        HashSet hashSet = new HashSet(state.getPackagesWithObsoleteParts());
        Set set2 = hashSet;
        Set set3 = filesInPackages.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"filesInPackages.keySet()");
        for (FqName packageFqName : SetsKt.plus((Set)set2, (Iterable)set3)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            Intrinsics.checkNotNullExpressionValue((Object)packageFqName, (String)"packageFqName");
            Collection collection = filesInPackages.get(packageFqName);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"filesInPackages.get(packageFqName)");
            this.generatePackage(state, packageFqName, collection);
        }
        return new DummyOldCodegenInput(state);
    }

    @Override
    public void invokeCodegen(@NotNull CodegenFactory.CodegenInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
    }

    private final void generateMultifileClass(GenerationState state, FqName multifileClassFqName, Collection<? extends KtFile> files2) {
        state.getFactory().forMultifileClass(multifileClassFqName, files2).generate();
    }

    public final void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        state.getFactory().forPackage(packageFqName, ktFiles).generate();
    }

    @Override
    public void generateModule(@NotNull GenerationState state, @NotNull CodegenFactory.BackendInput input) {
        CodegenFactory.DefaultImpls.generateModule(this, state, input);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory$OldBackendInput;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$BackendInput;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Ljava/util/Collection;)V", "getKtFiles", "()Ljava/util/Collection;", "backend"})
    private static final class OldBackendInput
    implements CodegenFactory.BackendInput {
        @NotNull
        private final Collection<KtFile> ktFiles;

        public OldBackendInput(@NotNull Collection<? extends KtFile> ktFiles) {
            Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
            this.ktFiles = ktFiles;
        }

        @NotNull
        public final Collection<KtFile> getKtFiles() {
            return this.ktFiles;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory$DummyOldCodegenInput;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory$CodegenInput;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "backend"})
    private static final class DummyOldCodegenInput
    implements CodegenFactory.CodegenInput {
        @NotNull
        private final GenerationState state;

        public DummyOldCodegenInput(@NotNull GenerationState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.state = state;
        }

        @Override
        @NotNull
        public GenerationState getState() {
            return this.state;
        }
    }
}

