/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.linkerissues;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrDeserializationException;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/IrSymbolTypeMismatchException;", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/IrDeserializationException;", "expected", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actual", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "getActual", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getExpected", "()Ljava/lang/Class;", "ir.serialization.common"})
public final class IrSymbolTypeMismatchException
extends IrDeserializationException {
    @NotNull
    private final Class<? extends IrSymbol> expected;
    @NotNull
    private final IrSymbol actual;

    public IrSymbolTypeMismatchException(@NotNull Class<? extends IrSymbol> expected, @NotNull IrSymbol actual) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        StringBuilder stringBuilder2 = new StringBuilder().append("The symbol of unexpected type encountered during IR deserialization: ").append(actual.getClass().getSimpleName()).append(", ");
        Object object = actual.getSignature();
        if (object == null || (object = ((IdSignature)object).render()) == null) {
            object = actual.toString();
        }
        super(stringBuilder2.append((String)object).append(". ").append(expected.getSimpleName()).append(" is expected.").toString(), (DefaultConstructorMarker)null);
        this.expected = expected;
        this.actual = actual;
    }

    @NotNull
    public final Class<? extends IrSymbol> getExpected() {
        return this.expected;
    }

    @NotNull
    public final IrSymbol getActual() {
        return this.actual;
    }
}

