/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.DefaultGradleProperties;
import org.gradle.initialization.Environment;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.internal.Cast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGradlePropertiesLoader.class);
    private final StartParameterInternal startParameter;
    private final Environment environment;

    public DefaultGradlePropertiesLoader(StartParameterInternal startParameter, Environment environment) {
        this.startParameter = startParameter;
        this.environment = environment;
    }

    @Override
    public GradleProperties loadGradleProperties(File rootDir) {
        return this.loadProperties(rootDir);
    }

    GradleProperties loadProperties(File rootDir) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        HashMap<String, Object> overrideProperties = new HashMap<String, Object>();
        this.addGradlePropertiesFrom(this.startParameter.getGradleHomeDir(), defaultProperties);
        this.addGradlePropertiesFrom(rootDir, defaultProperties);
        this.addGradlePropertiesFrom(this.startParameter.getGradleUserHomeDir(), overrideProperties);
        this.setSystemPropertiesFromGradleProperties(defaultProperties);
        this.setSystemPropertiesFromGradleProperties(overrideProperties);
        System.getProperties().putAll((Map<?, ?>)this.startParameter.getSystemPropertiesArgs());
        overrideProperties.putAll(this.projectPropertiesFromEnvironmentVariables());
        overrideProperties.putAll(this.projectPropertiesFromSystemProperties());
        overrideProperties.putAll(this.startParameter.getProjectProperties());
        return new DefaultGradleProperties(defaultProperties, overrideProperties);
    }

    private void addGradlePropertiesFrom(File dir, Map<String, Object> target) {
        Map<String, String> propertiesFile = this.environment.propertiesFile(new File(dir, "gradle.properties"));
        if (propertiesFile != null) {
            target.putAll(propertiesFile);
        }
    }

    private Map<String, String> projectPropertiesFromSystemProperties() {
        Map<String, String> systemProjectProperties = this.byPrefix("org.gradle.project.", this.environment.getSystemProperties());
        LOGGER.debug("Found system project properties: {}", systemProjectProperties.keySet());
        return systemProjectProperties;
    }

    private Map<String, String> projectPropertiesFromEnvironmentVariables() {
        Map<String, String> envProjectProperties = this.byPrefix("ORG_GRADLE_PROJECT_", this.environment.getVariables());
        LOGGER.debug("Found env project properties: {}", envProjectProperties.keySet());
        return envProjectProperties;
    }

    private Map<String, String> byPrefix(String prefix, Environment.Properties properties) {
        return DefaultGradlePropertiesLoader.mapKeysRemovingPrefix(prefix, properties.byNamePrefix(prefix));
    }

    private void setSystemPropertiesFromGradleProperties(Map<String, Object> properties) {
        if (properties.isEmpty()) {
            return;
        }
        String prefix = "systemProp.";
        int prefixLength = prefix.length();
        for (String key : properties.keySet()) {
            if (key.length() <= prefixLength || !key.startsWith(prefix)) continue;
            System.setProperty(key.substring(prefixLength), (String)Cast.uncheckedNonnullCast((Object)properties.get(key)));
        }
    }

    private static Map<String, String> mapKeysRemovingPrefix(String prefix, Map<String, String> mapWithPrefix) {
        HashMap<String, String> mapWithoutPrefix = new HashMap<String, String>(mapWithPrefix.size());
        for (Map.Entry<String, String> entry : mapWithPrefix.entrySet()) {
            mapWithoutPrefix.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return mapWithoutPrefix;
    }
}

