/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.reflect.validation.UserManualReference;

public class DefaultNodeValidator
implements NodeValidator {
    @Override
    public boolean hasValidationProblems(LocalTaskNode node) {
        WorkValidationContext validationContext = this.validateNode(node);
        List problems = validationContext.getProblems();
        this.logWarnings(problems);
        this.reportErrors(problems, node.getTask(), validationContext);
        return !problems.isEmpty();
    }

    private WorkValidationContext validateNode(LocalTaskNode node) {
        WorkValidationContext validationContext = node.getValidationContext();
        Class taskType = GeneratedSubclasses.unpackType((Object)node.getTask());
        TypeValidationContext taskValidationContext = validationContext.forType(taskType, false);
        node.getTaskProperties().validateType(taskValidationContext);
        return validationContext;
    }

    private void logWarnings(List<TypeValidationProblem> problems) {
        problems.stream().filter(problem -> ((Severity)problem.getSeverity()).isWarning()).forEach(problem -> {
            UserManualReference userManualReference = problem.getUserManualReference();
            String warning = TypeValidationProblemRenderer.convertToSingleLine((String)TypeValidationProblemRenderer.renderMinimalInformationAbout((TypeValidationProblem)problem, (boolean)false, (boolean)false));
            ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle8().withUserManual(userManualReference.getId(), userManualReference.getSection()).nagUser();
        });
    }

    private void reportErrors(List<TypeValidationProblem> problems, TaskInternal task, WorkValidationContext validationContext) {
        ImmutableSet uniqueErrors = (ImmutableSet)problems.stream().filter(problem -> !((Severity)problem.getSeverity()).isWarning()).map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(ImmutableSet.toImmutableSet());
        if (!uniqueErrors.isEmpty()) {
            throw WorkValidationException.forProblems((Collection)uniqueErrors).withSummaryForContext(task.toString(), validationContext).get();
        }
    }
}

