/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.CSSStyleSheetList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.util.Visitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class StyleSheetList
implements CSSStyleSheetList<AbstractCSSRule>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<AbstractCSSStyleSheet> list;
    private final MyDOMStringList styleSheetSets = new MyDOMStringList();
    private String preferredStyleSheetSet = "";
    private boolean needsUpdate;

    protected StyleSheetList(int n) {
        this.list = new ArrayList<AbstractCSSStyleSheet>(n);
        this.needsUpdate = true;
    }

    @Override
    public int getLength() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.list.size();
    }

    @Override
    public AbstractCSSStyleSheet item(int n) {
        if (this.needsUpdate) {
            this.update();
        }
        if (n >= this.list.size() || n < 0) {
            return null;
        }
        return this.list.get(n);
    }

    public DOMStringList getStyleSheetSets() {
        return this.styleSheetSets;
    }

    @Override
    public void acceptStyleRuleVisitor(Visitor<CSSStyleRule> visitor) {
        if (this.needsUpdate) {
            this.update();
        }
        for (AbstractCSSStyleSheet abstractCSSStyleSheet : this.list) {
            abstractCSSStyleSheet.acceptStyleRuleVisitor(visitor);
        }
    }

    @Override
    public void acceptDeclarationRuleVisitor(Visitor<CSSDeclarationRule> visitor) {
        if (this.needsUpdate) {
            this.update();
        }
        for (AbstractCSSStyleSheet abstractCSSStyleSheet : this.list) {
            abstractCSSStyleSheet.acceptDeclarationRuleVisitor(visitor);
        }
    }

    @Override
    public void acceptDescriptorRuleVisitor(Visitor<CSSDeclarationRule> visitor) {
        if (this.needsUpdate) {
            this.update();
        }
        for (AbstractCSSStyleSheet abstractCSSStyleSheet : this.list) {
            abstractCSSStyleSheet.acceptDescriptorRuleVisitor(visitor);
        }
    }

    public void add(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        if (abstractCSSStyleSheet != null) {
            this.list.add(abstractCSSStyleSheet);
            String string = abstractCSSStyleSheet.getTitle();
            if (string != null && string.length() > 0) {
                this.styleSheetSets.add(string);
                if (!abstractCSSStyleSheet.getDisabled() && this.preferredStyleSheetSet.length() == 0) {
                    this.preferredStyleSheetSet = string;
                }
            }
        }
    }

    public String getPreferredStyleSheetSet() {
        if (this.needsUpdate) {
            this.update();
        }
        return this.preferredStyleSheetSet;
    }

    public void remove(String string) {
        Iterator<AbstractCSSStyleSheet> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            CSSStyleSheet cSSStyleSheet = iterator.next();
            if (!string.equalsIgnoreCase(cSSStyleSheet.getTitle())) continue;
            iterator.remove();
        }
    }

    public boolean remove(StyleSheet styleSheet) {
        return this.list.remove(styleSheet);
    }

    protected Iterator<AbstractCSSStyleSheet> iterator() {
        return this.list.iterator();
    }

    protected void clear() {
        this.list.clear();
    }

    protected boolean needsUpdate() {
        return this.needsUpdate;
    }

    protected void setNeedsUpdate(boolean bl) {
        this.needsUpdate = bl;
    }

    protected void update() {
        this.styleSheetSets.clear();
        this.clear();
    }

    protected abstract boolean hasErrorsOrWarnings();

    class MyDOMStringList
    implements DOMStringList {
        private final TreeSet<String> titleSet = new TreeSet();

        MyDOMStringList() {
        }

        @Override
        public String item(int n) {
            if (StyleSheetList.this.needsUpdate) {
                StyleSheetList.this.update();
            }
            if (n >= this.titleSet.size() || n < 0) {
                return null;
            }
            String string = null;
            int n2 = 0;
            for (String string2 : this.titleSet) {
                if (n2 == n) {
                    string = string2;
                    break;
                }
                ++n2;
            }
            return string;
        }

        @Override
        public int getLength() {
            if (StyleSheetList.this.needsUpdate) {
                StyleSheetList.this.update();
            }
            return this.titleSet.size();
        }

        @Override
        public boolean contains(String string) {
            return this.titleSet.contains(string);
        }

        private void add(String string) {
            this.titleSet.add(string);
        }

        private void clear() {
            this.titleSet.clear();
        }
    }
}

