/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.FilterBridge;
import io.sf.carte.echosvg.bridge.FilterPrimitiveBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.FilterChainRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.FloodRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.PadRable8Bit;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFilterElementBridge
extends AnimatableGenericSVGBridge
implements FilterBridge,
ErrorConstants {
    protected static final Color TRANSPARENT_BLACK = new Color(0, true);

    @Override
    public String getLocalName() {
        return "filter";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode) {
        Rectangle2D rectangle2D = SVGUtilities.convertFilterChainRegion(element, element2, graphicsNode, bridgeContext);
        if (rectangle2D == null) {
            return null;
        }
        Filter filter = graphicsNode.getGraphicsNodeRable(true);
        filter = new PadRable8Bit(filter, rectangle2D, PadMode.ZERO_PAD);
        FilterChainRable8Bit filterChainRable8Bit = new FilterChainRable8Bit(filter, rectangle2D);
        float[] fArray = SVGUtilities.convertFilterRes(element, bridgeContext);
        filterChainRable8Bit.setFilterResolutionX((int)fArray[0]);
        filterChainRable8Bit.setFilterResolutionY((int)fArray[1]);
        HashMap<String, Filter> hashMap = new HashMap<String, Filter>(11);
        hashMap.put("SourceGraphic", filter);
        Filter filter2 = SVGFilterElementBridge.buildFilterPrimitives(element, rectangle2D, element2, graphicsNode, filter, hashMap, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        if (filter2 == filter) {
            filter2 = SVGFilterElementBridge.createEmptyFilter(element, rectangle2D, element2, graphicsNode, bridgeContext);
        }
        filterChainRable8Bit.setSource(filter2);
        return filterChainRable8Bit;
    }

    protected static Filter createEmptyFilter(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Rectangle2D rectangle2D2 = SVGUtilities.convertFilterPrimitiveRegion(null, element, element2, graphicsNode, rectangle2D, rectangle2D, bridgeContext);
        return new FloodRable8Bit(rectangle2D2, (Paint)TRANSPARENT_BLACK);
    }

    protected static Filter buildFilterPrimitives(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, Filter filter, Map<String, Filter> map, BridgeContext bridgeContext) {
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        Filter filter2;
        while ((filter2 = SVGFilterElementBridge.buildLocalFilterPrimitives(element, rectangle2D, element2, graphicsNode, filter, map, bridgeContext)) == filter) {
            String string = XLinkSupport.getXLinkHref((Element)element);
            if (string.length() == 0) {
                return filter;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURLObject(), string);
            if (linkedList.contains(parsedURL)) {
                throw new BridgeException(bridgeContext, element, "xlink.href.circularDependencies", new Object[]{string});
            }
            if ((element = bridgeContext.getReferencedElement(element, string)) == null) {
                return filter;
            }
            linkedList.add(parsedURL);
        }
        return filter2;
    }

    protected static Filter buildLocalFilterPrimitives(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, Filter filter, Map<String, Filter> map, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            Bridge bridge;
            if (node.getNodeType() != 1 || (bridge = bridgeContext.getBridge(element3 = (Element)node)) == null || !(bridge instanceof FilterPrimitiveBridge)) continue;
            FilterPrimitiveBridge filterPrimitiveBridge = (FilterPrimitiveBridge)bridge;
            Filter filter2 = filterPrimitiveBridge.createFilter(bridgeContext, element3, element2, graphicsNode, filter, rectangle2D, map);
            if (filter2 == null) {
                return null;
            }
            filter = filter2;
        }
        return filter;
    }
}

