/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.ext.awt.geom.RectListManager;
import io.sf.carte.echosvg.gvt.renderer.ImageRenderer;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;

public class RepaintManager {
    static final int COPY_OVERHEAD = 10000;
    static final int COPY_LINE_OVERHEAD = 10;
    protected ImageRenderer renderer;

    public RepaintManager(ImageRenderer imageRenderer) {
        this.renderer = imageRenderer;
    }

    public Collection<Rectangle> updateRendering(Collection<Shape> collection) throws InterruptedException {
        this.renderer.flush(collection);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(collection.size());
        AffineTransform affineTransform = this.renderer.getTransform();
        for (Shape shape : collection) {
            shape = affineTransform.createTransformedShape(shape);
            Rectangle2D rectangle2D = shape.getBounds2D();
            int n = (int)Math.floor(rectangle2D.getX());
            int n2 = (int)Math.floor(rectangle2D.getY());
            int n3 = (int)Math.ceil(rectangle2D.getX() + rectangle2D.getWidth());
            int n4 = (int)Math.ceil(rectangle2D.getY() + rectangle2D.getHeight());
            Rectangle rectangle = new Rectangle(n - 1, n2 - 1, n3 - n + 3, n4 - n2 + 3);
            arrayList.add(rectangle);
        }
        RectListManager rectListManager = null;
        try {
            rectListManager = new RectListManager(arrayList);
            rectListManager.mergeRects(10000, 10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.renderer.repaint(rectListManager);
        return rectListManager;
    }

    public void setupRenderer(AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.renderer.setTransform(affineTransform);
        this.renderer.setDoubleBuffered(bl);
        this.renderer.updateOffScreen(n, n2);
        this.renderer.clearOffScreen();
    }

    public BufferedImage getOffScreen() {
        return this.renderer.getOffScreen();
    }
}

