/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractColorInterpolationRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.ColorMatrixRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.rendered.ColorMatrixRed;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;

public final class ColorMatrixRable8Bit
extends AbstractColorInterpolationRable
implements ColorMatrixRable {
    private static float[][] MATRIX_LUMINANCE_TO_ALPHA = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.2125f, 0.7154f, 0.0721f, 0.0f, 0.0f}};
    private int type;
    private float[][] matrix;

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public float[][] getMatrix() {
        return this.matrix;
    }

    private ColorMatrixRable8Bit() {
    }

    public static ColorMatrixRable buildMatrix(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException();
        }
        if (fArray.length != 4) {
            throw new IllegalArgumentException();
        }
        float[][] fArrayArray = new float[4][];
        for (int i = 0; i < 4; ++i) {
            float[] fArray2 = fArray[i];
            if (fArray2 == null) {
                throw new IllegalArgumentException();
            }
            if (fArray2.length != 5) {
                throw new IllegalArgumentException();
            }
            fArrayArray[i] = new float[5];
            for (int j = 0; j < 5; ++j) {
                fArrayArray[i][j] = fArray2[j];
            }
        }
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 0;
        colorMatrixRable8Bit.matrix = fArrayArray;
        return colorMatrixRable8Bit;
    }

    public static ColorMatrixRable buildSaturate(float f) {
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 1;
        colorMatrixRable8Bit.matrix = new float[][]{{0.213f + 0.787f * f, 0.715f - 0.715f * f, 0.072f - 0.072f * f, 0.0f, 0.0f}, {0.213f - 0.213f * f, 0.715f + 0.285f * f, 0.072f - 0.072f * f, 0.0f, 0.0f}, {0.213f - 0.213f * f, 0.715f - 0.715f * f, 0.072f + 0.928f * f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
        return colorMatrixRable8Bit;
    }

    public static ColorMatrixRable buildHueRotate(float f) {
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 2;
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = 0.213f + f2 * 0.787f - f3 * 0.213f;
        float f5 = 0.213f - f2 * 0.212f + f3 * 0.143f;
        float f6 = 0.213f - f2 * 0.213f - f3 * 0.787f;
        float f7 = 0.715f - f2 * 0.715f - f3 * 0.715f;
        float f8 = 0.715f + f2 * 0.285f + f3 * 0.14f;
        float f9 = 0.715f - f2 * 0.715f + f3 * 0.715f;
        float f10 = 0.072f - f2 * 0.072f + f3 * 0.928f;
        float f11 = 0.072f - f2 * 0.072f - f3 * 0.283f;
        float f12 = 0.072f + f2 * 0.928f + f3 * 0.072f;
        colorMatrixRable8Bit.matrix = new float[][]{{f4, f7, f10, 0.0f, 0.0f}, {f5, f8, f11, 0.0f, 0.0f}, {f6, f9, f12, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
        return colorMatrixRable8Bit;
    }

    public static ColorMatrixRable buildLuminanceToAlpha() {
        ColorMatrixRable8Bit colorMatrixRable8Bit = new ColorMatrixRable8Bit();
        colorMatrixRable8Bit.type = 3;
        colorMatrixRable8Bit.matrix = MATRIX_LUMINANCE_TO_ALPHA;
        return colorMatrixRable8Bit;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        return new ColorMatrixRed(this.convertSourceCS(renderedImage), this.matrix);
    }
}

