/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class RectManager
extends LengthManager {
    protected int orientation;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case FUNCTION: {
                if (!lexicalUnit.getFunctionName().equalsIgnoreCase("rect")) break;
            }
            case RECT_FUNCTION: {
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                try {
                    Value value = this.createRectComponent(lexicalUnit2);
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw this.createMalformedRectDOMException();
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    Value value2 = this.createRectComponent(lexicalUnit2);
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw this.createMalformedRectDOMException();
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    Value value3 = this.createRectComponent(lexicalUnit2);
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw this.createMalformedRectDOMException();
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    Value value4 = this.createRectComponent(lexicalUnit2);
                    return new RectValue(value, value2, value3, value4);
                }
                catch (CSSProxyValueException cSSProxyValueException) {
                    return this.createLexicalValue(lexicalUnit);
                }
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lexicalUnit);
            }
        }
        throw this.createMalformedRectDOMException();
    }

    private Value createRectComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                if (!lexicalUnit.getStringValue().equalsIgnoreCase("auto")) break;
                return ValueConstants.AUTO_VALUE;
            }
            case DIMENSION: {
                return this.createLength(lexicalUnit);
            }
            case INTEGER: {
                return new FloatValue(0, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lexicalUnit.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
            case VAR: 
            case ATTR: {
                throw new CSSProxyValueException();
            }
            case CALC: {
                return this.createCalc(lexicalUnit);
            }
            case MATH_FUNCTION: {
                Value value;
                try {
                    value = this.createMathFunction(lexicalUnit, "<length-percentage>");
                }
                catch (Exception exception) {
                    DOMException dOMException = this.createMalformedRectDOMException();
                    dOMException.initCause(exception);
                    throw dOMException;
                }
                return value;
            }
        }
        throw this.createMalformedRectDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() != CSSValue.Type.RECT) {
            return value;
        }
        RectValue rectValue = value.getRectValue();
        this.orientation = 1;
        Value value2 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getTop());
        Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getBottom());
        this.orientation = 0;
        Value value4 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getLeft());
        Value value5 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, rectValue.getRight());
        if (value2 != rectValue.getTop() || value5 != rectValue.getRight() || value3 != rectValue.getBottom() || value4 != rectValue.getLeft()) {
            return new RectValue(value2, value5, value3, value4);
        }
        return value;
    }

    @Override
    protected int getOrientation() {
        return this.orientation;
    }

    private DOMException createMalformedRectDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("malformed.rect", objectArray);
        return new DOMException(12, string);
    }
}

