/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeDataView
extends NativeArrayBufferView {
    private static final long serialVersionUID = 1427967607557438968L;
    public static final String CLASS_NAME = "DataView";
    private static final int Id_constructor = 1;
    private static final int Id_getInt8 = 2;
    private static final int Id_getUint8 = 3;
    private static final int Id_getInt16 = 4;
    private static final int Id_getUint16 = 5;
    private static final int Id_getInt32 = 6;
    private static final int Id_getUint32 = 7;
    private static final int Id_getFloat32 = 8;
    private static final int Id_getFloat64 = 9;
    private static final int Id_setInt8 = 10;
    private static final int Id_setUint8 = 11;
    private static final int Id_setInt16 = 12;
    private static final int Id_setUint16 = 13;
    private static final int Id_setInt32 = 14;
    private static final int Id_setUint32 = 15;
    private static final int Id_setFloat32 = 16;
    private static final int Id_setFloat64 = 17;
    private static final int MAX_PROTOTYPE_ID = 17;

    public NativeDataView() {
    }

    public NativeDataView(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeDataView nativeDataView = new NativeDataView();
        nativeDataView.exportAsJSClass(17, scriptable, bl);
    }

    private static int determinePos(Object[] objectArray) {
        if (NativeDataView.isArg(objectArray, 0)) {
            double d = ScriptRuntime.toNumber(objectArray[0]);
            if (Double.isInfinite(d)) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            return ScriptRuntime.toInt32(d);
        }
        return 0;
    }

    private void rangeCheck(int n, int n2) {
        if (n < 0 || n + n2 > this.byteLength) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
    }

    private static NativeDataView realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeDataView.ensureType(scriptable, NativeDataView.class, idFunctionObject);
    }

    private static NativeDataView js_constructor(Object[] objectArray) {
        int n;
        int n2;
        if (!NativeDataView.isArg(objectArray, 0) || !(objectArray[0] instanceof NativeArrayBuffer)) {
            throw ScriptRuntime.constructError("TypeError", "Missing parameters");
        }
        NativeArrayBuffer nativeArrayBuffer = (NativeArrayBuffer)objectArray[0];
        if (NativeDataView.isArg(objectArray, 1)) {
            double d = ScriptRuntime.toNumber(objectArray[1]);
            if (Double.isInfinite(d)) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            n2 = ScriptRuntime.toInt32(d);
        } else {
            n2 = 0;
        }
        if (NativeDataView.isArg(objectArray, 2)) {
            double d = ScriptRuntime.toNumber(objectArray[2]);
            if (Double.isInfinite(d)) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            n = ScriptRuntime.toInt32(d);
        } else {
            n = nativeArrayBuffer.getLength() - n2;
        }
        if (n < 0) {
            throw ScriptRuntime.rangeError("length out of range");
        }
        if (n2 < 0 || n2 + n > nativeArrayBuffer.getLength()) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        return new NativeDataView(nativeArrayBuffer, n2, n);
    }

    private Object js_getInt(int n, boolean bl, Object[] objectArray) {
        int n2 = NativeDataView.determinePos(objectArray);
        this.rangeCheck(n2, n);
        boolean bl2 = NativeDataView.isArg(objectArray, 1) && n > 1 && ScriptRuntime.toBoolean(objectArray[1]);
        switch (n) {
            case 1: {
                if (bl) {
                    return ByteIo.readInt8(this.arrayBuffer.buffer, this.offset + n2);
                }
                return ByteIo.readUint8(this.arrayBuffer.buffer, this.offset + n2);
            }
            case 2: {
                if (bl) {
                    return ByteIo.readInt16(this.arrayBuffer.buffer, this.offset + n2, bl2);
                }
                return ByteIo.readUint16(this.arrayBuffer.buffer, this.offset + n2, bl2);
            }
            case 4: {
                return bl ? ByteIo.readInt32(this.arrayBuffer.buffer, this.offset + n2, bl2) : ByteIo.readUint32(this.arrayBuffer.buffer, this.offset + n2, bl2);
            }
        }
        throw new AssertionError();
    }

    private Object js_getFloat(int n, Object[] objectArray) {
        int n2 = NativeDataView.determinePos(objectArray);
        this.rangeCheck(n2, n);
        boolean bl = NativeDataView.isArg(objectArray, 1) && n > 1 && ScriptRuntime.toBoolean(objectArray[1]);
        switch (n) {
            case 4: {
                return ByteIo.readFloat32(this.arrayBuffer.buffer, this.offset + n2, bl);
            }
            case 8: {
                return ByteIo.readFloat64(this.arrayBuffer.buffer, this.offset + n2, bl);
            }
        }
        throw new AssertionError();
    }

    private void js_setInt(int n, boolean bl, Object[] objectArray) {
        int n2 = NativeDataView.determinePos(objectArray);
        if (n2 < 0) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        boolean bl2 = NativeDataView.isArg(objectArray, 2) && n > 1 && ScriptRuntime.toBoolean(objectArray[2]);
        Object object = ScriptRuntime.zeroObj;
        if (objectArray.length > 1) {
            object = objectArray[1];
        }
        switch (n) {
            case 1: {
                if (bl) {
                    int n3 = Conversions.toInt8(object);
                    if (n2 + n > this.byteLength) {
                        throw ScriptRuntime.rangeError("offset out of range");
                    }
                    ByteIo.writeInt8(this.arrayBuffer.buffer, this.offset + n2, n3);
                    break;
                }
                int n4 = Conversions.toUint8(object);
                if (n2 + n > this.byteLength) {
                    throw ScriptRuntime.rangeError("offset out of range");
                }
                ByteIo.writeUint8(this.arrayBuffer.buffer, this.offset + n2, n4);
                break;
            }
            case 2: {
                if (bl) {
                    int n5 = Conversions.toInt16(object);
                    if (n2 + n > this.byteLength) {
                        throw ScriptRuntime.rangeError("offset out of range");
                    }
                    ByteIo.writeInt16(this.arrayBuffer.buffer, this.offset + n2, n5, bl2);
                    break;
                }
                int n6 = Conversions.toUint16(object);
                if (n2 + n > this.byteLength) {
                    throw ScriptRuntime.rangeError("offset out of range");
                }
                ByteIo.writeUint16(this.arrayBuffer.buffer, this.offset + n2, n6, bl2);
                break;
            }
            case 4: {
                if (bl) {
                    int n7 = Conversions.toInt32(object);
                    if (n2 + n > this.byteLength) {
                        throw ScriptRuntime.rangeError("offset out of range");
                    }
                    ByteIo.writeInt32(this.arrayBuffer.buffer, this.offset + n2, n7, bl2);
                    break;
                }
                long l = Conversions.toUint32(object);
                if (n2 + n > this.byteLength) {
                    throw ScriptRuntime.rangeError("offset out of range");
                }
                ByteIo.writeUint32(this.arrayBuffer.buffer, this.offset + n2, l, bl2);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void js_setFloat(int n, Object[] objectArray) {
        int n2 = NativeDataView.determinePos(objectArray);
        if (n2 < 0) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        boolean bl = NativeDataView.isArg(objectArray, 2) && n > 1 && ScriptRuntime.toBoolean(objectArray[2]);
        double d = Double.NaN;
        if (objectArray.length > 1) {
            d = ScriptRuntime.toNumber(objectArray[1]);
        }
        if (n2 + n > this.byteLength) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        switch (n) {
            case 4: {
                ByteIo.writeFloat32(this.arrayBuffer.buffer, this.offset + n2, d, bl);
                break;
            }
            case 8: {
                ByteIo.writeFloat64(this.arrayBuffer.buffer, this.offset + n2, d, bl);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(this.getClassName())) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeDataView.js_constructor(objectArray);
            }
            case 2: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(1, true, objectArray);
            }
            case 3: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(1, false, objectArray);
            }
            case 4: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(2, true, objectArray);
            }
            case 5: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(2, false, objectArray);
            }
            case 6: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(4, true, objectArray);
            }
            case 7: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getInt(4, false, objectArray);
            }
            case 8: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getFloat(4, objectArray);
            }
            case 9: {
                return NativeDataView.realThis(scriptable2, idFunctionObject).js_getFloat(8, objectArray);
            }
            case 10: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(1, true, objectArray);
                return Undefined.instance;
            }
            case 11: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(1, false, objectArray);
                return Undefined.instance;
            }
            case 12: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(2, true, objectArray);
                return Undefined.instance;
            }
            case 13: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(2, false, objectArray);
                return Undefined.instance;
            }
            case 14: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(4, true, objectArray);
                return Undefined.instance;
            }
            case 15: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setInt(4, false, objectArray);
                return Undefined.instance;
            }
            case 16: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setFloat(4, objectArray);
                return Undefined.instance;
            }
            case 17: {
                NativeDataView.realThis(scriptable2, idFunctionObject).js_setFloat(8, objectArray);
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "getInt8";
                break;
            }
            case 3: {
                n2 = 1;
                string = "getUint8";
                break;
            }
            case 4: {
                n2 = 1;
                string = "getInt16";
                break;
            }
            case 5: {
                n2 = 1;
                string = "getUint16";
                break;
            }
            case 6: {
                n2 = 1;
                string = "getInt32";
                break;
            }
            case 7: {
                n2 = 1;
                string = "getUint32";
                break;
            }
            case 8: {
                n2 = 1;
                string = "getFloat32";
                break;
            }
            case 9: {
                n2 = 1;
                string = "getFloat64";
                break;
            }
            case 10: {
                n2 = 2;
                string = "setInt8";
                break;
            }
            case 11: {
                n2 = 2;
                string = "setUint8";
                break;
            }
            case 12: {
                n2 = 2;
                string = "setInt16";
                break;
            }
            case 13: {
                n2 = 2;
                string = "setUint16";
                break;
            }
            case 14: {
                n2 = 2;
                string = "setInt32";
                break;
            }
            case 15: {
                n2 = 2;
                string = "setUint32";
                break;
            }
            case 16: {
                n2 = 2;
                string = "setFloat32";
                break;
            }
            case 17: {
                n2 = 2;
                string = "setFloat64";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(this.getClassName(), n, string, n2);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "getInt8": {
                n = 2;
                break;
            }
            case "getUint8": {
                n = 3;
                break;
            }
            case "getInt16": {
                n = 4;
                break;
            }
            case "getUint16": {
                n = 5;
                break;
            }
            case "getInt32": {
                n = 6;
                break;
            }
            case "getUint32": {
                n = 7;
                break;
            }
            case "getFloat32": {
                n = 8;
                break;
            }
            case "getFloat64": {
                n = 9;
                break;
            }
            case "setInt8": {
                n = 10;
                break;
            }
            case "setUint8": {
                n = 11;
                break;
            }
            case "setInt16": {
                n = 12;
                break;
            }
            case "setUint16": {
                n = 13;
                break;
            }
            case "setInt32": {
                n = 14;
                break;
            }
            case "setUint32": {
                n = 15;
                break;
            }
            case "setFloat32": {
                n = 16;
                break;
            }
            case "setFloat64": {
                n = 17;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

