/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.NumberValue;
import org.w3c.dom.DOMException;

class Unit {
    private short unitType;
    private int exponent;
    private Unit nextUnit = null;

    public Unit() {
        this.unitType = 0;
        this.exponent = 0;
    }

    Unit(short s) {
        this.setUnitType(s);
    }

    public int getExponent() {
        return this.exponent;
    }

    void setExponent(int n) {
        this.exponent = n;
    }

    void incrExponent() {
        ++this.exponent;
    }

    void decrExponent() {
        --this.exponent;
    }

    public short getUnitType() {
        return this.unitType;
    }

    void setUnitType(short s) {
        this.unitType = s;
        this.exponent = s == 0 ? 0 : 1;
    }

    public Unit getNextUnit() {
        return this.nextUnit;
    }

    void setNextUnit(Unit unit) {
        this.nextUnit = unit;
    }

    public float convert(float f, short s) throws DOMException {
        if (this.exponent != 0 && this.unitType != s) {
            double d = NumberValue.floatValueConversion(1.0f, this.unitType, s);
            if (this.exponent > 1) {
                for (int i = 2; i <= this.exponent; ++i) {
                    d *= d;
                }
            } else if (this.exponent < 0) {
                d = 1.0 / d;
                for (int i = -2; i >= this.exponent; --i) {
                    d *= d;
                }
            }
            return (float)((double)f * d);
        }
        return f;
    }
}

