/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class SingleEntryMap
extends MapItem {
    public AtomicValue key;
    public GroundedValue value;

    public SingleEntryMap(AtomicValue key, GroundedValue value) {
        this.key = key;
        this.value = value;
    }

    public AtomicValue getKey() {
        return this.key;
    }

    public GroundedValue getValue() {
        return this.value;
    }

    @Override
    public GroundedValue get(AtomicValue key) {
        return this.key.asMapKey().equals(key.asMapKey()) ? this.value : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public AtomicIterator keys() {
        return SingleAtomicIterator.makeIterator(this.key);
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        ArrayList<KeyValuePair> list = new ArrayList<KeyValuePair>(1);
        list.add(new KeyValuePair(this.key, this.value));
        return list;
    }

    @Override
    public MapItem addEntry(AtomicValue key, GroundedValue value) {
        return this.toHashTrieMap().addEntry(key, value);
    }

    @Override
    public MapItem remove(AtomicValue key) {
        if (this.get(key) == null) {
            return this;
        }
        return new HashTrieMap();
    }

    @Override
    public boolean conforms(AtomicType keyType, SequenceType valueType, TypeHierarchy th) {
        return keyType.matches(this.key, th) && valueType.matches(this.value, th);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return new MapType(this.key.getItemType(), SequenceType.makeSequenceType(SequenceTool.getItemType(this.value, th), SequenceTool.getCardinality(this.value)));
    }

    @Override
    public UType getKeyUType() {
        return this.key.getUType();
    }

    private HashTrieMap toHashTrieMap() {
        HashTrieMap target = new HashTrieMap();
        target.initialPut(this.key, this.value);
        return target;
    }
}

