/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkMinimumMaximumImageFilter_h
#define sitkMinimumMaximumImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class MinimumMaximumImageFilter
\brief Computes the minimum and the maximum intensity values of an image.

It is templated over input image type only.

This filter is automatically multi-threaded and can stream its input when NumberOfStreamDivisions is set to more than
\li The extrema are independently computed for each streamed and threaded region then merged.




\see StatisticsImageFilter

\sa itk::MinimumMaximumImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT MinimumMaximumImageFilter : public ImageFilter {
    public:
      using Self = MinimumMaximumImageFilter;

      /** Destructor */
      virtual ~MinimumMaximumImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      MinimumMaximumImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;

     /**
      * Return the computed Minimum.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMinimum() const { return this->m_Minimum; };

     /**
      * Return the computed Maximum.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetMaximum() const { return this->m_Maximum; };


      /** Name of this class */
      std::string GetName() const { return std::string ("MinimumMaximumImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      void Execute ( const Image & image );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = void (Self::*)( const Image * image );
      template <class TImageType> void ExecuteInternal ( const Image * image );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



      double m_Minimum{0.0};

      double m_Maximum{0.0};


    };


}
#endif
