/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.lucene;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.knn.profile.KNNProfileUtil;
import org.opensearch.search.profile.query.QueryProfiler;

public class LuceneEngineKnnVectorQuery
extends Query {
    @Generated
    private static final Logger log = LogManager.getLogger(LuceneEngineKnnVectorQuery.class);
    private final Query luceneQuery;

    public Query rewrite(IndexSearcher indexSearcher) {
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        QueryProfiler profiler = KNNProfileUtil.getProfiler(searcher);
        if (profiler != null) {
            profiler.getQueryBreakdown((Object)this.luceneQuery);
        }
        Query rewrittenQuery = this.luceneQuery.rewrite(searcher);
        Weight weight = rewrittenQuery.createWeight(searcher, scoreMode, boost);
        if (profiler != null) {
            profiler.pollLastElement();
        }
        return weight;
    }

    public String toString(String s) {
        return this.luceneQuery.toString();
    }

    public void visit(QueryVisitor queryVisitor) {
        queryVisitor.visitLeaf((Query)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LuceneEngineKnnVectorQuery otherQuery = (LuceneEngineKnnVectorQuery)((Object)o);
        return this.luceneQuery.equals((Object)otherQuery.luceneQuery);
    }

    public int hashCode() {
        return this.luceneQuery.hashCode();
    }

    @Generated
    public LuceneEngineKnnVectorQuery(Query luceneQuery) {
        this.luceneQuery = luceneQuery;
    }

    @Generated
    public Query getLuceneQuery() {
        return this.luceneQuery;
    }
}

