/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.geospatial.ip2geo.common.ParameterValidator;

public class UpdateDatasourceRequest
extends ActionRequest {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateDatasourceRequest.class);
    public static final ParseField ENDPOINT_FIELD = new ParseField("endpoint", new String[0]);
    public static final ParseField UPDATE_INTERVAL_IN_DAYS_FIELD = new ParseField("update_interval_in_days", new String[0]);
    private static final int MAX_DATASOURCE_NAME_BYTES = 255;
    private static final ParameterValidator VALIDATOR = new ParameterValidator();
    private String name;
    private String endpoint;
    private TimeValue updateInterval;
    public static final ObjectParser<UpdateDatasourceRequest, Void> PARSER = new ObjectParser("update_datasource");

    public UpdateDatasourceRequest(String name) {
        this.name = name;
    }

    public UpdateDatasourceRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.endpoint = in.readOptionalString();
        this.updateInterval = in.readOptionalTimeValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeOptionalString(this.endpoint);
        out.writeOptionalTimeValue(this.updateInterval);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException errors = new ActionRequestValidationException();
        if (!VALIDATOR.validateDatasourceName(this.name).isEmpty()) {
            errors.addValidationError("no such datasource exist");
        }
        if (this.endpoint == null && this.updateInterval == null) {
            errors.addValidationError("no values to update");
        }
        this.validateEndpoint(errors);
        this.validateUpdateInterval(errors);
        return errors.validationErrors().isEmpty() ? null : errors;
    }

    private void validateEndpoint(ActionRequestValidationException errors) {
        if (this.endpoint == null) {
            return;
        }
        try {
            URL url = URI.create(this.endpoint).toURL();
            url.toURI();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            log.info("Invalid URL[{}] is provided", (Object)this.endpoint, (Object)e);
            errors.addValidationError("Invalid URL format is provided");
        }
    }

    private void validateUpdateInterval(ActionRequestValidationException errors) {
        if (this.updateInterval == null) {
            return;
        }
        if (this.updateInterval.compareTo(TimeValue.timeValueDays((long)1L)) < 0) {
            errors.addValidationError("Update interval should be equal to or larger than 1 day");
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public TimeValue getUpdateInterval() {
        return this.updateInterval;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setUpdateInterval(TimeValue updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateDatasourceRequest)) {
            return false;
        }
        UpdateDatasourceRequest other = (UpdateDatasourceRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        TimeValue this$updateInterval = this.getUpdateInterval();
        TimeValue other$updateInterval = other.getUpdateInterval();
        return !(this$updateInterval == null ? other$updateInterval != null : !this$updateInterval.equals(other$updateInterval));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateDatasourceRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        TimeValue $updateInterval = this.getUpdateInterval();
        result = result * 59 + ($updateInterval == null ? 43 : $updateInterval.hashCode());
        return result;
    }

    static {
        PARSER.declareString((request, val) -> request.setEndpoint((String)val), ENDPOINT_FIELD);
        PARSER.declareLong((request, val) -> request.setUpdateInterval(TimeValue.timeValueDays((long)val)), UPDATE_INTERVAL_IN_DAYS_FIELD);
    }
}

