/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClipboardItem.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ClipboardItem::PresentationStyle enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("unspecified"),
        MAKE_STATIC_STRING_IMPL("inline"),
        MAKE_STATIC_STRING_IMPL("attachment"),
    };
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Unspecified) == 0, "ClipboardItem::PresentationStyle::Unspecified is not 0 as expected");
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Inline) == 1, "ClipboardItem::PresentationStyle::Inline is not 1 as expected");
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Attachment) == 2, "ClipboardItem::PresentationStyle::Attachment is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ClipboardItem::PresentationStyle enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ClipboardItem::PresentationStyle> parseEnumerationFromString<ClipboardItem::PresentationStyle>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ClipboardItem::PresentationStyle>, 3> mappings {
        std::pair<ComparableASCIILiteral, ClipboardItem::PresentationStyle> { "attachment"_s, ClipboardItem::PresentationStyle::Attachment },
        std::pair<ComparableASCIILiteral, ClipboardItem::PresentationStyle> { "inline"_s, ClipboardItem::PresentationStyle::Inline },
        std::pair<ComparableASCIILiteral, ClipboardItem::PresentationStyle> { "unspecified"_s, ClipboardItem::PresentationStyle::Unspecified },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ClipboardItem::PresentationStyle> parseEnumeration<ClipboardItem::PresentationStyle>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ClipboardItem::PresentationStyle>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ClipboardItem::PresentationStyle>()
{
    return "\"unspecified\", \"inline\", \"attachment\""_s;
}

template<> ConversionResult<IDLDictionary<ClipboardItem::Options>> convertDictionary<ClipboardItem::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ClipboardItem::Options result;
    JSValue presentationStyleValue;
    if (isNullOrUndefined)
        presentationStyleValue = jsUndefined();
    else {
        presentationStyleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "presentationStyle"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto presentationStyleConversionResult = convertOptionalWithDefault<IDLEnumeration<ClipboardItem::PresentationStyle>>(lexicalGlobalObject, presentationStyleValue, [&]() -> ConversionResult<IDLEnumeration<ClipboardItem::PresentationStyle>> { return Converter<IDLEnumeration<ClipboardItem::PresentationStyle>>::ReturnType { ClipboardItem::PresentationStyle::Unspecified }; });
    if (presentationStyleConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.presentationStyle = presentationStyleConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsClipboardItemPrototypeFunction_getType);
static JSC_DECLARE_HOST_FUNCTION(jsClipboardItemConstructorFunction_supports);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsClipboardItemConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsClipboardItem_types);
static JSC_DECLARE_CUSTOM_GETTER(jsClipboardItem_presentationStyle);

class JSClipboardItemPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSClipboardItemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSClipboardItemPrototype* ptr = new (NotNull, JSC::allocateCell<JSClipboardItemPrototype>(vm)) JSClipboardItemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardItemPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSClipboardItemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardItemPrototype, JSClipboardItemPrototype::Base);

using JSClipboardItemDOMConstructor = JSDOMConstructor<JSClipboardItem>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSClipboardItemConstructorTableValues {
    HashTableValue { "supports"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardItemConstructorFunction_supports, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSClipboardItemDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSClipboardItemDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto itemsConversionResult = convert<IDLRecord<IDLDOMString, IDLPromise<IDLUnion<IDLDOMString, IDLInterface<Blob>>>>>(*lexicalGlobalObject, argument0.value());
    if (itemsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<ClipboardItem::Options>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = ClipboardItem::create(itemsConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ClipboardItem>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ClipboardItem>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSClipboardItemDOMConstructorConstruct, JSClipboardItemDOMConstructor::construct);

template<> const ClassInfo JSClipboardItemDOMConstructor::s_info = { "ClipboardItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItemDOMConstructor) };

template<> JSValue JSClipboardItemDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSClipboardItemDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ClipboardItem"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSClipboardItem::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSClipboardItem::info(), JSClipboardItemConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSClipboardItemPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardItemConstructor, 0 } },
    HashTableValue { "types"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardItem_types, 0 } },
    HashTableValue { "presentationStyle"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardItem_presentationStyle, 0 } },
    HashTableValue { "getType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardItemPrototypeFunction_getType, 1 } },
};

const ClassInfo JSClipboardItemPrototype::s_info = { "ClipboardItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItemPrototype) };

void JSClipboardItemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSClipboardItem::info(), JSClipboardItemPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSClipboardItem::s_info = { "ClipboardItem"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItem) };

JSClipboardItem::JSClipboardItem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ClipboardItem>&& impl)
    : JSDOMWrapper<ClipboardItem>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ClipboardItem>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSClipboardItem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSClipboardItemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSClipboardItemPrototype::create(vm, &globalObject, structure);
}

JSObject* JSClipboardItem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSClipboardItem>(vm, globalObject);
}

JSValue JSClipboardItem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClipboardItemDOMConstructor, DOMConstructorID::ClipboardItem>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSClipboardItem::destroy(JSC::JSCell* cell)
{
    JSClipboardItem* thisObject = static_cast<JSClipboardItem*>(cell);
    thisObject->JSClipboardItem::~JSClipboardItem();
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardItemConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSClipboardItemPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSClipboardItem::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsClipboardItem_typesGetter(JSGlobalObject& lexicalGlobalObject, JSClipboardItem& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.types())));
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardItem_types, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSClipboardItem>::get<jsClipboardItem_typesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsClipboardItem_presentationStyleGetter(JSGlobalObject& lexicalGlobalObject, JSClipboardItem& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ClipboardItem::PresentationStyle>>(lexicalGlobalObject, throwScope, impl.presentationStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardItem_presentationStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSClipboardItem>::get<jsClipboardItem_presentationStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsClipboardItemPrototypeFunction_getTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboardItem>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<Blob>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getType(typeConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardItemPrototypeFunction_getType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSClipboardItem>::call<jsClipboardItemPrototypeFunction_getTypeBody>(*lexicalGlobalObject, *callFrame, "getType");
}

static inline JSC::EncodedJSValue jsClipboardItemConstructorFunction_supportsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, ClipboardItem::supports(typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardItemConstructorFunction_supports, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSClipboardItem>::callStatic<jsClipboardItemConstructorFunction_supportsBody>(*lexicalGlobalObject, *callFrame, "supports");
}

JSC::GCClient::IsoSubspace* JSClipboardItem::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSClipboardItem, UseCustomHeapCellType::No>(vm, "JSClipboardItem"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForClipboardItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForClipboardItem = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForClipboardItem.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForClipboardItem = std::forward<decltype(space)>(space); }
    );
}

void JSClipboardItem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSClipboardItem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSClipboardItemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsClipboardItem = jsCast<JSClipboardItem*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsClipboardItem->wrapped().navigator());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSClipboardItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsClipboardItem = static_cast<JSClipboardItem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsClipboardItem->protectedWrapped().ptr(), jsClipboardItem);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ClipboardItem@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13ClipboardItemE[]; }
#endif
template<std::same_as<ClipboardItem> T>
static inline void verifyVTable(ClipboardItem* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ClipboardItem@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13ClipboardItemE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ClipboardItem has subclasses. If ClipboardItem has subclasses that get passed
        // to toJS() we currently require ClipboardItem you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ClipboardItem>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ClipboardItem>(impl.ptr());
#endif
    return createWrapper<ClipboardItem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ClipboardItem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ClipboardItem* JSClipboardItem::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSClipboardItem*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
